/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeterplugins.har.gui;

import io.github.vdaburon.jmeter.har.HarForJMeter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.Load;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.save.SaveService;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarConvertorGui
extends AbstractAction
implements ActionListener,
UnsharedComponent,
MenuCreator,
Serializable {
    private static Set<String> commands = new HashSet<String>();
    private static final long serialVersionUID = 2433L;
    private static final Logger log = LoggerFactory.getLogger(HarConvertorGui.class);
    private static final String BROWSE_HAR_IN = "BROWSE_HAR_IN";
    private static final String BROWSE_JMX_OUT = "BROWSE_JMX_OUT";
    private static final String BROWSE_RECORD_OUT = "BROWSE_RECORD_OUT";
    private static final String BROWSE_EXTERNAL_FILE_IN = "BROWSE_EXTERNAL_FILE_IN";
    private static final String ACTION_CONVERT = "ACTION_CONVERT";
    private static final String ACTION_CONVERT_AND_LOAD_SCRIPT = "ACTION_CONVERT_LOAD";
    private static final String ACTION_MENU_TOOL = "ACTION_MENU_TOOL";
    private static final String ACTION_CHECKBOX_WEBSOCKET = "ACTION_CHECKBOX_WEBSOCKET";
    private EscapeDialog messageDialog;
    private JTextField fileHarInTextField;
    private JTextField fileJmxOutTextField;
    private JTextField fileRecordOutTextField;
    private JTextField externalFileInfoInField;
    private JTextField pauseBetweenUrlTextField;
    private JTextField pageStartNumberTextField;
    private JTextField samplerStartNumberTextField;
    private JButton fileHarInFileButton;
    private JTextField regexFilterIncludeField;
    private JTextField regexFilterExcludeField;
    private JButton fileJmxOutFileButton;
    private JButton fileRecordOutFileButton;
    private JButton externalFileInfoInButton;
    private JCheckBox isAddPauseCheckbox;
    private JCheckBox isRemoveCookieCheckbox;
    private JCheckBox isRemoveCacheRequestHeaderCheckbox;
    private JCheckBox isUseLrwrTransactionNameCheckbox;
    private JCheckBox isAddResultTreeRecordCheckbox;
    private JCheckBox isWebSocketPDoornboschCheckbox;
    private JButton btConvert;
    private JButton btConvertAndLoad;
    private String lastJFCDirectory;
    private JTextField labelStatus;

    public HarConvertorGui() {
        log.debug("Creating HarConvertorGui");
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public void doAction(ActionEvent e) throws IllegalUserActionException {
        HarConvertorGui harConvertorGui = new HarConvertorGui();
        MainFrame jfMainFrame = GuiPackage.getInstance().getMainFrame();
        harConvertorGui.showInputDialog((JFrame)jfMainFrame);
    }

    public void showInputDialog(JFrame parent) {
        this.setupInputDialog(parent);
        this.launchInputDialog();
    }

    private void launchInputDialog() {
        this.messageDialog.pack();
        ComponentUtil.centerComponentInWindow((Component)this.messageDialog);
        this.messageDialog.setVisible(true);
    }

    public void setupInputDialog(JFrame parent) {
        this.messageDialog = new EscapeDialog((Frame)parent, "vdn@github - HAR CONVERTOR TOOL", false);
        this.setupContentPane();
    }

    private void setupContentPane() {
        Container contentPane = this.messageDialog.getContentPane();
        contentPane.setLayout(new BorderLayout(0, 5));
        JPanel mainPanel = new JPanel(new BorderLayout());
        VerticalPanel vertPanel = new VerticalPanel();
        vertPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "HAR Convertor Configuration"));
        vertPanel.add((Component)this.setupFileChooserPanel());
        vertPanel.add((Component)this.createFilterAndPausePanel());
        vertPanel.add((Component)this.createCheckbox());
        vertPanel.add((Component)this.createControls());
        this.labelStatus = new JTextField("Waiting configuration ... ");
        this.labelStatus.setEditable(false);
        vertPanel.add((Component)this.labelStatus);
        mainPanel.add((Component)vertPanel);
        contentPane.add(mainPanel);
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        Exception except = null;
        if (command.equals(ACTION_MENU_TOOL)) {
            try {
                this.doAction(action);
            }
            catch (IllegalUserActionException e) {
                e.printStackTrace();
            }
        }
        if (command.equals(ACTION_CONVERT) || command.equals(ACTION_CONVERT_AND_LOAD_SCRIPT)) {
            File fExternalFileInfoIn;
            String fileHarIn = this.fileHarInTextField.getText();
            File fFileIn = new File(fileHarIn);
            if (!fFileIn.canRead()) {
                this.labelStatus.setText("Tool HAR Convertor Finished KO, CAN'T READ HAR fileHarIn = " + fileHarIn);
                this.labelStatus.setForeground(Color.RED);
                return;
            }
            String externalFileInfoIn = this.externalFileInfoInField.getText();
            if (!externalFileInfoIn.isEmpty() && !(fExternalFileInfoIn = new File(externalFileInfoIn)).canRead()) {
                this.labelStatus.setText("Tool HAR Convertor Finished KO, CAN'T READ CSV externalFileInfoIn = " + externalFileInfoIn);
                this.labelStatus.setForeground(Color.RED);
                return;
            }
            String fileJmxOut = this.fileJmxOutTextField.getText();
            String recordXmlOut = this.fileRecordOutTextField.getText();
            String regexFilterInclude = this.regexFilterIncludeField.getText();
            String regexFilterExclude = this.regexFilterExcludeField.getText();
            if (fileJmxOut.trim().isEmpty()) {
                fileJmxOut = fileHarIn.substring(0, fileHarIn.lastIndexOf(".")) + ".jmx";
            }
            if (regexFilterInclude.trim().isEmpty()) {
                regexFilterInclude = "";
            }
            boolean isAddPause = this.isAddPauseCheckbox.isSelected();
            String timeWaitBetweenUrls = this.pauseBetweenUrlTextField.getText();
            long createNewTransactionAfterRequestMs = 0L;
            if (!timeWaitBetweenUrls.isEmpty()) {
                try {
                    createNewTransactionAfterRequestMs = Integer.parseInt(timeWaitBetweenUrls);
                    if (isAddPause && createNewTransactionAfterRequestMs > 0L) {
                        isAddPause = true;
                    }
                }
                catch (Exception ex) {
                    log.warn("Error parsing long parameter , value = " + timeWaitBetweenUrls + ", set to 0");
                    createNewTransactionAfterRequestMs = 0L;
                }
            }
            String sPageStartNumber = this.pageStartNumberTextField.getText();
            int pageStartNumber = 1;
            if (!sPageStartNumber.isEmpty()) {
                try {
                    pageStartNumber = Integer.parseInt(sPageStartNumber);
                }
                catch (Exception ex) {
                    log.warn("Error parsing int parameter , value = " + sPageStartNumber + ", set to 1");
                    pageStartNumber = 1;
                }
            }
            if (pageStartNumber <= 0) {
                pageStartNumber = 1;
            }
            String sSamplerStartNumber = this.samplerStartNumberTextField.getText();
            int samplerStartNumber = 1;
            if (!sSamplerStartNumber.isEmpty()) {
                try {
                    samplerStartNumber = Integer.parseInt(sSamplerStartNumber);
                }
                catch (Exception ex) {
                    log.warn("Error parsing int parameter , value = " + sSamplerStartNumber + ", set to 1");
                    samplerStartNumber = 1;
                }
            }
            if (samplerStartNumber <= 0) {
                samplerStartNumber = 1;
            }
            boolean isRemoveCookieHeader = this.isRemoveCookieCheckbox.isSelected();
            boolean isRemoveCacheRequestHeader = this.isRemoveCacheRequestHeaderCheckbox.isSelected();
            boolean isAddResultTreeRecord = this.isAddResultTreeRecordCheckbox.isSelected();
            boolean isUseLrwrTransactionName = this.isUseLrwrTransactionNameCheckbox.isSelected();
            boolean isWebSocketPDoornbosch = this.isWebSocketPDoornboschCheckbox.isSelected();
            String lrwr_info = "";
            if (isUseLrwrTransactionName) {
                lrwr_info = "transaction_name";
            }
            try {
                this.btConvert.setEnabled(false);
                this.labelStatus.setText("Tool HAR Convert Running");
                log.info("Before HarForJMeter.generateJmxAndRecord");
                log.info("************* PARAMETERS ***************");
                log.info("fileHarIn=<" + fileHarIn + ">");
                log.info("fileJmxOut=<" + fileJmxOut + ">");
                log.info("recordXmlOut=<" + recordXmlOut + ">");
                log.info("isAddResultTreeRecord=<" + isAddResultTreeRecord + ">");
                log.info("isWebSocketPDoornbosch=<" + isWebSocketPDoornbosch + ">");
                log.info("createNewTransactionAfterRequestMs=<" + createNewTransactionAfterRequestMs + ">");
                log.info("isAddPause=<" + isAddPause + ">");
                log.info("regexFilterInclude=<" + regexFilterInclude + ">");
                log.info("regexFilterExclude=<" + regexFilterExclude + ">");
                log.info("isRemoveCookieHeader=<" + isRemoveCookieHeader + ">");
                log.info("samplerStartNumber=<" + samplerStartNumber + ">");
                log.info("samplerStartNumber=<" + samplerStartNumber + ">");
                log.info("lrwr_info=<" + lrwr_info + ">");
                log.info("externalFileInfoIn=<" + externalFileInfoIn + ">");
                log.info("****************************************");
                HarForJMeter.generateJmxAndRecord(fileHarIn, fileJmxOut, createNewTransactionAfterRequestMs, isAddPause, isRemoveCookieHeader, isRemoveCacheRequestHeader, regexFilterInclude, regexFilterExclude, recordXmlOut, pageStartNumber, samplerStartNumber, lrwr_info, externalFileInfoIn, isAddResultTreeRecord, isWebSocketPDoornbosch);
                log.info("After HarForJMeter.generateJmxAndRecord");
                this.btConvert.setEnabled(true);
                if (!recordXmlOut.isEmpty()) {
                    this.labelStatus.setText("Tool HAR Convertor Finished OK, fileJmxOut=" + fileJmxOut + " AND recordXmlOut=" + recordXmlOut);
                } else {
                    this.labelStatus.setText("Tool HAR Convertor Finished OK, fileJmxOut=" + fileJmxOut);
                }
                this.labelStatus.setForeground(Color.BLACK);
                if (command.equals(ACTION_CONVERT_AND_LOAD_SCRIPT)) {
                    HashTree tree = SaveService.loadTree((File)new File(fileJmxOut));
                    Load.insertLoadedTree((int)1, (HashTree)tree);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                except = e;
                this.btConvert.setEnabled(true);
                this.btConvertAndLoad.setEnabled(true);
                this.labelStatus.setText("Tool HAR Convertor Finished KO, exception = " + e);
                this.labelStatus.setForeground(Color.RED);
            }
            if (null == except) {
                this.btConvert.setEnabled(true);
            }
        }
        if (command.equals(BROWSE_HAR_IN)) {
            this.fileHarInTextField.setText(this.showFileChooser(this.fileHarInTextField.getParent(), this.fileHarInTextField, false, new String[]{".har"}));
            this.labelStatus.setText("Waiting configuration ... ");
            this.labelStatus.setForeground(Color.BLACK);
        }
        if (command.equals(BROWSE_JMX_OUT)) {
            this.fileJmxOutTextField.setText(this.showFileChooser(this.fileJmxOutTextField.getParent(), this.fileJmxOutTextField, false, new String[]{".jmx"}));
            this.labelStatus.setText("Waiting configuration ... ");
            this.labelStatus.setForeground(Color.BLACK);
        }
        if (command.equals(BROWSE_RECORD_OUT)) {
            this.fileRecordOutTextField.setText(this.showFileChooser(this.fileRecordOutTextField.getParent(), this.fileRecordOutTextField, false, new String[]{".xml"}));
            this.labelStatus.setText("Waiting configuration ... ");
            this.labelStatus.setForeground(Color.BLACK);
        }
        if (command.equals(BROWSE_EXTERNAL_FILE_IN)) {
            this.externalFileInfoInField.setText(this.showFileChooser(this.externalFileInfoInField.getParent(), this.externalFileInfoInField, false, new String[]{".csv"}));
            this.labelStatus.setText("Waiting configuration ... ");
            this.labelStatus.setForeground(Color.BLACK);
        }
        if (command.equals(ACTION_CHECKBOX_WEBSOCKET)) {
            boolean isWSChecked = this.isWebSocketPDoornboschCheckbox.isSelected();
            if (isWSChecked) {
                try {
                    Class.forName("eu.luminis.jmeter.wssampler.WebsocketGeneralSampler");
                    log.info("plugin \"WebSocket Samplers by Peter Doornbosch\" is present");
                }
                catch (ClassNotFoundException ex) {
                    this.labelStatus.setText("You must install the plugin 'WebSocket Samplers by Peter Doornbosch' to open the JMeter generated script file");
                    this.labelStatus.setForeground(Color.RED);
                    this.btConvertAndLoad.setEnabled(false);
                }
            } else {
                this.labelStatus.setText("Waiting configuration ... ");
                this.labelStatus.setForeground(Color.BLACK);
                this.btConvertAndLoad.setEnabled(true);
            }
        }
    }

    private JPanel createControls() {
        this.btConvert = new JButton("CONVERT");
        this.btConvert.addActionListener(this);
        this.btConvert.setActionCommand(ACTION_CONVERT);
        this.btConvert.setEnabled(true);
        this.btConvertAndLoad = new JButton("CONVERT AND LOAD GENERATED SCRIPT");
        this.btConvertAndLoad.addActionListener(this);
        this.btConvertAndLoad.setActionCommand(ACTION_CONVERT_AND_LOAD_SCRIPT);
        this.btConvertAndLoad.setEnabled(true);
        JPanel panel = new JPanel();
        panel.add(this.btConvertAndLoad);
        panel.add(this.btConvert);
        return panel;
    }

    private JPanel createFilterAndPausePanel() {
        JPanel panel = new JPanel(new GridLayout(0, 2));
        JLabel regexFilterIncludeLabel = new JLabel("(Optional) Regular expression matches for filter Include URL");
        this.regexFilterIncludeField = new JTextField("", 80);
        JLabel regexFilterExcludeLabel = new JLabel("(Optional) Regular expression matches for filter Exclude URL");
        this.regexFilterExcludeField = new JTextField("", 80);
        JLabel pauseBetweenUrlLabel = new JLabel("(Optional) Time (ms) between 2 URLs to create a new page (Transaction Controller)");
        this.pauseBetweenUrlTextField = new JTextField("5000", 80);
        JLabel pageStartNumberLabel = new JLabel("(Optional) Page start number usually for partial recording (default 1)");
        this.pageStartNumberTextField = new JTextField("", 80);
        JLabel samplerStartNumberLabel = new JLabel("(Optional) Sampler start number usually for partial recording (default 1)");
        this.samplerStartNumberTextField = new JTextField("", 80);
        panel.add(pauseBetweenUrlLabel);
        panel.add(this.pauseBetweenUrlTextField);
        panel.add(pageStartNumberLabel);
        panel.add(this.pageStartNumberTextField);
        panel.add(samplerStartNumberLabel);
        panel.add(this.samplerStartNumberTextField);
        panel.add(regexFilterIncludeLabel);
        panel.add(this.regexFilterIncludeField);
        panel.add(regexFilterExcludeLabel);
        panel.add(this.regexFilterExcludeField);
        return panel;
    }

    private JPanel createCheckbox() {
        JPanel panel = new JPanel(new GridLayout(0, 2));
        JLabel isWebSocketPDoornboschLabel = new JLabel("(Optional) Create WebSocket Sampler if HAR contains WebSocket Connection (default false)");
        this.isWebSocketPDoornboschCheckbox = new JCheckBox("", false);
        this.isWebSocketPDoornboschCheckbox.addActionListener(this);
        this.isWebSocketPDoornboschCheckbox.setActionCommand(ACTION_CHECKBOX_WEBSOCKET);
        this.isWebSocketPDoornboschCheckbox.setEnabled(true);
        JLabel isAddPauseLabel = new JLabel("(Optional) Add a pause between Transaction Controller (default true), time between 2 URLs must be > 0");
        this.isAddPauseCheckbox = new JCheckBox("", true);
        JLabel isRemoveCookieLabel = new JLabel("(Optional) Remove cookie in http header (default true because add a Cookie Manager)");
        this.isRemoveCookieCheckbox = new JCheckBox("", true);
        JLabel isRemoveCacheHeaderLabel = new JLabel("(Optional) Remove cache header in the http request (default true because add a Cache Manager)");
        this.isRemoveCacheRequestHeaderCheckbox = new JCheckBox("", true);
        JLabel isAddResultTreeRecordLabel = new JLabel("(Optional) Add 'View Result Tree' to view the recording xml file created (default true)");
        this.isAddResultTreeRecordCheckbox = new JCheckBox("", true);
        JLabel isUseLrwrTransactionNameLabel = new JLabel("(Optional) HAR was generated with LoadRunner Web Recorder and Transaction Names (default false)");
        this.isUseLrwrTransactionNameCheckbox = new JCheckBox("", false);
        panel.add(isWebSocketPDoornboschLabel);
        panel.add(this.isWebSocketPDoornboschCheckbox);
        panel.add(isAddPauseLabel);
        panel.add(this.isAddPauseCheckbox);
        panel.add(isRemoveCookieLabel);
        panel.add(this.isRemoveCookieCheckbox);
        panel.add(isRemoveCacheHeaderLabel);
        panel.add(this.isRemoveCacheRequestHeaderCheckbox);
        panel.add(isAddResultTreeRecordLabel);
        panel.add(this.isAddResultTreeRecordCheckbox);
        panel.add(isUseLrwrTransactionNameLabel);
        panel.add(this.isUseLrwrTransactionNameCheckbox);
        return panel;
    }

    private JPanel setupFileChooserPanel() {
        JPanel fileChooserPanel = new JPanel(new GridLayout(0, 3));
        fileChooserPanel.add(new JLabel("HAR file in (to read) : "));
        this.fileHarInTextField = new JTextField();
        fileChooserPanel.add(this.fileHarInTextField);
        this.fileHarInFileButton = new JButton("Browse ...");
        this.fileHarInFileButton.setActionCommand(BROWSE_HAR_IN);
        this.fileHarInFileButton.addActionListener(this);
        fileChooserPanel.add(this.fileHarInFileButton);
        fileChooserPanel.add(new JLabel("JMeter script out (to write) (if empty default <har_in_no_extension>.jmx) : "));
        this.fileJmxOutTextField = new JTextField();
        fileChooserPanel.add(this.fileJmxOutTextField);
        this.fileJmxOutFileButton = new JButton("Browse ...");
        this.fileJmxOutFileButton.setActionCommand(BROWSE_JMX_OUT);
        this.fileJmxOutFileButton.addActionListener(this);
        fileChooserPanel.add(this.fileJmxOutFileButton);
        fileChooserPanel.add(new JLabel("(Optional) Record XML out (to write) : "));
        this.fileRecordOutTextField = new JTextField();
        fileChooserPanel.add(this.fileRecordOutTextField);
        this.fileRecordOutFileButton = new JButton("Browse ...");
        this.fileRecordOutFileButton.setActionCommand(BROWSE_RECORD_OUT);
        this.fileRecordOutFileButton.addActionListener(this);
        fileChooserPanel.add(this.fileRecordOutFileButton);
        fileChooserPanel.add(new JLabel("(Optional) External csv file with transaction info (to read) : "));
        this.externalFileInfoInField = new JTextField();
        fileChooserPanel.add(this.externalFileInfoInField);
        this.externalFileInfoInButton = new JButton("Browse ...");
        this.externalFileInfoInButton.setActionCommand(BROWSE_EXTERNAL_FILE_IN);
        this.externalFileInfoInButton.addActionListener(this);
        fileChooserPanel.add(this.externalFileInfoInButton);
        return fileChooserPanel;
    }

    private String showFileChooser(Component component, JTextField locationTextField, boolean onlyDirectory, String[] extensions) {
        JFileChooser jfc = new JFileChooser();
        if (onlyDirectory) {
            jfc.setFileSelectionMode(1);
        } else {
            jfc.setFileSelectionMode(0);
        }
        if (extensions != null && extensions.length > 0) {
            JMeterFileFilter currentFilter = new JMeterFileFilter(extensions);
            jfc.addChoosableFileFilter((FileFilter)currentFilter);
            jfc.setAcceptAllFileFilterUsed(true);
            jfc.setFileFilter((FileFilter)currentFilter);
        }
        if (this.lastJFCDirectory != null) {
            jfc.setCurrentDirectory(new File(this.lastJFCDirectory));
        } else {
            String start = System.getProperty("user.dir", "");
            if (!start.isEmpty()) {
                jfc.setCurrentDirectory(new File(start));
            }
        }
        int retVal = jfc.showOpenDialog(component);
        if (retVal == 0) {
            this.lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
            return jfc.getSelectedFile().getPath();
        }
        return locationTextField.getText();
    }

    public JMenuItem[] getMenuItemsAtLocation(MenuCreator.MENU_LOCATION location) {
        if (location != MenuCreator.MENU_LOCATION.TOOLS) {
            return new JMenuItem[0];
        }
        JMenuItem menuItem = new JMenuItem("vdn@github - HAR Convertor Tool", null);
        menuItem.setName("HAR Convertor Tool");
        menuItem.setActionCommand(ACTION_MENU_TOOL);
        menuItem.setAccelerator(null);
        menuItem.addActionListener(this);
        return new JMenuItem[]{menuItem};
    }

    public JMenu[] getTopLevelMenus() {
        return new JMenu[0];
    }

    public void localeChanged() {
    }

    public boolean localeChanged(MenuElement arg0) {
        return false;
    }

    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add(ACTION_MENU_TOOL);
    }
}

