/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har.websocket;

import de.sstoehr.harreader.model.HarContent;
import de.sstoehr.harreader.model.HarEntry;
import de.sstoehr.harreader.model.HarRequest;
import de.sstoehr.harreader.model.HarResponse;
import de.sstoehr.harreader.model.HarTiming;
import io.github.vdaburon.jmeter.har.Har2TestResultsXml;
import io.github.vdaburon.jmeter.har.Utils;
import io.github.vdaburon.jmeter.har.websocket.WebSocketMessage;
import io.github.vdaburon.jmeter.har.websocket.WebSocketRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebSocketPDoornboshResultXml {
    private static final Logger LOGGER = Logger.getLogger(WebSocketPDoornboshResultXml.class.getName());

    public static int createWsSample(Document document, Element eltTestResults, HarEntry harEntry, int num, WebSocketRequest webSocketRequest) throws URISyntaxException {
        HarRequest harRequest = harEntry.getRequest();
        HarResponse harResponse = harEntry.getResponse();
        Element eltSample = WebSocketPDoornboshResultXml.createEltSample(document, harEntry, num);
        Element eltRequestponseHeaders = Har2TestResultsXml.createRequestHeaders(document, harEntry.getRequest());
        eltSample.appendChild(eltRequestponseHeaders);
        Element eltResponseHeaders = Har2TestResultsXml.createResponseHeaders(document, harEntry.getResponse());
        eltSample.appendChild(eltResponseHeaders);
        Element eltcookies = Har2TestResultsXml.createCookies(document, harRequest);
        eltSample.appendChild(eltcookies);
        Element eltmethod = document.createElement("method");
        eltmethod = Har2TestResultsXml.addAttributeToElement(document, eltmethod, "class", "java.lang.String");
        String method = harRequest.getMethod().name();
        eltmethod.setTextContent(method);
        eltSample.appendChild(eltmethod);
        Element eltqueryString = document.createElement("queryString");
        eltqueryString = Har2TestResultsXml.addAttributeToElement(document, eltqueryString, "class", "java.lang.String");
        String queryString = "";
        if (harRequest.getQueryString().size() > 0) {
            queryString = new URI(harRequest.getUrl()).getQuery();
        }
        eltqueryString.setTextContent(queryString);
        eltSample.appendChild(eltqueryString);
        boolean isText = false;
        String dt_reponse = eltSample.getAttribute("dt");
        if ("text".equalsIgnoreCase(dt_reponse)) {
            isText = true;
        }
        Element eltResponseData = Har2TestResultsXml.createEltReponseData(document, harResponse, isText);
        eltSample.appendChild(eltResponseData);
        eltTestResults.appendChild(eltSample);
        int nbMessages = 0;
        if (webSocketRequest.getListWebSocketMessages() != null) {
            nbMessages = webSocketRequest.getListWebSocketMessages().size();
        }
        List<WebSocketMessage> lWebSocketMessages = webSocketRequest.getListWebSocketMessages();
        List<Integer> lListTypeExchange = webSocketRequest.getListTypeExchange();
        Element createEltSample = null;
        for (int i = 0; i < nbMessages; ++i) {
            WebSocketMessage webSocketMessage = lWebSocketMessages.get(i);
            int typeExchange = lListTypeExchange.get(i);
            createEltSample = null;
            if (2 == typeExchange) {
                createEltSample = WebSocketPDoornboshResultXml.createWsEltSample(document, webSocketMessage, webSocketMessage, 2, ++num);
            }
            if (3 == typeExchange) {
                createEltSample = WebSocketPDoornboshResultXml.createWsEltSample(document, webSocketMessage, webSocketMessage, 3, ++num);
            }
            if (1 == typeExchange && "receive".equals(webSocketMessage.getType())) {
                WebSocketMessage webSocketMessagePrevious = lWebSocketMessages.get(i - 1);
                createEltSample = WebSocketPDoornboshResultXml.createWsEltSample(document, webSocketMessagePrevious, webSocketMessage, 1, ++num);
            }
            if (createEltSample == null) continue;
            eltTestResults.appendChild(createEltSample);
        }
        return num;
    }

    public static Element createWsEltSample(Document document, WebSocketMessage webSocketMessageSend, WebSocketMessage webSocketMessageReceive, int typeWsEchange, int num) {
        long lTimeSend;
        LOGGER.fine("Begin createWsEltSample");
        LOGGER.fine("param : typeWsEchange = " + typeWsEchange + ", webSocketMessageSend = " + webSocketMessageSend + ", webSocketMessageReceive = " + webSocketMessageReceive);
        String t_time = "0";
        if (typeWsEchange == 1) {
            try {
                long lTimeReceive = Utils.dateIsoFormatToTimeLong(webSocketMessageReceive.getStartedDateTime());
                long lTimeSend2 = Utils.dateIsoFormatToTimeLong(webSocketMessageSend.getStartedDateTime());
                long lDelta = lTimeReceive - lTimeSend2;
                t_time = "" + lDelta;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (typeWsEchange == 2 || typeWsEchange == 3) {
            t_time = "0";
        }
        String it_time = "0";
        String lt_time = "0";
        String ct_time = "0";
        String ts_time = "0";
        if (typeWsEchange == 1) {
            try {
                lTimeSend = Utils.dateIsoFormatToTimeLong(webSocketMessageSend.getStartedDateTime());
                ts_time = "" + lTimeSend;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (typeWsEchange == 2) {
            try {
                lTimeSend = Utils.dateIsoFormatToTimeLong(webSocketMessageSend.getStartedDateTime());
                ts_time = "" + lTimeSend;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (typeWsEchange == 3) {
            try {
                long lTimeReceive = Utils.dateIsoFormatToTimeLong(webSocketMessageReceive.getStartedDateTime());
                ts_time = "" + lTimeReceive;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        String s_response = "true";
        String lb_label = "";
        if (typeWsEchange == 1) {
            lb_label = String.format("%03d - WebSocket request-response Sampler", num);
        }
        if (typeWsEchange == 2) {
            lb_label = String.format("%03d - WebSocket Single Write Sampler", num);
        }
        if (typeWsEchange == 3) {
            lb_label = String.format("%03d - WebSocket Single Read Sampler", num);
        }
        String rc_response = "200";
        String rm_response = "OK";
        String dt_response = "text";
        String by_response = "0";
        if (typeWsEchange == 1 || typeWsEchange == 3) {
            by_response = "" + webSocketMessageReceive.getData().length();
        }
        String sby_request = "0";
        if (typeWsEchange == 1 || typeWsEchange == 2) {
            sby_request = "" + webSocketMessageSend.getData().length();
        }
        String ng_count = "1";
        String na_count = "1";
        String hn = "browser";
        Element eltSample = document.createElement("sample");
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "t", t_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "it", it_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "lt", lt_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "ct", ct_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "ts", ts_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "s", s_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "lb", lb_label);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "rc", rc_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "rm", rm_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "dt", dt_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "by", by_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "sby", sby_request);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "ng", ng_count);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "na", na_count);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "hn", hn);
        Element eltResponseHeader = document.createElement("responseHeader");
        eltResponseHeader = Har2TestResultsXml.addAttributeToElement(document, eltResponseHeader, "class", "java.lang.String");
        eltSample.appendChild(eltResponseHeader);
        Element eltRequestHeader = document.createElement("requestHeader");
        eltRequestHeader = Har2TestResultsXml.addAttributeToElement(document, eltRequestHeader, "class", "java.lang.String");
        eltSample.appendChild(eltRequestHeader);
        Element eltresponseData = document.createElement("responseData");
        eltresponseData = Har2TestResultsXml.addAttributeToElement(document, eltresponseData, "class", "java.lang.String");
        if (typeWsEchange == 1 || typeWsEchange == 3) {
            eltresponseData.setTextContent(webSocketMessageReceive.getData());
        }
        eltSample.appendChild(eltresponseData);
        Element eltsamplerData = document.createElement("samplerData");
        eltsamplerData = Har2TestResultsXml.addAttributeToElement(document, eltsamplerData, "class", "java.lang.String");
        if (typeWsEchange == 1 || typeWsEchange == 2) {
            eltsamplerData.setTextContent(webSocketMessageSend.getData());
        }
        eltSample.appendChild(eltsamplerData);
        LOGGER.fine("End   createWsEltSample");
        return eltSample;
    }

    protected static Element createEltSample(Document document, HarEntry harEntry, int num) throws URISyntaxException {
        HarTiming harTimings = harEntry.getTimings();
        HarResponse harResponse = harEntry.getResponse();
        HarRequest harRequest = harEntry.getRequest();
        HarContent harContent = harResponse.getContent();
        String t_time = "" + harEntry.getTime();
        String it_time = "0";
        String lt_time = "" + harTimings.getWait();
        String ct_time = "" + harTimings.getConnect();
        String ts_time = "" + harEntry.getStartedDateTime().getTime();
        String s_response = "true";
        if (harResponse.getStatus() >= 400) {
            s_response = "false";
        }
        URI urlRequest = new URI(harRequest.getUrl());
        String lb_label = String.format("%03d - " + urlRequest.toString(), num);
        String rc_response = "" + harResponse.getStatus();
        String rm_response = harResponse.getStatusText();
        String urlPath = urlRequest.getPath();
        String dt_response = Har2TestResultsXml.textFromMimeType(harContent.getMimeType(), urlPath);
        String de_response = Har2TestResultsXml.responseEncoding(harResponse);
        String by_response = "" + harContent.getSize();
        String sby_request = "" + harRequest.getBodySize();
        String sc_count = "1";
        String ec_count = "0";
        String ng_count = "0";
        String na_count = "0";
        String hn = "browser";
        Element eltSample = document.createElement("sample");
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "t", t_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "it", it_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "lt", lt_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "ct", ct_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "ts", ts_time);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "s", s_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "lb", lb_label);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "rc", rc_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "rm", rm_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "dt", dt_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "de", de_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "by", by_response);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "sby", sby_request);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "sc", sc_count);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "ec", ec_count);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "ng", ng_count);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "na", na_count);
        eltSample = Har2TestResultsXml.addAttributeToElement(document, eltSample, "hn", hn);
        return eltSample;
    }
}

