/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har.websocket;

import io.github.vdaburon.jmeter.har.XmlJmx;
import io.github.vdaburon.jmeter.har.websocket.UtilsWebSocket;
import io.github.vdaburon.jmeter.har.websocket.WebSocketMessage;
import io.github.vdaburon.jmeter.har.websocket.WebSocketRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebSocketPDoornboschXmlJmx {
    private static final Logger LOGGER = Logger.getLogger(WebSocketPDoornboschXmlJmx.class.getName());

    public static int createWebSocketPDoornboschTree(Document document, Element hashTreeForTc, String testname, String scheme, String host, int iPort, int httpSamplernum, WebSocketRequest webSocketRequest) throws URISyntaxException {
        Element eltOpenWebSocketSampler = document.createElement("eu.luminis.jmeter.wssampler.OpenWebSocketSampler");
        Attr attrGuiclass = document.createAttribute("guiclass");
        attrGuiclass.setValue("eu.luminis.jmeter.wssampler.OpenWebSocketSamplerGui");
        eltOpenWebSocketSampler.setAttributeNode(attrGuiclass);
        Attr attrTestclass = document.createAttribute("testclass");
        attrTestclass.setValue("eu.luminis.jmeter.wssampler.OpenWebSocketSampler");
        eltOpenWebSocketSampler.setAttributeNode(attrTestclass);
        URI url = new URI(webSocketRequest.getUrl());
        String testnameNew = String.format("%03d - WebSocket Open Connection %s", --httpSamplernum, url.getPath());
        Attr attrTestname = document.createAttribute("testname");
        attrTestname.setValue(testnameNew);
        eltOpenWebSocketSampler.setAttributeNode(attrTestname);
        Attr attrEnabled = document.createAttribute("enabled");
        attrEnabled.setValue("true");
        eltOpenWebSocketSampler.setAttributeNode(attrEnabled);
        String hostInter = "";
        hostInter = url.getHost();
        int defautPort = 443;
        boolean isTLS = true;
        if ("ws".equalsIgnoreCase(url.getScheme())) {
            defautPort = 80;
            isTLS = false;
        }
        if ("wss".equalsIgnoreCase(url.getScheme())) {
            defautPort = 443;
            isTLS = true;
        }
        String sPortInter = "";
        int port = url.getPort() == -1 ? defautPort : url.getPort();
        sPortInter = "" + port;
        Element boolProp1 = XmlJmx.createProperty(document, "boolProp", "TLS", Boolean.toString(isTLS));
        eltOpenWebSocketSampler.appendChild(boolProp1);
        Element stringProp2 = XmlJmx.createProperty(document, "stringProp", "server", hostInter);
        eltOpenWebSocketSampler.appendChild(stringProp2);
        Element stringProp3 = XmlJmx.createProperty(document, "stringProp", "port", sPortInter);
        eltOpenWebSocketSampler.appendChild(stringProp3);
        Element stringProp4 = XmlJmx.createProperty(document, "stringProp", "path", url.getPath());
        eltOpenWebSocketSampler.appendChild(stringProp4);
        Element stringProp5 = XmlJmx.createProperty(document, "stringProp", "connectTimeout", "20000");
        eltOpenWebSocketSampler.appendChild(stringProp5);
        Element stringProp6 = XmlJmx.createProperty(document, "stringProp", "readTimeout", "6000");
        eltOpenWebSocketSampler.appendChild(stringProp6);
        hashTreeForTc.appendChild(eltOpenWebSocketSampler);
        hashTreeForTc.appendChild(XmlJmx.createHashTree(document));
        int nbMessages = 0;
        if (webSocketRequest.getListWebSocketMessages() != null) {
            nbMessages = webSocketRequest.getListWebSocketMessages().size();
        }
        List<WebSocketMessage> lWebSocketMessages = webSocketRequest.getListWebSocketMessages();
        List<Integer> lListTypeExchange = webSocketRequest.getListTypeExchange();
        Element eltWebSocketSampler = null;
        for (int i = 0; i < nbMessages; ++i) {
            eltWebSocketSampler = null;
            WebSocketMessage webSocketMessage = lWebSocketMessages.get(i);
            int typeExchange = lListTypeExchange.get(i);
            if (2 == typeExchange) {
                eltWebSocketSampler = WebSocketPDoornboschXmlJmx.createSingleWriteWebSocketSampler(document, ++httpSamplernum, webSocketMessage);
            }
            if (3 == typeExchange) {
                eltWebSocketSampler = WebSocketPDoornboschXmlJmx.createSingleReadWebSocketSampler(document, ++httpSamplernum, webSocketMessage);
            }
            if (1 == typeExchange && "send".equals(webSocketMessage.getType())) {
                eltWebSocketSampler = WebSocketPDoornboschXmlJmx.createRequestResponseWebSocketSampler(document, ++httpSamplernum, webSocketMessage);
            }
            if (eltWebSocketSampler == null) continue;
            hashTreeForTc.appendChild(eltWebSocketSampler);
            hashTreeForTc.appendChild(XmlJmx.createHashTree(document));
        }
        Element eltCloseWebSocket = WebSocketPDoornboschXmlJmx.createcloseWebSocket(document, ++httpSamplernum);
        hashTreeForTc.appendChild(eltCloseWebSocket);
        hashTreeForTc.appendChild(XmlJmx.createHashTree(document));
        return httpSamplernum;
    }

    public static Element createRequestResponseWebSocketSampler(Document document, int httpSamplernum, WebSocketMessage webSocketMessage) {
        LOGGER.fine("Begin createRequestResponseWebSocketSampler");
        LOGGER.fine("param webSocketMessage=" + webSocketMessage);
        Element eltReqResWSSampler = document.createElement("eu.luminis.jmeter.wssampler.RequestResponseWebSocketSampler");
        Attr attrGuiclass = document.createAttribute("guiclass");
        attrGuiclass.setValue("eu.luminis.jmeter.wssampler.RequestResponseWebSocketSamplerGui");
        eltReqResWSSampler.setAttributeNode(attrGuiclass);
        Attr attrTestclass = document.createAttribute("testclass");
        attrTestclass.setValue("eu.luminis.jmeter.wssampler.RequestResponseWebSocketSampler");
        eltReqResWSSampler.setAttributeNode(attrTestclass);
        String testname = String.format("%03d - WebSocket request-response Sampler", httpSamplernum);
        Attr attrTestname = document.createAttribute("testname");
        attrTestname.setValue(testname);
        eltReqResWSSampler.setAttributeNode(attrTestname);
        Attr attrEnabled = document.createAttribute("enabled");
        attrEnabled.setValue("true");
        eltReqResWSSampler.setAttributeNode(attrEnabled);
        Element boolProp1 = XmlJmx.createProperty(document, "boolProp", "createNewConnection", "false");
        eltReqResWSSampler.appendChild(boolProp1);
        Element stringProp7 = XmlJmx.createProperty(document, "stringProp", "payloadType", UtilsWebSocket.getPayLoadType(webSocketMessage.getData()));
        eltReqResWSSampler.appendChild(stringProp7);
        Element stringProp8 = XmlJmx.createProperty(document, "stringProp", "requestData", UtilsWebSocket.filterData(webSocketMessage.getData()));
        eltReqResWSSampler.appendChild(stringProp8);
        Element stringProp9 = XmlJmx.createProperty(document, "stringProp", "readTimeout", "10000");
        eltReqResWSSampler.appendChild(stringProp9);
        Element boolProp10 = XmlJmx.createProperty(document, "boolProp", "loadDataFromFile", "false");
        eltReqResWSSampler.appendChild(boolProp10);
        LOGGER.fine("End   createRequestResponseWebSocketSampler");
        return eltReqResWSSampler;
    }

    public static Element createSingleReadWebSocketSampler(Document document, int httpSamplernum, WebSocketMessage webSocketMessage) {
        LOGGER.fine("Begin createSingleReadWebSocketSampler");
        LOGGER.fine("param webSocketMessage=" + webSocketMessage);
        Element eltSingleReadWSSampler = document.createElement("eu.luminis.jmeter.wssampler.SingleReadWebSocketSampler");
        Attr attrGuiclass = document.createAttribute("guiclass");
        attrGuiclass.setValue("eu.luminis.jmeter.wssampler.SingleReadWebSocketSamplerGui");
        eltSingleReadWSSampler.setAttributeNode(attrGuiclass);
        Attr attrTestclass = document.createAttribute("testclass");
        attrTestclass.setValue("eu.luminis.jmeter.wssampler.SingleReadWebSocketSampler");
        eltSingleReadWSSampler.setAttributeNode(attrTestclass);
        String testname = String.format("%03d - WebSocket Single Read Sampler", httpSamplernum);
        Attr attrTestname = document.createAttribute("testname");
        attrTestname.setValue(testname);
        eltSingleReadWSSampler.setAttributeNode(attrTestname);
        Attr attrEnabled = document.createAttribute("enabled");
        attrEnabled.setValue("true");
        eltSingleReadWSSampler.setAttributeNode(attrEnabled);
        Element stringProp6 = XmlJmx.createProperty(document, "stringProp", "dataType", "Text");
        eltSingleReadWSSampler.appendChild(stringProp6);
        Element boolProp7 = XmlJmx.createProperty(document, "boolProp", "createNewConnection", "false");
        eltSingleReadWSSampler.appendChild(boolProp7);
        Element stringProp8 = XmlJmx.createProperty(document, "stringProp", "readTimeout", "6000");
        eltSingleReadWSSampler.appendChild(stringProp8);
        Element boolProp9 = XmlJmx.createProperty(document, "boolProp", "optional", "false");
        eltSingleReadWSSampler.appendChild(boolProp9);
        LOGGER.fine("End   createSingleReadWebSocketSampler");
        return eltSingleReadWSSampler;
    }

    public static Element createSingleWriteWebSocketSampler(Document document, int httpSamplernum, WebSocketMessage webSocketMessage) {
        LOGGER.fine("Begin createSingleWriteWebSocketSampler");
        LOGGER.fine("param webSocketMessage=" + webSocketMessage);
        Element eltSingleWriteWSSampler = document.createElement("eu.luminis.jmeter.wssampler.SingleWriteWebSocketSampler");
        Attr attrGuiclass = document.createAttribute("guiclass");
        attrGuiclass.setValue("eu.luminis.jmeter.wssampler.SingleWriteWebSocketSamplerGui");
        eltSingleWriteWSSampler.setAttributeNode(attrGuiclass);
        Attr attrTestclass = document.createAttribute("testclass");
        attrTestclass.setValue("eu.luminis.jmeter.wssampler.SingleWriteWebSocketSampler");
        eltSingleWriteWSSampler.setAttributeNode(attrTestclass);
        String testname = String.format("%03d - WebSocket Single Write Sampler", httpSamplernum);
        Attr attrTestname = document.createAttribute("testname");
        attrTestname.setValue(testname);
        eltSingleWriteWSSampler.setAttributeNode(attrTestname);
        Attr attrEnabled = document.createAttribute("enabled");
        attrEnabled.setValue("true");
        eltSingleWriteWSSampler.setAttributeNode(attrEnabled);
        Element stringProp6 = XmlJmx.createProperty(document, "stringProp", "payloadType", UtilsWebSocket.getPayLoadType(webSocketMessage.getData()));
        eltSingleWriteWSSampler.appendChild(stringProp6);
        Element stringProp7 = XmlJmx.createProperty(document, "stringProp", "requestData", UtilsWebSocket.filterData(webSocketMessage.getData()));
        eltSingleWriteWSSampler.appendChild(stringProp7);
        Element boolProp8 = XmlJmx.createProperty(document, "boolProp", "createNewConnection", "false");
        eltSingleWriteWSSampler.appendChild(boolProp8);
        Element boolProp9 = XmlJmx.createProperty(document, "boolProp", "loadDataFromFile", "false");
        eltSingleWriteWSSampler.appendChild(boolProp9);
        LOGGER.fine("End   createSingleWriteWebSocketSampler");
        return eltSingleWriteWSSampler;
    }

    public static Element createcloseWebSocket(Document document, int httpSamplernum) {
        Element eltCloseWSSampler = document.createElement("eu.luminis.jmeter.wssampler.CloseWebSocketSampler");
        Attr attrGuiclass = document.createAttribute("guiclass");
        attrGuiclass.setValue("eu.luminis.jmeter.wssampler.CloseWebSocketSamplerGui");
        eltCloseWSSampler.setAttributeNode(attrGuiclass);
        Attr attrTestclass = document.createAttribute("testclass");
        attrTestclass.setValue("eu.luminis.jmeter.wssampler.CloseWebSocketSampler");
        eltCloseWSSampler.setAttributeNode(attrTestclass);
        String testname = String.format("%03d - WebSocket Close", httpSamplernum);
        Attr attrTestname = document.createAttribute("testname");
        attrTestname.setValue(testname);
        eltCloseWSSampler.setAttributeNode(attrTestname);
        Attr attrEnabled = document.createAttribute("enabled");
        attrEnabled.setValue("true");
        eltCloseWSSampler.setAttributeNode(attrEnabled);
        Element stringProp1 = XmlJmx.createProperty(document, "stringProp", "statusCode", "1000");
        eltCloseWSSampler.appendChild(stringProp1);
        Element stringProp2 = XmlJmx.createProperty(document, "stringProp", "readTimeout", "6000");
        eltCloseWSSampler.appendChild(stringProp2);
        return eltCloseWSSampler;
    }
}

