/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har.websocket;

import org.apache.commons.lang3.StringUtils;

public class UtilsWebSocket {
    public static final String K_PAY_LOAD_TYPE_TEXT = "Text";
    public static final String K_PAY_LOAD_TYPE_TEXT_STOMP = "TextStomp";

    public static String filterData(String data) {
        String sReturn = data;
        if (sReturn != null && !sReturn.isEmpty()) {
            sReturn = UtilsWebSocket.replaceDataEndNull(data);
            sReturn = UtilsWebSocket.removeContentLength(sReturn);
        }
        return sReturn;
    }

    public static String replaceDataEndNull(String data) {
        String sReturn = data.replace("\u0000", "^@");
        return sReturn;
    }

    public static String removeContentLength(String data) {
        String sAfter = StringUtils.replacePattern(data, "(?i)\ncontent-length: ?\\d+\n\n", "\n\n");
        return sAfter;
    }

    public static String getPayLoadType(String data) {
        String sPayloadType = K_PAY_LOAD_TYPE_TEXT;
        if (data != null && data.endsWith("\u0000")) {
            sPayloadType = K_PAY_LOAD_TYPE_TEXT_STOMP;
        }
        return sPayloadType;
    }
}

