/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har.websocket;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.github.vdaburon.jmeter.har.Utils;
import io.github.vdaburon.jmeter.har.websocket.WebSocketMessage;
import io.github.vdaburon.jmeter.har.websocket.WebSocketRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;

public class ManageWebSocket {
    private static final Logger LOGGER = Logger.getLogger(ManageWebSocket.class.getName());

    public static boolean isHarContainsWebSocketMessage(String harIn) {
        boolean isContainsWebSocketMessage = false;
        WebSocketRequest webSocketRequest = ManageWebSocket.getWebSocketRequest(harIn);
        if (webSocketRequest != null && webSocketRequest.getListWebSocketMessages() != null && webSocketRequest.getListWebSocketMessages().size() > 0) {
            isContainsWebSocketMessage = true;
        }
        return isContainsWebSocketMessage;
    }

    public static boolean isHarContainsWebSocketMessage(WebSocketRequest webSocketRequest) {
        boolean isContainsWebSocketMessage = false;
        if (webSocketRequest != null && webSocketRequest.getListWebSocketMessages() != null && webSocketRequest.getListWebSocketMessages().size() > 0) {
            isContainsWebSocketMessage = true;
        }
        return isContainsWebSocketMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebSocketRequest getWebSocketRequest(String harIn) {
        WebSocketRequest webSocketRequest = null;
        File fileHarIn = new File(harIn);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileHarIn);
        }
        catch (FileNotFoundException e) {
            LOGGER.warning("WARNING :" + e);
            return webSocketRequest;
        }
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(fis, "UTF-8");
        try {
            ArrayList jsonArrayWsRequest = (ArrayList)JsonPath.read(document, "$.log.entries[*].request[?(@.url =~ /^wss?:\\/\\/.*?/i)]", new Predicate[0]);
            LOGGER.info("Number of websocket (ws or wss) connection(s) : " + jsonArrayWsRequest.size());
            if (jsonArrayWsRequest.size() >= 1) {
                webSocketRequest = new WebSocketRequest();
                LinkedHashMap lhmWs = (LinkedHashMap)jsonArrayWsRequest.get(0);
                webSocketRequest.setMethod((String)lhmWs.get("method"));
                webSocketRequest.setUrl((String)lhmWs.get("url"));
                ArrayList jsonArray = (ArrayList)JsonPath.read(document, "$.log.entries[*]._webSocketMessages[*]", new Predicate[0]);
                LOGGER.info("Number of websocket messages : " + jsonArray.size());
                ArrayList<WebSocketMessage> listWebSocketMessages = new ArrayList<WebSocketMessage>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    LinkedHashMap lhm = (LinkedHashMap)jsonArray.get(i);
                    LOGGER.fine("lhm=" + lhm);
                    WebSocketMessage webSocketMessage = new WebSocketMessage();
                    webSocketMessage.setData((String)lhm.get("data"));
                    String sType = (String)lhm.get("type");
                    webSocketMessage.setType(sType);
                    double dTimeMicro = (Double)lhm.get("time");
                    String dateIso = Utils.doubleEpocMicroToIsoFormat(dTimeMicro);
                    webSocketMessage.setStartedDateTime(dateIso);
                    listWebSocketMessages.add(webSocketMessage);
                }
                webSocketRequest.setListWebSocketMessages(listWebSocketMessages);
            }
        }
        catch (PathNotFoundException e) {
            webSocketRequest = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (webSocketRequest != null) {
            webSocketRequest = ManageWebSocket.computeTypeExchange(webSocketRequest);
        }
        return webSocketRequest;
    }

    public static WebSocketRequest computeTypeExchange(WebSocketRequest webSocketRequest) {
        List<WebSocketMessage> listWebSocketMessages = webSocketRequest.getListWebSocketMessages();
        if (webSocketRequest != null && listWebSocketMessages != null) {
            int nbMessages = webSocketRequest.getListWebSocketMessages().size();
            ArrayList<Integer> listTypeExchange = new ArrayList<Integer>();
            for (int i = 0; i < nbMessages; ++i) {
                WebSocketMessage wsmPrevious;
                WebSocketMessage wsm = listWebSocketMessages.get(i);
                if ("send".equals(wsm.getType())) {
                    listTypeExchange.add(new Integer(2));
                }
                if ("receive".equals(wsm.getType())) {
                    listTypeExchange.add(new Integer(3));
                }
                if (i <= 0 || !"receive".equals(wsm.getType()) || !"send".equals((wsmPrevious = listWebSocketMessages.get(i - 1)).getType())) continue;
                listTypeExchange.set(i - 1, 1);
                listTypeExchange.set(i, 1);
            }
            webSocketRequest.setListTypeExchange(listTypeExchange);
        }
        return webSocketRequest;
    }
}

