/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har.lrwr;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.github.vdaburon.jmeter.har.common.TransactionInfo;
import io.github.vdaburon.jmeter.har.lrwr.HarLrTransactions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;

public class ManageLrwr {
    private static final Logger LOGGER = Logger.getLogger(ManageLrwr.class.getName());

    public static boolean isHarContainsLrwr(String harIn) {
        boolean isContainsLrTransactions = false;
        List<HarLrTransactions> listHarLrTransactions = ManageLrwr.getListTransactionLrwr(harIn);
        if (listHarLrTransactions != null && listHarLrTransactions.size() > 0) {
            isContainsLrTransactions = true;
        }
        return isContainsLrTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HarLrTransactions> getListTransactionLrwr(String harIn) {
        ArrayList<HarLrTransactions> listHarLrTransactions = null;
        File fileHarIn = new File(harIn);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileHarIn);
        }
        catch (FileNotFoundException e) {
            return listHarLrTransactions;
        }
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(fis, "UTF-8");
        try {
            ArrayList jsonArray = (ArrayList)JsonPath.read(document, "$.log._transactions[*]", new Predicate[0]);
            LOGGER.fine("jsonArray.size=" + jsonArray.size());
            listHarLrTransactions = new ArrayList<HarLrTransactions>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                LinkedHashMap lhm = (LinkedHashMap)jsonArray.get(i);
                LOGGER.fine("lhm=" + lhm);
                HarLrTransactions harLrTransactions = new HarLrTransactions();
                harLrTransactions.setName((String)lhm.get("name"));
                String sType = (String)lhm.get("type");
                harLrTransactions.setType(sType);
                harLrTransactions.setStartedDateTime((String)lhm.get("startedDateTime"));
                listHarLrTransactions.add(harLrTransactions);
            }
        }
        catch (PathNotFoundException e) {
            listHarLrTransactions = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return listHarLrTransactions;
    }

    public static List<TransactionInfo> createListTransactionInfo(List<HarLrTransactions> listHarLrTransactions) {
        if (listHarLrTransactions == null) {
            throw new InvalidParameterException("listHarLrTransactions must be not null");
        }
        ArrayList<TransactionInfo> listTransactionInfo = new ArrayList<TransactionInfo>();
        block0: for (int i = 0; i < listHarLrTransactions.size(); ++i) {
            HarLrTransactions harLrTransactions = listHarLrTransactions.get(i);
            if ("start".equals(harLrTransactions.getType())) {
                TransactionInfo transactionInfo = new TransactionInfo();
                transactionInfo.setName(harLrTransactions.getName());
                transactionInfo.setBeginDateTime(harLrTransactions.getStartedDateTime());
                listTransactionInfo.add(transactionInfo);
            }
            if (!"stop".equals(harLrTransactions.getType())) continue;
            for (int j = listTransactionInfo.size() - 1; j >= 0; --j) {
                TransactionInfo transactionInfo = listTransactionInfo.get(j);
                if (!transactionInfo.getName().equals(harLrTransactions.getName())) continue;
                transactionInfo.setEndDateTime(harLrTransactions.getStartedDateTime());
                listTransactionInfo.set(j, transactionInfo);
                continue block0;
            }
        }
        return listTransactionInfo;
    }

    public static TransactionInfo getTransactionInfoAroundDateTime(String startedDateTime, List<TransactionInfo> listTransactionInfo) {
        boolean isFind = false;
        int nbElts = listTransactionInfo.size();
        TransactionInfo transactionInfoFind = null;
        for (int i = 0; i < nbElts; ++i) {
            TransactionInfo transactionInfo = listTransactionInfo.get(i);
            if (transactionInfo.getBeginDateTime().compareTo(startedDateTime) > 0 || transactionInfo.getEndDateTime().compareTo(startedDateTime) < 0) continue;
            isFind = true;
            transactionInfoFind = transactionInfo;
        }
        if (isFind) {
            LOGGER.fine("transactionInfoFind=" + transactionInfoFind + " for startedDateTime=" + startedDateTime);
        } else {
            LOGGER.fine("NOT FIND for startedDateTime=" + startedDateTime);
        }
        return transactionInfoFind;
    }
}

