/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har.external;

import io.github.vdaburon.jmeter.har.Utils;
import io.github.vdaburon.jmeter.har.common.TransactionInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class ManageExternalFile {
    public static final String K_ELEMENT_TRANSACTION = "TRANSACTION";
    public static final String K_ELEMENT_COMMENT = "COMMENT";
    public static final String K_TYPE_START = "start";
    public static final String K_TYPE_STOP = "stop";
    public static final String K_FILE_IN_SEP = ";";
    public static final String K_FILE_IN_DEFAULT_CHARSET = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(ManageExternalFile.class.getName());

    public static List<TransactionInfo> createListTransactionInfo(String fileName) {
        LOGGER.info("Read external file: " + fileName);
        if (fileName == null) {
            throw new InvalidParameterException("fileName must be not null");
        }
        ArrayList<TransactionInfo> listTransactionInfo = new ArrayList<TransactionInfo>();
        BufferedReader in = null;
        try {
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName(K_FILE_IN_DEFAULT_CHARSET));
            in = new BufferedReader(isr);
            String line = null;
            block9: while ((line = in.readLine()) != null) {
                String type;
                List<String> items = Arrays.asList(line.split(K_FILE_IN_SEP));
                if (items.size() != 4) continue;
                String dateTimestamp = items.get(0);
                String element = items.get(1);
                String name = items.get(2);
                if (!name.isEmpty()) {
                    name = name.trim();
                }
                if (!(type = items.get(3)).isEmpty()) {
                    type = type.trim();
                }
                if (!K_ELEMENT_TRANSACTION.equals(element)) continue;
                if (K_TYPE_START.equals(type)) {
                    TransactionInfo transactionInfo = new TransactionInfo();
                    transactionInfo.setName(name);
                    transactionInfo.setBeginDateTime(dateTimestamp);
                    listTransactionInfo.add(transactionInfo);
                    continue;
                }
                if (!K_TYPE_STOP.equals(type)) continue;
                for (int j = listTransactionInfo.size() - 1; j >= 0; --j) {
                    TransactionInfo transactionInfoInter = listTransactionInfo.get(j);
                    if (!transactionInfoInter.getName().equals(name)) continue;
                    transactionInfoInter.setEndDateTime(dateTimestamp);
                    listTransactionInfo.set(j, transactionInfoInter);
                    continue block9;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (int i = 0; i < listTransactionInfo.size(); ++i) {
            TransactionInfo transactionInfoInter = (TransactionInfo)listTransactionInfo.get(i);
            if (transactionInfoInter.getBeginDateTime() == null) {
                transactionInfoInter.setBeginDateTime(Utils.dateToIsoFormat(new Date()));
                listTransactionInfo.set(i, transactionInfoInter);
            }
            if (transactionInfoInter.getEndDateTime() != null) continue;
            transactionInfoInter.setEndDateTime(transactionInfoInter.getBeginDateTime());
            listTransactionInfo.set(i, transactionInfoInter);
        }
        LOGGER.info("External infos : " + listTransactionInfo);
        return listTransactionInfo;
    }
}

