/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har;

import de.sstoehr.harreader.model.Har;
import de.sstoehr.harreader.model.HarEntry;
import de.sstoehr.harreader.model.HarHeader;
import de.sstoehr.harreader.model.HarPage;
import de.sstoehr.harreader.model.HarPostData;
import de.sstoehr.harreader.model.HarPostDataParam;
import de.sstoehr.harreader.model.HarQueryParam;
import de.sstoehr.harreader.model.HarRequest;
import de.sstoehr.harreader.model.HttpMethod;
import io.github.vdaburon.jmeter.har.HarForJMeter;
import io.github.vdaburon.jmeter.har.Utils;
import io.github.vdaburon.jmeter.har.common.TransactionInfo;
import io.github.vdaburon.jmeter.har.lrwr.ManageLrwr;
import io.github.vdaburon.jmeter.har.websocket.WebSocketPDoornboschXmlJmx;
import io.github.vdaburon.jmeter.har.websocket.WebSocketRequest;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlJmx {
    protected static final String K_SCHEME = "scheme";
    protected static final String K_HOST = "host";
    protected static final String K_PORT = "port";
    private static final String K_JMETER_VERSION = "5.6.3";
    private static final String K_THREAD_GROUP_NAME = "Thead Group HAR Imported";
    private static final String K_VIEW_RESULT_TREE_COMMENT = "For The Recording XML File Created";
    private static final Logger LOGGER = Logger.getLogger(XmlJmx.class.getName());

    protected Document convertHarToJmxXml(Har har, long createNewTransactionAfterRequestMs, boolean isAddPause, boolean isRemoveCookie, boolean isRemoveCacheRequest, String urlFilterToInclude, String urlFilterToExclude, int pageStartNumber, int samplerStartNumber, List<TransactionInfo> listTransactionInfo, boolean isAddViewTreeForRecord, WebSocketRequest webSocketRequest, String recordXmlOut) throws ParserConfigurationException, URISyntaxException {
        Pattern patternUrlInclude = null;
        if (!urlFilterToInclude.isEmpty()) {
            patternUrlInclude = Pattern.compile(urlFilterToInclude);
        }
        Pattern patternUrlExclude = null;
        if (!urlFilterToExclude.isEmpty()) {
            patternUrlExclude = Pattern.compile(urlFilterToExclude);
        }
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element eltHashTreeAfterTestPlan = this.createJmxTestPlanAndTheadGroup(document);
        Element hashAfterThreadGroup = XmlJmx.createHashTree(document);
        eltHashTreeAfterTestPlan.appendChild(hashAfterThreadGroup);
        if (isAddViewTreeForRecord && !recordXmlOut.isEmpty()) {
            Element eltHttpTestScriptRecorder = this.createHttpTestScriptRecorder(document);
            eltHashTreeAfterTestPlan.appendChild(eltHttpTestScriptRecorder);
            Element hashTreeAfterTestScriptRecorder = XmlJmx.createHashTree(document);
            Element eltViewResultTree = this.createViewResultTree(document, recordXmlOut);
            hashTreeAfterTestScriptRecorder.appendChild(eltViewResultTree);
            Element hashTreeAfterViewResultTree = XmlJmx.createHashTree(document);
            hashTreeAfterTestScriptRecorder.appendChild(hashTreeAfterViewResultTree);
            eltHashTreeAfterTestPlan.appendChild(hashTreeAfterTestScriptRecorder);
        }
        HashMap hSchemeHostPort = this.getSchemeHostPortFirstPageOrUrl(har);
        String scheme = (String)hSchemeHostPort.get(K_SCHEME);
        String host = (String)hSchemeHostPort.get(K_HOST);
        String sPort = (String)hSchemeHostPort.get(K_PORT);
        int iPort = Integer.parseInt(sPort);
        Element eltUdv = this.createUserDefinedVariable(document, hSchemeHostPort);
        hashAfterThreadGroup.appendChild(eltUdv);
        Element hashTreeEmpty1 = XmlJmx.createHashTree(document);
        hashAfterThreadGroup.appendChild(hashTreeEmpty1);
        Element configTestElement = this.createConfigTestElement(document);
        hashAfterThreadGroup.appendChild(configTestElement);
        Element hashTreeEmpty2 = XmlJmx.createHashTree(document);
        hashAfterThreadGroup.appendChild(hashTreeEmpty2);
        Element eltCookieManger = this.createCookieManager(document);
        hashAfterThreadGroup.appendChild(eltCookieManger);
        Element hashTreeEmpty3 = XmlJmx.createHashTree(document);
        hashAfterThreadGroup.appendChild(hashTreeEmpty3);
        Element eltCacheManager = this.createCacheManager(document);
        hashAfterThreadGroup.appendChild(eltCacheManager);
        Element hashTreeEmpty4 = XmlJmx.createHashTree(document);
        hashAfterThreadGroup.appendChild(hashTreeEmpty4);
        List<HarPage> lPages = har.getLog().getPages();
        if (lPages != null) {
            LOGGER.info("Number of page(s) in the HAR : " + lPages.size());
        }
        boolean isNoPage = false;
        if (lPages == null || lPages != null && lPages.size() == 0) {
            lPages = new ArrayList<HarPage>();
            HarPage harPage = new HarPage();
            harPage.setId("PAGE_00");
            List<HarEntry> lEntries = har.getLog().getEntries();
            if (lEntries == null || lEntries.size() <= 0) {
                throw new InvalidParameterException("No Page and No Entry, can't convert this har file");
            }
            HarEntry harEntryInter = lEntries.get(0);
            harPage.setTitle(harEntryInter.getRequest().getUrl());
            harPage.setStartedDateTime(harEntryInter.getStartedDateTime());
            lPages.add(harPage);
            isNoPage = true;
        }
        long timePageBefore = 0L;
        long timeRequestBefore = 0L;
        boolean isCreateNewTransactionAfterRequestMs = false;
        if (createNewTransactionAfterRequestMs > 0L && lPages.size() == 1) {
            isCreateNewTransactionAfterRequestMs = true;
        }
        int pageNum = pageStartNumber;
        int httpSamplernum = samplerStartNumber;
        for (int p = 0; p < lPages.size(); ++p) {
            Date datePageStartedDateTime;
            String pageStartedDateTime;
            HarPage pageInter = lPages.get(p);
            String pageId = pageInter.getId();
            String pageTitle = "";
            try {
                URI pageUrl = new URI(pageInter.getTitle());
                pageTitle = pageUrl.getPath();
            }
            catch (URISyntaxException ex) {
                pageTitle = pageInter.getTitle();
            }
            TransactionInfo transactionInfo = null;
            if (listTransactionInfo != null && (transactionInfo = ManageLrwr.getTransactionInfoAroundDateTime(pageStartedDateTime = Utils.dateToIsoFormat(datePageStartedDateTime = pageInter.getStartedDateTime()), listTransactionInfo)) != null) {
                pageTitle = transactionInfo.getName();
                LOGGER.info("Set the page title with the transaction name: " + pageTitle);
            }
            String tcName = String.format("PAGE_%02d - " + pageTitle, pageNum);
            ++pageNum;
            if (p == 0) {
                timePageBefore = pageInter.getStartedDateTime().getTime();
            } else {
                long timeBetween2Pages = pageInter.getStartedDateTime().getTime() - timePageBefore;
                if (isAddPause && timeBetween2Pages > 0L) {
                    Element eltTestAction = this.createTestActionPause(document, "Flow Control Action PAUSE", timeBetween2Pages);
                    hashAfterThreadGroup.appendChild(eltTestAction);
                    Element hashAfterTestAction = XmlJmx.createHashTree(document);
                    hashAfterThreadGroup.appendChild(hashAfterTestAction);
                }
                timePageBefore = pageInter.getStartedDateTime().getTime();
            }
            Element eltTransactionController = this.createTransactionController(document, tcName);
            hashAfterThreadGroup.appendChild(eltTransactionController);
            Element hashTreeAfterTc = XmlJmx.createHashTree(document);
            hashAfterThreadGroup.appendChild(hashTreeAfterTc);
            List<HarEntry> lEntries = har.getLog().getEntries();
            String currentUrl = "";
            for (int e = 0; e < lEntries.size(); ++e) {
                String fromCache;
                Matcher matcher;
                HarEntry harEntryInter = lEntries.get(e);
                if (e == 0) {
                    timeRequestBefore = harEntryInter.getStartedDateTime().getTime();
                }
                long timeRequestStarted = harEntryInter.getStartedDateTime().getTime();
                long timeBetween2Requests = timeRequestStarted - timeRequestBefore;
                String pageref = harEntryInter.getPageref();
                if ((pageref == null || !pageref.equals(pageId)) && !isNoPage) continue;
                HarRequest harRequest = harEntryInter.getRequest();
                currentUrl = harRequest.getUrl();
                boolean isAddThisRequest = true;
                if (patternUrlInclude != null) {
                    matcher = patternUrlInclude.matcher(currentUrl);
                    isAddThisRequest = matcher.find();
                }
                if (isAddThisRequest && patternUrlExclude != null) {
                    matcher = patternUrlExclude.matcher(currentUrl);
                    isAddThisRequest = !matcher.find();
                }
                HashMap hAddictional = (HashMap)harEntryInter.getAdditional();
                if (isAddThisRequest && hAddictional != null && (fromCache = (String)hAddictional.get("_fromCache")) != null) {
                    isAddThisRequest = false;
                }
                if (isAddThisRequest) {
                    Date dateEntryStartedDateTime;
                    String entryStartedDateTime;
                    TransactionInfo transactionInfo2;
                    URI url = new URI(harRequest.getUrl());
                    String samplerLabel = String.format("%03d " + url.getPath(), httpSamplernum);
                    ++httpSamplernum;
                    String sUrl = harRequest.getUrl();
                    String startUrl = sUrl.substring(0, Math.min(2, sUrl.length()));
                    if ("da".equalsIgnoreCase(startUrl)) continue;
                    Element sampler = null;
                    boolean isWebSocket = false;
                    if ("ws".equalsIgnoreCase(startUrl) && webSocketRequest != null) {
                        URI pageUrlFromRequest = new URI(harRequest.getUrl());
                        String tcNameFromRequest = String.format("PAGE_%02d - WebSocket " + pageUrlFromRequest.getPath(), pageNum);
                        ++pageNum;
                        Element eltTransactionControllerNew = this.createTransactionController(document, tcNameFromRequest);
                        hashTreeAfterTc = XmlJmx.createHashTree(document);
                        httpSamplernum = WebSocketPDoornboschXmlJmx.createWebSocketPDoornboschTree(document, hashTreeAfterTc, samplerLabel, scheme, host, iPort, httpSamplernum, webSocketRequest);
                        ++httpSamplernum;
                        hashAfterThreadGroup.appendChild(eltTransactionControllerNew);
                        hashAfterThreadGroup.appendChild(hashTreeAfterTc);
                        continue;
                    }
                    sampler = this.createHttpSamplerProxy(document, samplerLabel, scheme, host, iPort, harRequest);
                    boolean isCreateNewTcFromTransactionInfo = false;
                    if (listTransactionInfo != null && (transactionInfo2 = ManageLrwr.getTransactionInfoAroundDateTime(entryStartedDateTime = Utils.dateToIsoFormat(dateEntryStartedDateTime = harEntryInter.getStartedDateTime()), listTransactionInfo)) != null) {
                        isCreateNewTcFromTransactionInfo = true;
                        if (transactionInfo != null) {
                            isCreateNewTcFromTransactionInfo = !transactionInfo2.getBeginDateTime().equals(transactionInfo.getBeginDateTime());
                        }
                        if (isCreateNewTcFromTransactionInfo) {
                            pageTitle = transactionInfo2.getName();
                            LOGGER.info("Set the page title with the transaction name: " + pageTitle);
                            String tcNameFromRequest = String.format("PAGE_%02d - " + pageTitle, pageNum);
                            transactionInfo = transactionInfo2;
                            ++pageNum;
                            Element eltTransactionControllerNew = this.createTransactionController(document, tcNameFromRequest);
                            hashAfterThreadGroup.appendChild(eltTransactionControllerNew);
                            hashTreeAfterTc = XmlJmx.createHashTree(document);
                            hashAfterThreadGroup.appendChild(hashTreeAfterTc);
                        }
                    }
                    if (isCreateNewTransactionAfterRequestMs && timeBetween2Requests > createNewTransactionAfterRequestMs) {
                        if (isAddPause) {
                            Element eltTestAction = this.createTestActionPause(document, "Flow Control Action PAUSE", timeBetween2Requests);
                            hashAfterThreadGroup.appendChild(eltTestAction);
                            Element hashAfterTestAction = XmlJmx.createHashTree(document);
                            hashAfterThreadGroup.appendChild(hashAfterTestAction);
                        }
                        if (!isCreateNewTcFromTransactionInfo) {
                            URI pageUrlFromRequest = new URI(harRequest.getUrl());
                            String tcNameFromRequest = String.format("PAGE_%02d - " + pageUrlFromRequest.getPath(), pageNum);
                            ++pageNum;
                            Element eltTransactionControllerNew = this.createTransactionController(document, tcNameFromRequest);
                            hashAfterThreadGroup.appendChild(eltTransactionControllerNew);
                            hashTreeAfterTc = XmlJmx.createHashTree(document);
                            hashAfterThreadGroup.appendChild(hashTreeAfterTc);
                        }
                    }
                    timeRequestBefore = timeRequestStarted;
                    hashTreeAfterTc.appendChild(sampler);
                    Element hashTreeAfterHttpSampler = XmlJmx.createHashTree(document);
                    hashTreeAfterTc.appendChild(hashTreeAfterHttpSampler);
                    Element headers = this.createHeaderManager(document, harRequest, isRemoveCookie, isRemoveCacheRequest);
                    hashTreeAfterHttpSampler.appendChild(headers);
                    Element hashTreeAfterHeaders = XmlJmx.createHashTree(document);
                    hashTreeAfterHttpSampler.appendChild(hashTreeAfterHeaders);
                    continue;
                }
                LOGGER.fine("This url is filtred : " + currentUrl);
            }
        }
        LOGGER.info("JMX file contains " + httpSamplernum + " HTTPSamplerProxy");
        return document;
    }

    protected Element createHttpTestScriptRecorder(Document document) {
        Element eltProxyControl = document.createElement("ProxyControl");
        Attr attrPcguiclass = document.createAttribute("guiclass");
        attrPcguiclass.setValue("ProxyControlGui");
        eltProxyControl.setAttributeNode(attrPcguiclass);
        Attr attrPctestclass = document.createAttribute("testclass");
        attrPctestclass.setValue("ProxyControl");
        eltProxyControl.setAttributeNode(attrPctestclass);
        Attr attrPctestname = document.createAttribute("testname");
        attrPctestname.setValue("HTTP(S) Test Script Recorder");
        eltProxyControl.setAttributeNode(attrPctestname);
        Attr attrPcenabled = document.createAttribute("enabled");
        attrPcenabled.setValue("false");
        eltProxyControl.setAttributeNode(attrPcenabled);
        Element stringProp1 = XmlJmx.createProperty(document, "stringProp", "ProxyControlGui.port", "8888");
        eltProxyControl.appendChild(stringProp1);
        Element collectionProp2 = XmlJmx.createProperty(document, "collectionProp", "ProxyControlGui.exclude_list", null);
        eltProxyControl.appendChild(collectionProp2);
        Element collectionProp3 = XmlJmx.createProperty(document, "collectionProp", "ProxyControlGui.include_list", null);
        eltProxyControl.appendChild(collectionProp3);
        Element boolProp4 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.capture_http_headers", "true");
        eltProxyControl.appendChild(boolProp4);
        Element intProp5 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.grouping_mode", "0");
        eltProxyControl.appendChild(intProp5);
        Element boolProp6 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.add_assertion", "false");
        eltProxyControl.appendChild(boolProp6);
        Element stringProp7 = XmlJmx.createProperty(document, "stringProp", "ProxyControlGui.sampler_type_name", null);
        eltProxyControl.appendChild(stringProp7);
        Element boolProp8 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.sampler_redirect_automatically", "false");
        eltProxyControl.appendChild(boolProp8);
        Element boolProp9 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.sampler_follow_redirects", "true");
        eltProxyControl.appendChild(boolProp9);
        Element boolProp10 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.use_keepalive", "true");
        eltProxyControl.appendChild(boolProp10);
        Element boolProp11 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.detect_graphql_request", "true");
        eltProxyControl.appendChild(boolProp11);
        Element boolProp12 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.sampler_download_images", "false");
        eltProxyControl.appendChild(boolProp12);
        Element stringProp13 = XmlJmx.createProperty(document, "intProp", "ProxyControlGui.proxy_http_sampler_naming_mode", "0");
        eltProxyControl.appendChild(stringProp13);
        Element stringProp14 = XmlJmx.createProperty(document, "stringProp", "ProxyControlGui.default_encoding", null);
        eltProxyControl.appendChild(stringProp14);
        Element stringProp15 = XmlJmx.createProperty(document, "stringProp", "ProxyControlGui.proxy_prefix_http_sampler_name", null);
        eltProxyControl.appendChild(stringProp15);
        Element stringProp16 = XmlJmx.createProperty(document, "stringProp", "ProxyControlGui.proxy_pause_http_sampler", null);
        eltProxyControl.appendChild(stringProp16);
        Element boolProp17 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.notify_child_sl_filtered", "false");
        eltProxyControl.appendChild(boolProp17);
        Element boolProp18 = XmlJmx.createProperty(document, "boolProp", "ProxyControlGui.regex_match", "false");
        eltProxyControl.appendChild(boolProp18);
        Element stringProp19 = XmlJmx.createProperty(document, "stringProp", "ProxyControlGui.content_type_include", null);
        eltProxyControl.appendChild(stringProp19);
        Element stringProp20 = XmlJmx.createProperty(document, "stringProp", "ProxyControlGui.content_type_exclude", null);
        eltProxyControl.appendChild(stringProp20);
        return eltProxyControl;
    }

    protected Element createViewResultTree(Document document, String recordXmlOut) {
        Element eltResultCollector = document.createElement("ResultCollector");
        Attr attrRcguiclass = document.createAttribute("guiclass");
        attrRcguiclass.setValue("ViewResultsFullVisualizer");
        eltResultCollector.setAttributeNode(attrRcguiclass);
        Attr attrRctestclass = document.createAttribute("testclass");
        attrRctestclass.setValue("ResultCollector");
        eltResultCollector.setAttributeNode(attrRctestclass);
        Attr attrRctestname = document.createAttribute("testname");
        attrRctestname.setValue("View Results Tree");
        eltResultCollector.setAttributeNode(attrRctestname);
        Element boolProp1 = XmlJmx.createProperty(document, "boolProp", "ResultCollector.error_logging", "false");
        eltResultCollector.appendChild(boolProp1);
        Element stringProp2 = XmlJmx.createProperty(document, "stringProp", "filename", recordXmlOut);
        eltResultCollector.appendChild(stringProp2);
        Element stringProp3 = XmlJmx.createProperty(document, "stringProp", "TestPlan.comments", K_VIEW_RESULT_TREE_COMMENT);
        eltResultCollector.appendChild(stringProp3);
        return eltResultCollector;
    }

    protected Element createJmxTestPlanAndTheadGroup(Document document) {
        Element root = document.createElement("jmeterTestPlan");
        document.appendChild(root);
        Attr attrversion = document.createAttribute("version");
        attrversion.setValue("1.2");
        root.setAttributeNode(attrversion);
        Attr attrproperties = document.createAttribute("properties");
        attrproperties.setValue("5.0");
        root.setAttributeNode(attrproperties);
        Attr attrjmeter = document.createAttribute("jmeter");
        attrjmeter.setValue(K_JMETER_VERSION);
        root.setAttributeNode(attrjmeter);
        Element eltRoothashTree = XmlJmx.createHashTree(document);
        root.appendChild(eltRoothashTree);
        Element eltTestPlan = document.createElement("TestPlan");
        Attr attrTpguiclass = document.createAttribute("guiclass");
        attrTpguiclass.setValue("TestPlanGui");
        eltTestPlan.setAttributeNode(attrTpguiclass);
        Attr attrTptestclass = document.createAttribute("testclass");
        attrTptestclass.setValue("TestPlanGui");
        eltTestPlan.setAttributeNode(attrTptestclass);
        Attr attrTptestname = document.createAttribute("testname");
        attrTptestname.setValue("Test Plan");
        eltTestPlan.setAttributeNode(attrTptestname);
        Attr attrTpenabled = document.createAttribute("enabled");
        attrTpenabled.setValue("true");
        eltTestPlan.setAttributeNode(attrTpenabled);
        Element eltBoolProp1 = XmlJmx.createProperty(document, "boolProp", "TestPlan.functional_mode", "false");
        eltTestPlan.appendChild(eltBoolProp1);
        Element eltBoolProp2 = XmlJmx.createProperty(document, "boolProp", "TestPlan.tearDown_on_shutdown", "false");
        eltTestPlan.appendChild(eltBoolProp2);
        Element eltBoolProp3 = XmlJmx.createProperty(document, "boolProp", "TestPlan.serialize_threadgroups", "false");
        eltTestPlan.appendChild(eltBoolProp3);
        Element eltTpElementProp = this.createElementProp(document, "TestPlan.user_defined_variables", "Arguments", "ArgumentsPanel", "Arguments", "User Defined Variables");
        eltTestPlan.appendChild(eltTpElementProp);
        Element eltTpCollectionProp = document.createElement("collectionProp");
        Attr attrTpCollectionPropname = document.createAttribute("name");
        attrTpCollectionPropname.setValue("Arguments.arguments");
        eltTpCollectionProp.setAttributeNode(attrTpCollectionPropname);
        eltTpElementProp.appendChild(eltTpCollectionProp);
        String versionComment = "This test plan was created by io.github.vdaburon:har-to-jmeter-convertor Version 7.1";
        Element eltTpStringProp1 = XmlJmx.createProperty(document, "stringProp", "TestPlan.comments", versionComment);
        eltTestPlan.appendChild(eltTpStringProp1);
        Element eltTpStringProp2 = XmlJmx.createProperty(document, "stringProp", "TestPlan.user_define_classpath", null);
        eltTestPlan.appendChild(eltTpStringProp2);
        eltRoothashTree.appendChild(eltTestPlan);
        Element eltHashTreeAfterTestPlan = XmlJmx.createHashTree(document);
        eltRoothashTree.appendChild(eltHashTreeAfterTestPlan);
        Element eltThreadGroup = this.createThreadGroup(document, K_THREAD_GROUP_NAME);
        eltHashTreeAfterTestPlan.appendChild(eltThreadGroup);
        return eltHashTreeAfterTestPlan;
    }

    protected Element createThreadGroup(Document document, String groupName) {
        Element eltThreadGroup = document.createElement("ThreadGroup");
        Attr attrThreadGroupguiclass = document.createAttribute("guiclass");
        attrThreadGroupguiclass.setValue("ThreadGroupGui");
        eltThreadGroup.setAttributeNode(attrThreadGroupguiclass);
        Attr attrThreadGrouptestclass = document.createAttribute("testclass");
        attrThreadGrouptestclass.setValue("ThreadGroup");
        eltThreadGroup.setAttributeNode(attrThreadGrouptestclass);
        Attr attrThreadGrouptestname = document.createAttribute("testname");
        attrThreadGrouptestname.setValue(groupName);
        eltThreadGroup.setAttributeNode(attrThreadGrouptestname);
        Attr attrThreadGroupenabled = document.createAttribute("enabled");
        attrThreadGroupenabled.setValue("true");
        eltThreadGroup.setAttributeNode(attrThreadGroupenabled);
        Element eltTgStringProp1 = XmlJmx.createProperty(document, "stringProp", "ThreadGroup.num_threads", "1");
        eltThreadGroup.appendChild(eltTgStringProp1);
        Element eltTgStringProp2 = XmlJmx.createProperty(document, "stringProp", "ThreadGroup.ramp_time", "1");
        eltThreadGroup.appendChild(eltTgStringProp2);
        Element eltTgElementProp = this.createElementProp(document, "ThreadGroup.main_controller", "LoopController", "LoopControlPanel", "LoopController", "");
        Element eltEltPropStringProp1 = XmlJmx.createProperty(document, "stringProp", "LoopController.loops", "1");
        eltTgElementProp.appendChild(eltEltPropStringProp1);
        Element eltEltPropBoolProp2 = XmlJmx.createProperty(document, "boolProp", "LoopController.continue_forever", "false");
        eltTgElementProp.appendChild(eltEltPropBoolProp2);
        eltThreadGroup.appendChild(eltTgElementProp);
        Element eltTgStringProp3 = XmlJmx.createProperty(document, "stringProp", "ThreadGroup.on_sample_error", "continue");
        eltThreadGroup.appendChild(eltTgStringProp3);
        Element eltTgBoolProp4 = XmlJmx.createProperty(document, "boolProp", "ThreadGroup.delayedStart", "false");
        eltThreadGroup.appendChild(eltTgBoolProp4);
        Element eltTgBoolProp5 = XmlJmx.createProperty(document, "boolProp", "ThreadGroup.scheduler", "false");
        eltThreadGroup.appendChild(eltTgBoolProp5);
        Element eltTgStringProp6 = XmlJmx.createProperty(document, "stringProp", "ThreadGroup.duration", "");
        eltThreadGroup.appendChild(eltTgStringProp6);
        Element eltTgStringProp7 = XmlJmx.createProperty(document, "stringProp", "ThreadGroup.delay", "");
        eltThreadGroup.appendChild(eltTgStringProp7);
        Element eltTgBoolProp8 = XmlJmx.createProperty(document, "boolProp", "ThreadGroup.same_user_on_next_iteration", "true");
        eltThreadGroup.appendChild(eltTgBoolProp8);
        return eltThreadGroup;
    }

    protected Element createCookieManager(Document document) {
        Element eltCookieManager = document.createElement("CookieManager");
        Attr attrCookieManagerguiclass = document.createAttribute("guiclass");
        attrCookieManagerguiclass.setValue("CookiePanel");
        eltCookieManager.setAttributeNode(attrCookieManagerguiclass);
        Attr attrCookieManagertestclass = document.createAttribute("testclass");
        attrCookieManagertestclass.setValue("CookieManager");
        eltCookieManager.setAttributeNode(attrCookieManagertestclass);
        Attr attrCookieManagertestname = document.createAttribute("testname");
        attrCookieManagertestname.setValue("HTTP Cookie Manager");
        eltCookieManager.setAttributeNode(attrCookieManagertestname);
        Attr attrCookieManagerenabled = document.createAttribute("enabled");
        attrCookieManagerenabled.setValue("true");
        eltCookieManager.setAttributeNode(attrCookieManagerenabled);
        Element eltCollectionProp1 = XmlJmx.createProperty(document, "collectionProp", "CookieManager.cookies", null);
        eltCookieManager.appendChild(eltCollectionProp1);
        Element eltBoolProp1 = XmlJmx.createProperty(document, "boolProp", "CookieManager.clearEachIteration", "true");
        eltCookieManager.appendChild(eltBoolProp1);
        Element eltBoolProp2 = XmlJmx.createProperty(document, "boolProp", "CookieManager.controlledByThreadGroup", "false");
        eltCookieManager.appendChild(eltBoolProp2);
        return eltCookieManager;
    }

    protected Element createCacheManager(Document document) {
        Element eltCacheManager = document.createElement("CacheManager");
        Attr attrCacheManagerguiclass = document.createAttribute("guiclass");
        attrCacheManagerguiclass.setValue("CacheManagerGui");
        eltCacheManager.setAttributeNode(attrCacheManagerguiclass);
        Attr attrCacheManagertestclass = document.createAttribute("testclass");
        attrCacheManagertestclass.setValue("CacheManager");
        eltCacheManager.setAttributeNode(attrCacheManagertestclass);
        Attr attrCacheManagertestname = document.createAttribute("testname");
        attrCacheManagertestname.setValue("HTTP Cache Manager");
        eltCacheManager.setAttributeNode(attrCacheManagertestname);
        Attr attrCacheManagerenabled = document.createAttribute("enabled");
        attrCacheManagerenabled.setValue("true");
        eltCacheManager.setAttributeNode(attrCacheManagerenabled);
        Element eltBoolProp1 = XmlJmx.createProperty(document, "boolProp", "clearEachIteration", "true");
        eltCacheManager.appendChild(eltBoolProp1);
        Element eltBoolProp2 = XmlJmx.createProperty(document, "boolProp", "useExpires", "true");
        eltCacheManager.appendChild(eltBoolProp2);
        Element eltBoolProp3 = XmlJmx.createProperty(document, "boolProp", "CacheManager.controlledByThread", "false");
        eltCacheManager.appendChild(eltBoolProp3);
        return eltCacheManager;
    }

    protected Element createTransactionController(Document document, String testname) {
        Element eltTransactionController = document.createElement("TransactionController");
        Attr attrTransactionControllerguiclass = document.createAttribute("guiclass");
        attrTransactionControllerguiclass.setValue("TransactionControllerGui");
        eltTransactionController.setAttributeNode(attrTransactionControllerguiclass);
        Attr attrTransactionControllertestclass = document.createAttribute("testclass");
        attrTransactionControllertestclass.setValue("TransactionController");
        eltTransactionController.setAttributeNode(attrTransactionControllertestclass);
        Attr attrTransactionControllertestname = document.createAttribute("testname");
        attrTransactionControllertestname.setValue(testname);
        eltTransactionController.setAttributeNode(attrTransactionControllertestname);
        Attr attrTransactionControllerenabled = document.createAttribute("enabled");
        attrTransactionControllerenabled.setValue("true");
        eltTransactionController.setAttributeNode(attrTransactionControllerenabled);
        Element eltBoolProp1 = XmlJmx.createProperty(document, "boolProp", "TransactionController.parent", "false");
        eltTransactionController.appendChild(eltBoolProp1);
        Element eltBoolProp2 = XmlJmx.createProperty(document, "boolProp", "TransactionController.includeTimers", "false");
        eltTransactionController.appendChild(eltBoolProp2);
        return eltTransactionController;
    }

    public static Element createHashTree(Document document) {
        Element eltHashTree = document.createElement("hashTree");
        return eltHashTree;
    }

    public static Element createProperty(Document document, String elementProp, String parameterNameValue, String elementValue) {
        Element eltProperty = document.createElement(elementProp);
        if (parameterNameValue != null) {
            Attr attrPropertyname = document.createAttribute("name");
            attrPropertyname.setValue(parameterNameValue);
            eltProperty.setAttributeNode(attrPropertyname);
        }
        if (elementValue != null) {
            eltProperty.setTextContent(elementValue);
        }
        return eltProperty;
    }

    protected Element createElementProp(Document document, String nameValue, String elementTypeValue, String guiClassValue, String testClassValue, String testNameValue) {
        Element eltElementProp = document.createElement("elementProp");
        Attr attrTpElementPropname = document.createAttribute("name");
        attrTpElementPropname.setValue(nameValue);
        eltElementProp.setAttributeNode(attrTpElementPropname);
        Attr attrTpElementPropelementType = document.createAttribute("elementType");
        attrTpElementPropelementType.setValue(elementTypeValue);
        eltElementProp.setAttributeNode(attrTpElementPropelementType);
        if (guiClassValue != null) {
            Attr attrTpElementPropguiclass = document.createAttribute("guiclass");
            attrTpElementPropguiclass.setValue(guiClassValue);
            eltElementProp.setAttributeNode(attrTpElementPropguiclass);
        }
        if (testClassValue != null) {
            Attr attrTpElementProptestclass = document.createAttribute("testclass");
            attrTpElementProptestclass.setValue(testClassValue);
            eltElementProp.setAttributeNode(attrTpElementProptestclass);
        }
        if (testNameValue != null) {
            Attr attrTpElementProptestname = document.createAttribute("testname");
            attrTpElementProptestname.setValue(testNameValue);
            eltElementProp.setAttributeNode(attrTpElementProptestname);
        }
        if (guiClassValue != null && testClassValue != null) {
            Attr attrTpElementPropenabled = document.createAttribute("enabled");
            attrTpElementPropenabled.setValue("true");
            eltElementProp.setAttributeNode(attrTpElementPropenabled);
        }
        return eltElementProp;
    }

    protected Element createUserDefinedVariable(Document document, HashMap<String, String> hSchemeHostPort) {
        Element eltArguments = document.createElement("Arguments");
        Attr attrArgumentsguiclass = document.createAttribute("guiclass");
        attrArgumentsguiclass.setValue("ArgumentsPanel");
        eltArguments.setAttributeNode(attrArgumentsguiclass);
        Attr attrArgumentstestclass = document.createAttribute("testclass");
        attrArgumentstestclass.setValue("Arguments");
        eltArguments.setAttributeNode(attrArgumentstestclass);
        Attr attrArgumentstestname = document.createAttribute("testname");
        attrArgumentstestname.setValue("User Defined Variables");
        eltArguments.setAttributeNode(attrArgumentstestname);
        Attr attrArgumentsenabled = document.createAttribute("enabled");
        attrArgumentsenabled.setValue("true");
        eltArguments.setAttributeNode(attrArgumentsenabled);
        Element eltCollectionProp = XmlJmx.createProperty(document, "collectionProp", "Arguments.arguments", null);
        eltArguments.appendChild(eltCollectionProp);
        Element eltCollProElementProp1 = this.createElementProp(document, "V_SCHEME", "Argument", null, null, null);
        eltCollectionProp.appendChild(eltCollProElementProp1);
        Element eltCollProElementProp1StringProp1 = XmlJmx.createProperty(document, "stringProp", "Argument.name", "V_SCHEME");
        eltCollProElementProp1.appendChild(eltCollProElementProp1StringProp1);
        String scheme = hSchemeHostPort.get(K_SCHEME);
        Element eltCollProElementProp1StringProp2 = XmlJmx.createProperty(document, "stringProp", "Argument.value", scheme);
        eltCollProElementProp1.appendChild(eltCollProElementProp1StringProp2);
        Element eltCollProElementProp1StringProp3 = XmlJmx.createProperty(document, "stringProp", "Argument.metadata", "=");
        eltCollProElementProp1.appendChild(eltCollProElementProp1StringProp3);
        Element eltCollProElementProp2 = this.createElementProp(document, "V_HOST", "Argument", null, null, null);
        eltCollectionProp.appendChild(eltCollProElementProp2);
        Element eltCollProElementProp2StringProp1 = XmlJmx.createProperty(document, "stringProp", "Argument.name", "V_HOST");
        eltCollProElementProp2.appendChild(eltCollProElementProp2StringProp1);
        String host = hSchemeHostPort.get(K_HOST);
        Element eltCollProElementProp2StringProp2 = XmlJmx.createProperty(document, "stringProp", "Argument.value", host);
        eltCollProElementProp2.appendChild(eltCollProElementProp2StringProp2);
        Element eltCollProElementProp2StringProp3 = XmlJmx.createProperty(document, "stringProp", "Argument.metadata", "=");
        eltCollProElementProp2.appendChild(eltCollProElementProp2StringProp3);
        Element eltCollProElementProp3 = this.createElementProp(document, "V_PORT", "Argument", null, null, null);
        eltCollectionProp.appendChild(eltCollProElementProp3);
        String sPort = hSchemeHostPort.get(K_PORT);
        Element eltCollProElementProp3StringProp1 = XmlJmx.createProperty(document, "stringProp", "Argument.name", "V_PORT");
        eltCollProElementProp3.appendChild(eltCollProElementProp3StringProp1);
        Element eltCollProElementProp3StringProp2 = XmlJmx.createProperty(document, "stringProp", "Argument.value", sPort);
        eltCollProElementProp3.appendChild(eltCollProElementProp3StringProp2);
        Element eltCollProElementProp3StringProp3 = XmlJmx.createProperty(document, "stringProp", "Argument.metadata", "=");
        eltCollProElementProp3.appendChild(eltCollProElementProp3StringProp3);
        return eltArguments;
    }

    protected Element createConfigTestElement(Document document) {
        Element eltConfigTestElement = document.createElement("ConfigTestElement");
        Attr attrConfigTestElementguiclass = document.createAttribute("guiclass");
        attrConfigTestElementguiclass.setValue("HttpDefaultsGui");
        eltConfigTestElement.setAttributeNode(attrConfigTestElementguiclass);
        Attr attrConfigTestElementtestclass = document.createAttribute("testclass");
        attrConfigTestElementtestclass.setValue("ConfigTestElement");
        eltConfigTestElement.setAttributeNode(attrConfigTestElementtestclass);
        Attr attrConfigTestElementtestname = document.createAttribute("testname");
        attrConfigTestElementtestname.setValue("HTTP Request Defaults");
        eltConfigTestElement.setAttributeNode(attrConfigTestElementtestname);
        Attr attrConfigTestElementenabled = document.createAttribute("enabled");
        attrConfigTestElementenabled.setValue("true");
        eltConfigTestElement.setAttributeNode(attrConfigTestElementenabled);
        Element eltConfigTestElementProp = this.createElementProp(document, "HTTPsampler.Arguments", "Arguments", "HTTPArgumentsPanel", "Arguments", "User Defined Variables");
        eltConfigTestElement.appendChild(eltConfigTestElementProp);
        Element eltCollectionProp1 = XmlJmx.createProperty(document, "collectionProp", "Arguments.arguments", null);
        eltConfigTestElement.appendChild(eltCollectionProp1);
        Element eltStringProp1 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.domain", "${V_HOST}");
        eltConfigTestElement.appendChild(eltStringProp1);
        Element eltStringProp2 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.port", "${V_PORT}");
        eltConfigTestElement.appendChild(eltStringProp2);
        Element eltStringProp3 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.protocol", "${V_SCHEME}");
        eltConfigTestElement.appendChild(eltStringProp3);
        Element eltStringProp4 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.contentEncoding", "");
        eltConfigTestElement.appendChild(eltStringProp4);
        Element eltStringProp5 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.path", "");
        eltConfigTestElement.appendChild(eltStringProp5);
        Element eltStringProp6 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.concurrentPool", "6");
        eltConfigTestElement.appendChild(eltStringProp6);
        Element eltStringProp7 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.connect_timeout", "");
        eltConfigTestElement.appendChild(eltStringProp7);
        Element eltStringProp8 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.response_timeout", "");
        eltConfigTestElement.appendChild(eltStringProp8);
        return eltConfigTestElement;
    }

    protected Element createHttpSamplerProxy(Document document, String testname, String scheme, String host, int iPort, HarRequest harRequest) throws URISyntaxException {
        int port;
        Element eltHTTPSamplerProxy = document.createElement("HTTPSamplerProxy");
        Attr attrHTTPSamplerProxyguiclass = document.createAttribute("guiclass");
        attrHTTPSamplerProxyguiclass.setValue("HttpTestSampleGui");
        eltHTTPSamplerProxy.setAttributeNode(attrHTTPSamplerProxyguiclass);
        Attr attrHTTPSamplerProxytestclass = document.createAttribute("testclass");
        attrHTTPSamplerProxytestclass.setValue("HTTPSamplerProxy");
        eltHTTPSamplerProxy.setAttributeNode(attrHTTPSamplerProxytestclass);
        Attr attrHTTPSamplerProxytestname = document.createAttribute("testname");
        attrHTTPSamplerProxytestname.setValue(testname);
        eltHTTPSamplerProxy.setAttributeNode(attrHTTPSamplerProxytestname);
        Attr attrHTTPSamplerProxyenabled = document.createAttribute("enabled");
        attrHTTPSamplerProxyenabled.setValue("true");
        eltHTTPSamplerProxy.setAttributeNode(attrHTTPSamplerProxyenabled);
        HarPostData postData = harRequest.getPostData();
        String mimeType = postData.getMimeType();
        String doMultiPart = "false";
        if (mimeType != null && mimeType.contains("multipart/form-data")) {
            doMultiPart = "true";
        }
        URI url = new URI(harRequest.getUrl());
        String hostInter = "";
        if (!host.equalsIgnoreCase(url.getHost())) {
            hostInter = url.getHost();
        }
        Element stringProp1 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.domain", hostInter);
        eltHTTPSamplerProxy.appendChild(stringProp1);
        int defautPort = 443;
        if ("http".equalsIgnoreCase(url.getScheme())) {
            defautPort = 80;
        }
        if ("ws".equalsIgnoreCase(url.getScheme())) {
            defautPort = 80;
        }
        String sPortInter = "";
        int n = port = url.getPort() == -1 ? defautPort : url.getPort();
        if (iPort != port) {
            sPortInter = "" + port;
        }
        Element stringProp2 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.port", sPortInter);
        eltHTTPSamplerProxy.appendChild(stringProp2);
        String schemeInter = "";
        if (!scheme.equalsIgnoreCase(url.getScheme())) {
            schemeInter = url.getScheme();
        }
        Element stringProp3 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.protocol", schemeInter);
        eltHTTPSamplerProxy.appendChild(stringProp3);
        String methodInter = harRequest.getMethod().name();
        String contentEncodingInter = "";
        if (("POST".equalsIgnoreCase(methodInter) || "PUT".equalsIgnoreCase(methodInter) || "PATCH".equalsIgnoreCase(methodInter)) && harRequest.getHeaders() != null && harRequest.getHeaders().size() > 0) {
            for (HarHeader header : harRequest.getHeaders()) {
                String headerName = header.getName();
                String headerValue = header.getValue();
                if (!"Content-Type".equalsIgnoreCase(headerName) || !"application/json".equalsIgnoreCase(headerValue)) continue;
                contentEncodingInter = "UTF-8";
                break;
            }
        }
        Element stringProp4 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.contentEncoding", contentEncodingInter);
        eltHTTPSamplerProxy.appendChild(stringProp4);
        String pathInter = url.getPath();
        if (("POST".equalsIgnoreCase(methodInter) || "PUT".equalsIgnoreCase(methodInter) || "PATCH".equalsIgnoreCase(methodInter)) && url.getQuery() != null) {
            pathInter = pathInter + "?" + url.getQuery();
        }
        Element stringProp5 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.path", pathInter);
        eltHTTPSamplerProxy.appendChild(stringProp5);
        Element stringProp6 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.method", methodInter);
        eltHTTPSamplerProxy.appendChild(stringProp6);
        Element boolProp7 = XmlJmx.createProperty(document, "boolProp", "HTTPSampler.follow_redirects", "false");
        eltHTTPSamplerProxy.appendChild(boolProp7);
        Element boolProp8 = XmlJmx.createProperty(document, "boolProp", "HTTPSampler.auto_redirects", "false");
        eltHTTPSamplerProxy.appendChild(boolProp8);
        Element boolProp9 = XmlJmx.createProperty(document, "boolProp", "HTTPSampler.use_keepalive", "true");
        eltHTTPSamplerProxy.appendChild(boolProp9);
        Element boolProp10 = XmlJmx.createProperty(document, "boolProp", "HTTPSampler.DO_MULTIPART_POST", doMultiPart);
        eltHTTPSamplerProxy.appendChild(boolProp10);
        Element stringProp11 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.embedded_url_re", null);
        eltHTTPSamplerProxy.appendChild(stringProp11);
        Element stringProp12 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.connect_timeout", null);
        eltHTTPSamplerProxy.appendChild(stringProp12);
        Element stringProp13 = XmlJmx.createProperty(document, "stringProp", "HTTPSampler.response_timeout", null);
        eltHTTPSamplerProxy.appendChild(stringProp13);
        eltHTTPSamplerProxy = this.createHttpSamplerParams(document, harRequest, eltHTTPSamplerProxy);
        return eltHTTPSamplerProxy;
    }

    protected Element createHttpSamplerParams(Document document, HarRequest harRequest, Element eltHTTPSamplerProxy) {
        Element eltHTTPSamplerProxyElementPropArguments = this.createElementProp(document, "HTTPsampler.Arguments", "Arguments", "HTTPArgumentsPanel", "Arguments", null);
        Element collectionProp = document.createElement("collectionProp");
        Attr attrcollectionPropname = document.createAttribute("name");
        attrcollectionPropname.setValue("Arguments.arguments");
        collectionProp.setAttributeNode(attrcollectionPropname);
        boolean isParamAdd = false;
        if (harRequest.getMethod().equals((Object)HttpMethod.POST) || harRequest.getMethod().equals((Object)HttpMethod.PUT) || harRequest.getMethod().equals((Object)HttpMethod.PATCH)) {
            String paramValue;
            Element boolProp5;
            Element stringProp4;
            Element stringProp3;
            Element stringProp2;
            Element boolProp1;
            Element boolPropPostBodyRaw;
            HarPostData postData = harRequest.getPostData();
            String mimeType = postData.getMimeType();
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(mimeType = Utils.extractMimeType(mimeType))) {
                boolPropPostBodyRaw = XmlJmx.createProperty(document, "boolProp", "HTTPSampler.postBodyRaw", "false");
                eltHTTPSamplerProxy.appendChild(boolPropPostBodyRaw);
                for (HarPostDataParam harPostDataParam : postData.getParams()) {
                    String paramName = harPostDataParam.getName();
                    String paramValue2 = harPostDataParam.getValue();
                    String contentType = harPostDataParam.getContentType();
                    String fileName = harPostDataParam.getFileName();
                    String comment = harPostDataParam.getComment();
                    Element elementProp = document.createElement("elementProp");
                    Attr attrElementPropname = document.createAttribute("name");
                    attrElementPropname.setValue(paramName);
                    elementProp.setAttributeNode(attrElementPropname);
                    Attr attrElementPropelementType = document.createAttribute("elementType");
                    attrElementPropelementType.setValue("HTTPArgument");
                    elementProp.setAttributeNode(attrElementPropelementType);
                    boolean isNeedEncode = false;
                    if (paramValue2.contains(" ") || paramValue2.contains("=") || paramValue2.contains("/") || paramValue2.contains("+")) {
                        isNeedEncode = true;
                    }
                    boolProp1 = XmlJmx.createProperty(document, "boolProp", "HTTPArgument.always_encode", "" + isNeedEncode);
                    elementProp.appendChild(boolProp1);
                    stringProp2 = XmlJmx.createProperty(document, "stringProp", "Argument.name", paramName);
                    elementProp.appendChild(stringProp2);
                    stringProp3 = XmlJmx.createProperty(document, "stringProp", "Argument.value", paramValue2);
                    elementProp.appendChild(stringProp3);
                    stringProp4 = XmlJmx.createProperty(document, "stringProp", "Argument.metadata", "=");
                    elementProp.appendChild(stringProp4);
                    boolProp5 = XmlJmx.createProperty(document, "boolProp", "HTTPArgument.use_equals", "true");
                    elementProp.appendChild(boolProp5);
                    collectionProp.appendChild(elementProp);
                    isParamAdd = true;
                }
            }
            if (mimeType != null && mimeType.contains("multipart/form-data")) {
                isParamAdd = true;
                boolPropPostBodyRaw = XmlJmx.createProperty(document, "boolProp", "HTTPSampler.postBodyRaw", "false");
                eltHTTPSamplerProxy.appendChild(boolPropPostBodyRaw);
                HarPostData postDataModified = HarForJMeter.extractParamsFromMultiPart(harRequest);
                for (HarPostDataParam dataParam : postDataModified.getParams()) {
                    String paramName = dataParam.getName();
                    paramValue = dataParam.getValue();
                    String contentType = dataParam.getContentType();
                    String fileName = dataParam.getFileName();
                    String comment = dataParam.getComment();
                    if (fileName != null) {
                        Element eltHTTPSamplerProxyHTTPsamplerFiles = this.createElementProp(document, "HTTPsampler.Files", "HTTPFileArgs", null, null, null);
                        Element eltPropCollectionProp = document.createElement("collectionProp");
                        Attr attrPropCollectionPropname = document.createAttribute("name");
                        attrPropCollectionPropname.setValue("HTTPFileArgs.files");
                        eltPropCollectionProp.setAttributeNode(attrPropCollectionPropname);
                        if (contentType == null) {
                            contentType = "";
                        }
                        Element eltPropFileName = this.createElementProp(document, fileName, "HTTPFileArg", null, null, null);
                        Element stringProp1 = XmlJmx.createProperty(document, "stringProp", "File.mimetype", contentType);
                        eltPropFileName.appendChild(stringProp1);
                        Element stringProp22 = XmlJmx.createProperty(document, "stringProp", "File.path", fileName);
                        eltPropFileName.appendChild(stringProp22);
                        Element stringProp32 = XmlJmx.createProperty(document, "stringProp", "File.paramname", paramName);
                        eltPropFileName.appendChild(stringProp32);
                        eltPropCollectionProp.appendChild(eltPropFileName);
                        eltHTTPSamplerProxyHTTPsamplerFiles.appendChild(eltPropCollectionProp);
                        eltHTTPSamplerProxy.appendChild(eltHTTPSamplerProxyHTTPsamplerFiles);
                        continue;
                    }
                    Element elementProp = document.createElement("elementProp");
                    Attr attrElementPropname = document.createAttribute("name");
                    attrElementPropname.setValue(paramName);
                    elementProp.setAttributeNode(attrElementPropname);
                    Attr attrElementPropelementType = document.createAttribute("elementType");
                    attrElementPropelementType.setValue("HTTPArgument");
                    elementProp.setAttributeNode(attrElementPropelementType);
                    boolProp1 = XmlJmx.createProperty(document, "boolProp", "HTTPArgument.always_encode", "false");
                    elementProp.appendChild(boolProp1);
                    stringProp2 = XmlJmx.createProperty(document, "stringProp", "Argument.name", paramName);
                    elementProp.appendChild(stringProp2);
                    stringProp3 = XmlJmx.createProperty(document, "stringProp", "Argument.value", paramValue);
                    elementProp.appendChild(stringProp3);
                    stringProp4 = XmlJmx.createProperty(document, "stringProp", "Argument.metadata", "=");
                    elementProp.appendChild(stringProp4);
                    boolProp5 = XmlJmx.createProperty(document, "boolProp", "HTTPArgument.use_equals", "true");
                    elementProp.appendChild(boolProp5);
                    collectionProp.appendChild(elementProp);
                }
            }
            if (!isParamAdd) {
                boolPropPostBodyRaw = XmlJmx.createProperty(document, "boolProp", "HTTPSampler.postBodyRaw", "true");
                eltHTTPSamplerProxy.appendChild(boolPropPostBodyRaw);
                Element elementProp = document.createElement("elementProp");
                Attr attr = document.createAttribute("name");
                attr.setValue("");
                elementProp.setAttributeNode(attr);
                Attr attrElementPropelementType = document.createAttribute("elementType");
                attrElementPropelementType.setValue("HTTPArgument");
                elementProp.setAttributeNode(attrElementPropelementType);
                Element boolProp12 = XmlJmx.createProperty(document, "boolProp", "HTTPArgument.always_encode", "false");
                elementProp.appendChild(boolProp12);
                paramValue = postData.getText();
                if (paramValue == null) {
                    paramValue = "";
                }
                Element stringProp33 = XmlJmx.createProperty(document, "stringProp", "Argument.value", paramValue);
                elementProp.appendChild(stringProp33);
                Element stringProp42 = XmlJmx.createProperty(document, "stringProp", "Argument.metadata", "=");
                elementProp.appendChild(stringProp42);
                collectionProp.appendChild(elementProp);
                isParamAdd = true;
            }
        }
        if (!(harRequest.getMethod().equals((Object)HttpMethod.POST) || harRequest.getMethod().equals((Object)HttpMethod.PUT) || harRequest.getMethod().equals((Object)HttpMethod.PATCH))) {
            Element boolPropPostBodyRaw = XmlJmx.createProperty(document, "boolProp", "HTTPSampler.postBodyRaw", "false");
            eltHTTPSamplerProxy.appendChild(boolPropPostBodyRaw);
            for (HarQueryParam queryParam : harRequest.getQueryString()) {
                String paramName = queryParam.getName();
                String string = queryParam.getValue();
                boolean isNeedEncode = false;
                if (string.contains(" ") || string.contains("=") || string.contains("/") || string.contains("/") || string.contains("+")) {
                    isNeedEncode = true;
                }
                Element elementProp = document.createElement("elementProp");
                Attr attrElementPropname = document.createAttribute("name");
                attrElementPropname.setValue(paramName);
                elementProp.setAttributeNode(attrElementPropname);
                Attr attrElementPropelementType = document.createAttribute("elementType");
                attrElementPropelementType.setValue("HTTPArgument");
                elementProp.setAttributeNode(attrElementPropelementType);
                Element boolProp1 = XmlJmx.createProperty(document, "boolProp", "HTTPArgument.always_encode", "" + isNeedEncode);
                elementProp.appendChild(boolProp1);
                Element stringProp2 = XmlJmx.createProperty(document, "stringProp", "Argument.name", paramName);
                elementProp.appendChild(stringProp2);
                Element stringProp3 = XmlJmx.createProperty(document, "stringProp", "Argument.value", string);
                elementProp.appendChild(stringProp3);
                Element stringProp4 = XmlJmx.createProperty(document, "stringProp", "Argument.metadata", "=");
                elementProp.appendChild(stringProp4);
                Element boolProp5 = XmlJmx.createProperty(document, "boolProp", "HTTPArgument.use_equals", "true");
                elementProp.appendChild(boolProp5);
                collectionProp.appendChild(elementProp);
            }
        }
        eltHTTPSamplerProxyElementPropArguments.appendChild(collectionProp);
        eltHTTPSamplerProxy.appendChild(eltHTTPSamplerProxyElementPropArguments);
        return eltHTTPSamplerProxy;
    }

    protected Element createHeaderManager(Document document, HarRequest harRequest, boolean isRemoveCookie, boolean isRemoveCacheRequest) {
        Element eltHeadManager = document.createElement("HeaderManager");
        Attr attreltHeadManagerguiclass = document.createAttribute("guiclass");
        attreltHeadManagerguiclass.setValue("HeaderPanel");
        eltHeadManager.setAttributeNode(attreltHeadManagerguiclass);
        Attr attreltHeadManagertestclass = document.createAttribute("testclass");
        attreltHeadManagertestclass.setValue("HeaderManager");
        eltHeadManager.setAttributeNode(attreltHeadManagertestclass);
        Attr attreltHeadManagertestname = document.createAttribute("testname");
        attreltHeadManagertestname.setValue("HTTP Header Manager");
        eltHeadManager.setAttributeNode(attreltHeadManagertestname);
        Attr attreltHeadManagerenabled = document.createAttribute("enabled");
        attreltHeadManagerenabled.setValue("true");
        eltHeadManager.setAttributeNode(attreltHeadManagerenabled);
        Element headers = this.createHttpSamplerHeaders(document, harRequest, isRemoveCookie, isRemoveCacheRequest);
        eltHeadManager.appendChild(headers);
        return eltHeadManager;
    }

    protected Element createHttpSamplerHeaders(Document document, HarRequest harRequest, boolean isRemoveCookie, boolean isRemoveCacheRequest) {
        Element collectionProp = document.createElement("collectionProp");
        Attr attrcollectionPropname = document.createAttribute("name");
        attrcollectionPropname.setValue("HeaderManager.headers");
        collectionProp.setAttributeNode(attrcollectionPropname);
        if (harRequest.getHeaders() != null && harRequest.getHeaders().size() > 0) {
            for (HarHeader header : harRequest.getHeaders()) {
                String headerName = header.getName();
                String headerValue = header.getValue();
                boolean addThisHearder = true;
                if ("Cookie".equalsIgnoreCase(headerName) && isRemoveCookie) {
                    addThisHearder = false;
                }
                if (("If-Modified-Since".equalsIgnoreCase(headerName) || "If-None-Match".equalsIgnoreCase(headerName) || "If-Last-Modified".equalsIgnoreCase(headerName)) && isRemoveCacheRequest) {
                    addThisHearder = false;
                }
                if ("Content-Length".equalsIgnoreCase(headerName)) {
                    addThisHearder = false;
                }
                if (headerName != null && !headerName.isEmpty() && headerName.startsWith(":")) {
                    addThisHearder = false;
                }
                if (!addThisHearder) continue;
                Element elementProp = this.createElementProp(document, headerName, "Header", null, null, null);
                Element stringProp1 = XmlJmx.createProperty(document, "stringProp", "Header.name", headerName);
                elementProp.appendChild(stringProp1);
                Element stringProp2 = XmlJmx.createProperty(document, "stringProp", "Header.value", headerValue);
                elementProp.appendChild(stringProp2);
                collectionProp.appendChild(elementProp);
            }
        }
        return collectionProp;
    }

    protected Element createTestActionPause(Document document, String testname, long pauseMs) {
        Element eltTestAction = document.createElement("TestAction");
        Attr attrTestActionguiclass = document.createAttribute("guiclass");
        attrTestActionguiclass.setValue("TestActionGui");
        eltTestAction.setAttributeNode(attrTestActionguiclass);
        Attr attrTestActiontestclass = document.createAttribute("testclass");
        attrTestActiontestclass.setValue("TestAction");
        eltTestAction.setAttributeNode(attrTestActiontestclass);
        Attr attrTestActiontestname = document.createAttribute("testname");
        attrTestActiontestname.setValue(testname);
        eltTestAction.setAttributeNode(attrTestActiontestname);
        Attr attrTestActionenabled = document.createAttribute("enabled");
        attrTestActionenabled.setValue("true");
        eltTestAction.setAttributeNode(attrTestActionenabled);
        Element eltIntProp1 = XmlJmx.createProperty(document, "intProp", "ActionProcessor.action", "1");
        eltTestAction.appendChild(eltIntProp1);
        Element eltIntProp2 = XmlJmx.createProperty(document, "intProp", "ActionProcessor.target", "0");
        eltTestAction.appendChild(eltIntProp2);
        Element eltStringProp3 = XmlJmx.createProperty(document, "stringProp", "ActionProcessor.duration", "" + pauseMs);
        eltTestAction.appendChild(eltStringProp3);
        return eltTestAction;
    }

    HashMap getSchemeHostPortFirstPageOrUrl(Har har) throws URISyntaxException {
        String scheme = "";
        String host = "";
        int iPort = 0;
        List<HarEntry> lEntries = har.getLog().getEntries();
        if (lEntries != null && lEntries.size() > 0) {
            HarEntry harEntryInter = lEntries.get(0);
            URI pageUrl = new URI(harEntryInter.getRequest().getUrl());
            scheme = pageUrl.getScheme();
            host = pageUrl.getHost();
            iPort = pageUrl.getPort();
            if (iPort == -1 && "http".equalsIgnoreCase(scheme)) {
                iPort = 80;
            }
            if (iPort == -1 && "https".equalsIgnoreCase(scheme)) {
                iPort = 443;
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(K_SCHEME, scheme);
        hashMap.put(K_HOST, host);
        hashMap.put(K_PORT, "" + iPort);
        return hashMap;
    }

    public static void saveXmFile(Document document, String jmxXmlFileOut) throws TransformerException {
        LOGGER.fine("saveXmFile, param jmxXmlFileOut=<" + jmxXmlFileOut + ">");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        DOMSource domSource = new DOMSource(document);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jmxXmlFileOut), StandardCharsets.UTF_8));
            StreamResult streamResult = new StreamResult(out);
            transformer.transform(domSource, streamResult);
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }
}

