/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static String dateToIsoFormat(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String sDateIso = sdf.format(calendar.getTime());
        return sDateIso;
    }

    public static String doubleEpocMicroToIsoFormat(double epocSecMicro) {
        double dInterMilli = epocSecMicro * 1000.0;
        long epocMillis = (long)dInterMilli;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(epocMillis);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String sDateIso = sdf.format(calendar.getTime());
        return sDateIso;
    }

    public static long dateIsoFormatToTimeLong(String sDateIso) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date dateIso = sdf.parse(sDateIso);
        return dateIso.getTime();
    }

    public static String extractMimeType(String mimeTypeToExtract) {
        if (mimeTypeToExtract == null) {
            return "";
        }
        String mimeTypeInter = mimeTypeToExtract.toLowerCase();
        String[] tabSplitMime = StringUtils.splitPreserveAllTokens(mimeTypeInter, ';');
        String mimeType = "";
        if (tabSplitMime.length > 1) {
            for (int i = 0; i < tabSplitMime.length; ++i) {
                String param = tabSplitMime[i];
                if (param.contains("charset=") || param.contains("boundary=")) continue;
                mimeType = param;
                break;
            }
        } else {
            mimeType = mimeTypeToExtract;
        }
        return mimeType;
    }
}

