/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har;

import de.sstoehr.harreader.HarReader;
import de.sstoehr.harreader.HarReaderException;
import de.sstoehr.harreader.model.Har;
import de.sstoehr.harreader.model.HarCreatorBrowser;
import de.sstoehr.harreader.model.HarPostData;
import de.sstoehr.harreader.model.HarPostDataParam;
import de.sstoehr.harreader.model.HarRequest;
import io.github.vdaburon.jmeter.har.Har2TestResultsXml;
import io.github.vdaburon.jmeter.har.XmlJmx;
import io.github.vdaburon.jmeter.har.common.TransactionInfo;
import io.github.vdaburon.jmeter.har.external.ManageExternalFile;
import io.github.vdaburon.jmeter.har.lrwr.HarLrTransactions;
import io.github.vdaburon.jmeter.har.lrwr.ManageLrwr;
import io.github.vdaburon.jmeter.har.websocket.ManageWebSocket;
import io.github.vdaburon.jmeter.har.websocket.WebSocketRequest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public class HarForJMeter {
    public static final String APPLICATION_VERSION = "7.1";
    public static final String K_HAR_IN_OPT = "har_in";
    public static final String K_JMETER_FILE_OUT_OPT = "jmx_out";
    public static final String K_CREATE_NEW_TC_AFTER_MS_OPT = "new_tc_pause";
    public static final String K_ADD_PAUSE_OPT = "add_pause";
    public static final String K_REGEX_FILTER_INCLUDE_OPT = "filter_include";
    public static final String K_REGEX_FILTER_EXCLUDE_OPT = "filter_exclude";
    public static final String K_RECORD_FILE_OUT_OPT = "record_out";
    public static final String K_REMOVE_COOKIE_OPT = "remove_cookie";
    public static final String K_REMOVE_CACHE_REQUEST_OPT = "remove_cache_request";
    public static final String K_PAGE_START_NUMBER = "page_start_number";
    public static final String K_SAMPLER_START_NUMBER = "sampler_start_number";
    public static final String K_LRWR_USE_INFOS = "use_lrwr_infos";
    public static final String K_LRWR_USE_TRANSACTION_NAME = "transaction_name";
    public static final String K_EXTERNAL_FILE_INFOS = "external_file_infos";
    public static final String K_ADD_VIEW_RESULT_TREE_WITH_RECORD_FILE = "add_result_tree_record";
    public static final String K_ADD_WEBSOCKET_WITH_PLUGIN_PETER_DOORNBOSH = "ws_with_pdoornbosch";
    private static final Logger LOGGER = Logger.getLogger(HarForJMeter.class.getName());

    public static void main(String[] args) {
        String harFile = "";
        String jmxOut = "";
        long createNewTransactionAfterRequestMs = 0L;
        boolean isAddPause = true;
        String urlFilterToInclude = "";
        String urlFilterToExclude = "";
        String recordXmlOut = "";
        boolean isRemoveCookie = true;
        boolean isRemoveCacheRequest = true;
        boolean isAddViewTreeForRecord = true;
        boolean isWebSocketPDoornbosch = false;
        int pageStartNumber = 1;
        int samplerStartNumber = 1;
        String lrwr_info = "";
        String fileExternalInfo = "";
        long lStart = System.currentTimeMillis();
        LOGGER.info("Start main");
        Options options = HarForJMeter.createOptions();
        Properties parseProperties = null;
        try {
            parseProperties = HarForJMeter.parseOption(options, args);
        }
        catch (ParseException ex) {
            HarForJMeter.helpUsage(options);
            LOGGER.info("main end (exit 1) ERROR");
            System.exit(1);
        }
        String sTmp = "";
        sTmp = (String)parseProperties.get(K_HAR_IN_OPT);
        if (sTmp != null) {
            harFile = sTmp;
        }
        if ((sTmp = (String)parseProperties.get(K_JMETER_FILE_OUT_OPT)) != null) {
            jmxOut = sTmp;
        }
        if ((sTmp = (String)parseProperties.get(K_CREATE_NEW_TC_AFTER_MS_OPT)) != null) {
            try {
                createNewTransactionAfterRequestMs = Integer.parseInt(sTmp);
            }
            catch (Exception ex) {
                LOGGER.warning("Error parsing long parameter new_tc_pause, value = " + sTmp + ", set to 0 (default)");
                createNewTransactionAfterRequestMs = 0L;
            }
        }
        if ((sTmp = (String)parseProperties.get(K_ADD_PAUSE_OPT)) != null) {
            isAddPause = Boolean.parseBoolean(sTmp);
        }
        if ((sTmp = (String)parseProperties.get(K_REGEX_FILTER_INCLUDE_OPT)) != null) {
            urlFilterToInclude = sTmp;
        }
        if ((sTmp = (String)parseProperties.get(K_REGEX_FILTER_EXCLUDE_OPT)) != null) {
            urlFilterToExclude = sTmp;
        }
        if ((sTmp = (String)parseProperties.get(K_RECORD_FILE_OUT_OPT)) != null) {
            recordXmlOut = sTmp;
        }
        if ((sTmp = (String)parseProperties.get(K_REMOVE_COOKIE_OPT)) != null) {
            isRemoveCookie = Boolean.parseBoolean(sTmp);
        }
        if ((sTmp = (String)parseProperties.get(K_REMOVE_CACHE_REQUEST_OPT)) != null) {
            isRemoveCacheRequest = Boolean.parseBoolean(sTmp);
        }
        if ((sTmp = (String)parseProperties.get(K_PAGE_START_NUMBER)) != null) {
            try {
                pageStartNumber = Integer.parseInt(sTmp);
            }
            catch (Exception ex) {
                LOGGER.warning("Error parsing long parameter page_start_number, value = " + sTmp + ", set to 1 (default)");
                pageStartNumber = 1;
            }
        }
        if (pageStartNumber <= 0) {
            pageStartNumber = 1;
        }
        if ((sTmp = (String)parseProperties.get(K_SAMPLER_START_NUMBER)) != null) {
            try {
                samplerStartNumber = Integer.parseInt(sTmp);
            }
            catch (Exception ex) {
                LOGGER.warning("Error parsing long parameter sampler_start_number, value = " + sTmp + ", set to 1 (default)");
                samplerStartNumber = 1;
            }
        }
        if (samplerStartNumber <= 0) {
            samplerStartNumber = 1;
        }
        if ((sTmp = (String)parseProperties.get(K_LRWR_USE_INFOS)) != null) {
            lrwr_info = sTmp;
            if (!lrwr_info.isEmpty() && !K_LRWR_USE_TRANSACTION_NAME.equalsIgnoreCase(sTmp)) {
                LOGGER.warning("This Parameter use_lrwr_infos is not an expected value, value = " + sTmp + ", set to empty (default)");
                lrwr_info = "";
            }
        } else {
            lrwr_info = "";
        }
        if ((sTmp = (String)parseProperties.get(K_EXTERNAL_FILE_INFOS)) != null) {
            fileExternalInfo = sTmp;
        }
        if ((sTmp = (String)parseProperties.get(K_ADD_VIEW_RESULT_TREE_WITH_RECORD_FILE)) != null) {
            isAddViewTreeForRecord = Boolean.parseBoolean(sTmp);
        }
        if ((sTmp = (String)parseProperties.get(K_ADD_WEBSOCKET_WITH_PLUGIN_PETER_DOORNBOSH)) != null) {
            isWebSocketPDoornbosch = Boolean.parseBoolean(sTmp);
        }
        LOGGER.info("************* PARAMETERS ***************");
        LOGGER.info("har_in, harFile=" + harFile);
        LOGGER.info("jmx_out, jmxOut=" + jmxOut);
        LOGGER.info("record_out, recordXmlOut=" + recordXmlOut);
        LOGGER.info("new_tc_pause, createNewTransactionAfterRequestMs=" + createNewTransactionAfterRequestMs);
        LOGGER.info("add_pause, isAddPause=" + isAddPause);
        LOGGER.info("filter_include, urlFilterToInclude=" + urlFilterToInclude);
        LOGGER.info("filter_exclude, urlFilterToExclude=" + urlFilterToExclude);
        LOGGER.info("remove_cookie, isRemoveCookie=" + isRemoveCookie);
        LOGGER.info("remove_cache_request, isRemoveCacheRequest=" + isRemoveCacheRequest);
        LOGGER.info("page_start_number, pageStartNumber=" + pageStartNumber);
        LOGGER.info("sampler_start_number, samplerStartNumber=" + samplerStartNumber);
        LOGGER.info("use_lrwr_infos, lrwr_info=" + lrwr_info);
        LOGGER.info("external_file_infos, fileExternalInfo=" + fileExternalInfo);
        LOGGER.info("add_result_tree_record, isAddViewTreeForRecord=" + isAddViewTreeForRecord);
        LOGGER.info("ws_with_pdoornbosch, isWebSocketPDoornbosch=" + isWebSocketPDoornbosch);
        LOGGER.info("***************************************");
        try {
            HarForJMeter.generateJmxAndRecord(harFile, jmxOut, createNewTransactionAfterRequestMs, isAddPause, isRemoveCookie, isRemoveCacheRequest, urlFilterToInclude, urlFilterToExclude, recordXmlOut, pageStartNumber, samplerStartNumber, lrwr_info, fileExternalInfo, isAddViewTreeForRecord, isWebSocketPDoornbosch);
            long lEnd = System.currentTimeMillis();
            long lDurationMs = lEnd - lStart;
            LOGGER.info("Duration ms : " + lDurationMs);
            LOGGER.info("End main OK exit(0)");
            System.exit(0);
        }
        catch (HarReaderException | MalformedURLException | PatternSyntaxException | ParserConfigurationException | TransformerException e) {
            LOGGER.severe(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        catch (URISyntaxException e) {
            LOGGER.severe(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void generateJmxAndRecord(String harFile, String jmxOut, long createNewTransactionAfterRequestMs, boolean isAddPause, boolean isRemoveCookie, boolean isRemoveCacheRequest, String urlFilterToInclude, String urlFilterToExclude, String recordXmlOut, int pageStartNumber, int samplerStartNumber, String lrwr_info, String fileExternalInfo, boolean isAddViewTreeForRecord, boolean isWebSocketPDoornbosch) throws HarReaderException, MalformedURLException, ParserConfigurationException, URISyntaxException, TransformerException {
        boolean isHarWithLrwr;
        HarForJMeter harForJMeter = new HarForJMeter();
        LOGGER.info("Version=7.1");
        Har har = harForJMeter.loadHarFile(harFile);
        HarCreatorBrowser creator = har.getLog().getCreator();
        String harCreator = "HAR File, Creator : Not Declared";
        if (creator != null) {
            harCreator = "HAR File, Creator : " + creator.getName() + ", version : " + creator.getVersion();
        }
        LOGGER.info(harCreator);
        List<TransactionInfo> listTransactionInfo = null;
        if (K_LRWR_USE_TRANSACTION_NAME.equals(lrwr_info) && (isHarWithLrwr = ManageLrwr.isHarContainsLrwr(harFile))) {
            List<HarLrTransactions> listHarLrTransactions = ManageLrwr.getListTransactionLrwr(harFile);
            listTransactionInfo = ManageLrwr.createListTransactionInfo(listHarLrTransactions);
        }
        if (!fileExternalInfo.isEmpty()) {
            try {
                listTransactionInfo = ManageExternalFile.createListTransactionInfo(fileExternalInfo);
            }
            catch (Exception e) {
                LOGGER.severe("Can't read file or content : " + fileExternalInfo + ", exception : " + e.toString());
            }
        }
        WebSocketRequest webSocketRequest = null;
        if (isWebSocketPDoornbosch) {
            webSocketRequest = ManageWebSocket.getWebSocketRequest(harFile);
        }
        LOGGER.info("************ Start of JMX file creation (JMeter script file) **");
        harForJMeter.convertHarToJmx(har, jmxOut, createNewTransactionAfterRequestMs, isAddPause, isRemoveCookie, isRemoveCacheRequest, urlFilterToInclude, urlFilterToExclude, pageStartNumber, samplerStartNumber, listTransactionInfo, isAddViewTreeForRecord, webSocketRequest, recordXmlOut);
        LOGGER.info("************ End of JMX file creation              ************");
        if (!recordXmlOut.isEmpty()) {
            LOGGER.info("************ Start of Recording XML file creation ************");
            harForJMeter.harToRecordXml(har, recordXmlOut, urlFilterToInclude, urlFilterToExclude, pageStartNumber, samplerStartNumber, webSocketRequest);
            LOGGER.info("************ End of Recording XML file creation   ************");
        }
    }

    protected Har loadHarFile(String fileHar) throws HarReaderException {
        Har har = new HarReader().readFromFile(new File(fileHar));
        return har;
    }

    protected void convertHarToJmx(Har har, String jmxXmlOutFile, long createNewTransactionAfterRequestMs, boolean isAddPause, boolean isRemoveCookie, boolean isRemoveCacheRequest, String urlFilterToInclude, String urlFilterToExclude, int pageStartNumber, int samplerStartNumber, List<TransactionInfo> listTransactionInfo, boolean isAddViewTreeForRecord, WebSocketRequest webSocketRequest, String recordXmlOut) throws ParserConfigurationException, TransformerException, URISyntaxException {
        XmlJmx xmlJmx = new XmlJmx();
        Document jmxDocument = xmlJmx.convertHarToJmxXml(har, createNewTransactionAfterRequestMs, isAddPause, isRemoveCookie, isRemoveCacheRequest, urlFilterToInclude, urlFilterToExclude, pageStartNumber, samplerStartNumber, listTransactionInfo, isAddViewTreeForRecord, webSocketRequest, recordXmlOut);
        XmlJmx.saveXmFile(jmxDocument, jmxXmlOutFile);
    }

    protected void harToRecordXml(Har har, String jmxXmlOutFile, String urlFilterToInclude, String urlFilterToExclude, int pageStartNumber, int samplerStartNumber, WebSocketRequest webSocketRequest) throws ParserConfigurationException, TransformerException, URISyntaxException, MalformedURLException {
        Har2TestResultsXml har2TestResultsXml = new Har2TestResultsXml();
        Document jmxDocument = har2TestResultsXml.convertHarToTestResultXml(har, urlFilterToInclude, urlFilterToExclude, samplerStartNumber, webSocketRequest);
        XmlJmx.saveXmFile(jmxDocument, jmxXmlOutFile);
    }

    public static HarPostData extractParamsFromMultiPart(HarRequest harRequest) {
        HarPostData harPostData = harRequest.getPostData();
        String mimeType = harPostData.getMimeType();
        HarPostData harPostDataModified = new HarPostData();
        ArrayList<HarPostDataParam> listParams = new ArrayList<HarPostDataParam>();
        String boundary = StringUtils.substringAfter(mimeType, "boundary=");
        LOGGER.fine("boundary=<" + boundary + ">");
        String text = harPostData.getText();
        String[] tabParams = StringUtils.splitByWholeSeparator(text, "--" + boundary + "\r\n");
        LOGGER.info("Number of parameters in Multi-Parts=" + tabParams.length);
        for (int i = 0; i < tabParams.length; ++i) {
            String paramInter = tabParams[i];
            paramInter = paramInter.substring(0, Math.min(512, paramInter.length()));
            LOGGER.fine("param=<" + paramInter + ">");
            String paramName = StringUtils.substringBetween(paramInter, "Content-Disposition: form-data; name=\"", "\"");
            LOGGER.fine("paramName=<" + paramName + ">");
            String paramNameLine = "Content-Disposition: form-data; name=\"" + paramName + "\"\rn";
            String afterParamName = paramInter.substring(paramNameLine.length());
            LOGGER.fine("afterParamName=<" + afterParamName + ">");
            String paramValue = afterParamName.trim();
            String paramValue2 = StringUtils.substringBefore(paramValue, "\r\n");
            if (paramValue2 != null) {
                paramValue = paramValue2;
            }
            LOGGER.fine("paramValue=<" + paramValue + ">");
            String fileName = StringUtils.substringBetween(paramValue, "filename=\"", "\"");
            String contentType = StringUtils.substringBetween(afterParamName, "Content-Type: ", "\r\n");
            LOGGER.fine("fileName=<" + fileName + ">");
            LOGGER.fine("contentType=<" + contentType + ">");
            HarPostDataParam harPostDataParam = new HarPostDataParam();
            harPostDataParam.setName(paramName);
            if (fileName == null) {
                harPostDataParam.setValue(paramValue);
            }
            harPostDataParam.setContentType(contentType);
            harPostDataParam.setFileName(fileName);
            listParams.add(harPostDataParam);
        }
        harPostDataModified.setParams(listParams);
        return harPostDataModified;
    }

    private static Options createOptions() {
        Options options = new Options();
        Option helpOpt = Option.builder("help").hasArg(false).desc("Help and show parameters").build();
        options.addOption(helpOpt);
        Option harFileInOpt = Option.builder(K_HAR_IN_OPT).argName(K_HAR_IN_OPT).hasArg(true).required(true).desc("Har file to read (e.g : my_file.har)").build();
        options.addOption(harFileInOpt);
        Option jmeterFileOutOpt = Option.builder(K_JMETER_FILE_OUT_OPT).argName(K_JMETER_FILE_OUT_OPT).hasArg(true).required(true).desc("JMeter file created to write (e.g : script.jmx)").build();
        options.addOption(jmeterFileOutOpt);
        Option createNewTcOpt = Option.builder(K_CREATE_NEW_TC_AFTER_MS_OPT).argName(K_CREATE_NEW_TC_AFTER_MS_OPT).hasArg(true).required(false).desc("Optional, create new Transaction Controller after request ms, same as jmeter property : proxy.pause, need to be > 0 if set. Usefully for Har created by Firefox or Single Page Application (Angular, ReactJS, VuesJS ...)").build();
        options.addOption(createNewTcOpt);
        Option addPauseOpt = Option.builder(K_ADD_PAUSE_OPT).argName(K_ADD_PAUSE_OPT).hasArg(true).required(false).desc("Optional boolean, add Flow Control Action Pause after Transaction Controller (default true)").build();
        options.addOption(addPauseOpt);
        Option removeCookieHeaderOpt = Option.builder(K_REMOVE_COOKIE_OPT).argName(K_REMOVE_COOKIE_OPT).hasArg(true).required(false).desc("Optional boolean, remove cookie in http header (default true because add a Cookie Manager)").build();
        options.addOption(removeCookieHeaderOpt);
        Option removeCacherHeaderRequestOpt = Option.builder(K_REMOVE_CACHE_REQUEST_OPT).argName(K_REMOVE_CACHE_REQUEST_OPT).hasArg(true).required(false).desc("Optional boolean, remove cache header in the http request (default true because add a Cache Manager)").build();
        options.addOption(removeCacherHeaderRequestOpt);
        Option filterRegIncludeOpt = Option.builder(K_REGEX_FILTER_INCLUDE_OPT).argName(K_REGEX_FILTER_INCLUDE_OPT).hasArg(true).required(false).desc("Optional, regular expression to include url").build();
        options.addOption(filterRegIncludeOpt);
        Option filterRegExcludeOpt = Option.builder(K_REGEX_FILTER_EXCLUDE_OPT).argName(K_REGEX_FILTER_EXCLUDE_OPT).hasArg(true).required(false).desc("Optional, regular expression to exclude url").build();
        options.addOption(filterRegExcludeOpt);
        Option recordFileOutOpt = Option.builder(K_RECORD_FILE_OUT_OPT).argName(K_RECORD_FILE_OUT_OPT).hasArg(true).required(false).desc("Optional, file xml contains exchanges likes recorded by JMeter").build();
        options.addOption(recordFileOutOpt);
        Option pageStartNumberOpt = Option.builder(K_PAGE_START_NUMBER).argName(K_PAGE_START_NUMBER).hasArg(true).required(false).desc("Optional, the start page number for partial recording (default 1)").build();
        options.addOption(pageStartNumberOpt);
        Option samplerStartNumberOpt = Option.builder(K_SAMPLER_START_NUMBER).argName(K_SAMPLER_START_NUMBER).hasArg(true).required(false).desc("Optional, the start sampler number for partial recording (default 1)").build();
        options.addOption(samplerStartNumberOpt);
        Option lrwrUseInfosOpt = Option.builder(K_LRWR_USE_INFOS).argName(K_LRWR_USE_INFOS).hasArg(true).required(false).desc("Optional, the har file has been generated with LoadRunner Web Recorder and contains Transaction Name, expected value : 'transaction_name' or don't add this parameter").build();
        options.addOption(lrwrUseInfosOpt);
        Option externalFileInfosOpt = Option.builder(K_EXTERNAL_FILE_INFOS).argName(K_EXTERNAL_FILE_INFOS).hasArg(true).required(false).desc("Optional, csv file contains external infos : timestamp transaction name and start or end").build();
        options.addOption(externalFileInfosOpt);
        Option addViewResultTreeForRecordOpt = Option.builder(K_ADD_VIEW_RESULT_TREE_WITH_RECORD_FILE).argName(K_ADD_VIEW_RESULT_TREE_WITH_RECORD_FILE).hasArg(true).required(false).desc("Optional boolean, add 'View Result Tree' to view the record.xml file created (default true), record_out must be not empty").build();
        options.addOption(addViewResultTreeForRecordOpt);
        Option addWsPluginPeterDoornboshOpt = Option.builder(K_ADD_WEBSOCKET_WITH_PLUGIN_PETER_DOORNBOSH).argName(K_ADD_WEBSOCKET_WITH_PLUGIN_PETER_DOORNBOSH).hasArg(true).required(false).desc("Optional boolean, Manage websocket messages with the JMeter plugin from Peter DOORNBOSH (default false), if true need the plugin from Peter DOORNBOSH to open the generated script").build();
        options.addOption(addWsPluginPeterDoornboshOpt);
        return options;
    }

    private static Properties parseOption(Options optionsP, String[] args) throws ParseException, MissingOptionException {
        Properties properties = new Properties();
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(optionsP, args);
        if (line.hasOption("help")) {
            properties.setProperty("help", "help value");
            return properties;
        }
        if (line.hasOption(K_HAR_IN_OPT)) {
            properties.setProperty(K_HAR_IN_OPT, line.getOptionValue(K_HAR_IN_OPT));
        }
        if (line.hasOption(K_JMETER_FILE_OUT_OPT)) {
            properties.setProperty(K_JMETER_FILE_OUT_OPT, line.getOptionValue(K_JMETER_FILE_OUT_OPT));
        }
        if (line.hasOption(K_CREATE_NEW_TC_AFTER_MS_OPT)) {
            properties.setProperty(K_CREATE_NEW_TC_AFTER_MS_OPT, line.getOptionValue(K_CREATE_NEW_TC_AFTER_MS_OPT));
        }
        if (line.hasOption(K_ADD_PAUSE_OPT)) {
            properties.setProperty(K_ADD_PAUSE_OPT, line.getOptionValue(K_ADD_PAUSE_OPT));
        }
        if (line.hasOption(K_REMOVE_COOKIE_OPT)) {
            properties.setProperty(K_REMOVE_COOKIE_OPT, line.getOptionValue(K_REMOVE_COOKIE_OPT));
        }
        if (line.hasOption(K_REMOVE_CACHE_REQUEST_OPT)) {
            properties.setProperty(K_ADD_PAUSE_OPT, line.getOptionValue(K_ADD_PAUSE_OPT));
        }
        if (line.hasOption(K_REGEX_FILTER_INCLUDE_OPT)) {
            properties.setProperty(K_REGEX_FILTER_INCLUDE_OPT, line.getOptionValue(K_REGEX_FILTER_INCLUDE_OPT));
        }
        if (line.hasOption(K_REGEX_FILTER_EXCLUDE_OPT)) {
            properties.setProperty(K_REGEX_FILTER_EXCLUDE_OPT, line.getOptionValue(K_REGEX_FILTER_EXCLUDE_OPT));
        }
        if (line.hasOption(K_RECORD_FILE_OUT_OPT)) {
            properties.setProperty(K_RECORD_FILE_OUT_OPT, line.getOptionValue(K_RECORD_FILE_OUT_OPT));
        }
        if (line.hasOption(K_PAGE_START_NUMBER)) {
            properties.setProperty(K_PAGE_START_NUMBER, line.getOptionValue(K_PAGE_START_NUMBER));
        }
        if (line.hasOption(K_SAMPLER_START_NUMBER)) {
            properties.setProperty(K_SAMPLER_START_NUMBER, line.getOptionValue(K_SAMPLER_START_NUMBER));
        }
        if (line.hasOption(K_LRWR_USE_INFOS)) {
            properties.setProperty(K_LRWR_USE_INFOS, line.getOptionValue(K_LRWR_USE_INFOS));
        }
        if (line.hasOption(K_EXTERNAL_FILE_INFOS)) {
            properties.setProperty(K_EXTERNAL_FILE_INFOS, line.getOptionValue(K_EXTERNAL_FILE_INFOS));
        }
        if (line.hasOption(K_ADD_VIEW_RESULT_TREE_WITH_RECORD_FILE)) {
            properties.setProperty(K_ADD_VIEW_RESULT_TREE_WITH_RECORD_FILE, line.getOptionValue(K_ADD_VIEW_RESULT_TREE_WITH_RECORD_FILE));
        }
        if (line.hasOption(K_ADD_WEBSOCKET_WITH_PLUGIN_PETER_DOORNBOSH)) {
            properties.setProperty(K_ADD_WEBSOCKET_WITH_PLUGIN_PETER_DOORNBOSH, line.getOptionValue(K_ADD_WEBSOCKET_WITH_PLUGIN_PETER_DOORNBOSH));
        }
        return properties;
    }

    private static void helpUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String footer = "E.g : java -jar har-for-jmeter-<version>-jar-with-dependencies.jar -har_in myhar.har -jmx_out scriptout.jmx -record_out recording.xml -add_result_tree_record true -new_tc_pause 5000 -add_pause true -filter_include \"https://mysite/.*\" -filter_exclude \"https://notmysite/*\" -page_start_number 50 -sampler_start_number 250 -ws_with_pdoornbosch false \n";
        formatter.printHelp(120, HarForJMeter.class.getName(), HarForJMeter.class.getName(), options, footer, true);
    }
}

