/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter.har;

import de.sstoehr.harreader.model.Har;
import de.sstoehr.harreader.model.HarContent;
import de.sstoehr.harreader.model.HarCookie;
import de.sstoehr.harreader.model.HarEntry;
import de.sstoehr.harreader.model.HarHeader;
import de.sstoehr.harreader.model.HarPostData;
import de.sstoehr.harreader.model.HarPostDataParam;
import de.sstoehr.harreader.model.HarRequest;
import de.sstoehr.harreader.model.HarResponse;
import de.sstoehr.harreader.model.HarTiming;
import io.github.vdaburon.jmeter.har.HarForJMeter;
import io.github.vdaburon.jmeter.har.Utils;
import io.github.vdaburon.jmeter.har.websocket.WebSocketPDoornboshResultXml;
import io.github.vdaburon.jmeter.har.websocket.WebSocketRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Har2TestResultsXml {
    private static final Logger LOGGER = Logger.getLogger(Har2TestResultsXml.class.getName());

    protected Document convertHarToTestResultXml(Har har, String urlFilterToInclude, String urlFilterToExclude, int samplerStartNumber, WebSocketRequest webSocketRequest) throws ParserConfigurationException, URISyntaxException {
        Pattern patternUrlInclude = null;
        if (!urlFilterToInclude.isEmpty()) {
            patternUrlInclude = Pattern.compile(urlFilterToInclude);
        }
        Pattern patternUrlExclude = null;
        if (!urlFilterToExclude.isEmpty()) {
            patternUrlExclude = Pattern.compile(urlFilterToExclude);
        }
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element eltTestResults = this.createTestResults(har, document, patternUrlInclude, patternUrlExclude, samplerStartNumber, webSocketRequest);
        document.appendChild(eltTestResults);
        return document;
    }

    protected Element createTestResults(Har har, Document document, Pattern patternUrlInclude, Pattern patternUrlExclude, int samplerStartNumber, WebSocketRequest webSocketRequest) throws URISyntaxException {
        Element eltTestResults = document.createElement("testResults");
        Attr attrTrversion = document.createAttribute("version");
        attrTrversion.setValue("1.2");
        eltTestResults.setAttributeNode(attrTrversion);
        List<HarEntry> lEntries = har.getLog().getEntries();
        String currentUrl = "";
        int num = samplerStartNumber;
        for (int e = 0; e < lEntries.size(); ++e) {
            String sURl;
            URI uri;
            String scheme;
            String fromCache;
            HashMap hAddictional;
            Matcher matcher;
            HarEntry harEntryInter = lEntries.get(e);
            HarRequest harRequest = harEntryInter.getRequest();
            currentUrl = harRequest.getUrl();
            boolean isAddThisRequest = true;
            if (patternUrlInclude != null) {
                matcher = patternUrlInclude.matcher(currentUrl);
                isAddThisRequest = matcher.find();
            }
            if (patternUrlExclude != null) {
                matcher = patternUrlExclude.matcher(currentUrl);
                boolean bl = isAddThisRequest = !matcher.find();
            }
            if ((hAddictional = (HashMap)harEntryInter.getAdditional()) != null && (fromCache = (String)hAddictional.get("_fromCache")) != null) {
                isAddThisRequest = false;
            }
            if ("data".equalsIgnoreCase(scheme = (uri = new URI(sURl = harEntryInter.getRequest().getUrl())).getScheme())) {
                isAddThisRequest = false;
            }
            if ("ws".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme)) {
                if (isAddThisRequest && webSocketRequest != null) {
                    num = WebSocketPDoornboshResultXml.createWsSample(document, eltTestResults, harEntryInter, num, webSocketRequest);
                    num += 2;
                }
                isAddThisRequest = false;
            }
            if (!isAddThisRequest) continue;
            Element eltHttpSample = this.createHttpSample(document, harEntryInter, num);
            eltTestResults.appendChild(eltHttpSample);
            ++num;
        }
        LOGGER.info("testResuts file contains " + num + " httpSample or wsSample");
        return eltTestResults;
    }

    protected Element createHttpSample(Document document, HarEntry harEntry, int num) throws URISyntaxException {
        HarRequest harRequest = harEntry.getRequest();
        HarResponse harResponse = harEntry.getResponse();
        Element eltHttpSample = this.createEltHttpSample(document, harEntry, num);
        Element eltRequestponseHeaders = Har2TestResultsXml.createRequestHeaders(document, harEntry.getRequest());
        eltHttpSample.appendChild(eltRequestponseHeaders);
        Element eltResponseHeaders = Har2TestResultsXml.createResponseHeaders(document, harEntry.getResponse());
        eltHttpSample.appendChild(eltResponseHeaders);
        Element eltresponseFile = document.createElement("responseFile");
        eltresponseFile = Har2TestResultsXml.addAttributeToElement(document, eltresponseFile, "class", "java.lang.String");
        eltHttpSample.appendChild(eltresponseFile);
        Element eltcookies = Har2TestResultsXml.createCookies(document, harRequest);
        eltHttpSample.appendChild(eltcookies);
        Element eltmethod = document.createElement("method");
        eltmethod = Har2TestResultsXml.addAttributeToElement(document, eltmethod, "class", "java.lang.String");
        String method = harRequest.getMethod().name();
        eltmethod.setTextContent(method);
        eltHttpSample.appendChild(eltmethod);
        Element eltqueryString = document.createElement("queryString");
        eltqueryString = Har2TestResultsXml.addAttributeToElement(document, eltqueryString, "class", "java.lang.String");
        String queryString = "";
        if (!("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method) || harRequest.getQueryString().size() <= 0)) {
            queryString = new URI(harRequest.getUrl()).getQuery();
        } else if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method)) {
            queryString = this.createQueryStringForPostOrPutOrPatch(harRequest);
        }
        eltqueryString.setTextContent(queryString);
        eltHttpSample.appendChild(eltqueryString);
        String urlRedirect = harResponse.getRedirectURL();
        if (urlRedirect != null && !urlRedirect.isEmpty()) {
            Element eltredirectLocation = document.createElement("redirectLocation");
            eltqueryString = Har2TestResultsXml.addAttributeToElement(document, eltredirectLocation, "class", "java.lang.String");
            eltredirectLocation.setTextContent(urlRedirect);
            eltHttpSample.appendChild(eltredirectLocation);
        }
        Element eltJavaNetUrl = document.createElement("java.net.URL");
        eltJavaNetUrl.setTextContent(harRequest.getUrl());
        eltHttpSample.appendChild(eltJavaNetUrl);
        boolean isText = false;
        String dt_reponse = eltHttpSample.getAttribute("dt");
        if ("text".equalsIgnoreCase(dt_reponse)) {
            isText = true;
        }
        Element eltResponseData = Har2TestResultsXml.createEltReponseData(document, harResponse, isText);
        eltHttpSample.appendChild(eltResponseData);
        return eltHttpSample;
    }

    protected Element createEltHttpSample(Document document, HarEntry harEntry, int num) throws URISyntaxException {
        HarTiming harTimings = harEntry.getTimings();
        HarResponse harResponse = harEntry.getResponse();
        HarRequest harRequest = harEntry.getRequest();
        HarContent harContent = harResponse.getContent();
        String t_time = "" + harEntry.getTime();
        String it_time = "0";
        String lt_time = "" + harTimings.getWait();
        String ct_time = "" + harTimings.getConnect();
        String ts_time = "" + harEntry.getStartedDateTime().getTime();
        String s_response = "true";
        if (harResponse.getStatus() >= 400) {
            s_response = "false";
        }
        URI urlRequest = new URI(harRequest.getUrl());
        String lb_label = String.format("%03d " + urlRequest.getPath(), num);
        String rc_response = "" + harResponse.getStatus();
        String rm_response = harResponse.getStatusText();
        String urlPath = urlRequest.getPath();
        String dt_response = Har2TestResultsXml.textFromMimeType(harContent.getMimeType(), urlPath);
        String de_response = Har2TestResultsXml.responseEncoding(harResponse);
        String by_response = "" + harContent.getSize();
        String sby_request = "" + harRequest.getBodySize();
        String sc_count = "1";
        String ec_count = "0";
        String ng_count = "0";
        String na_count = "0";
        String hn = "browser";
        Element eltHttpSample = document.createElement("httpSample");
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "t", t_time);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "it", it_time);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "lt", lt_time);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "ct", ct_time);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "ts", ts_time);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "s", s_response);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "lb", lb_label);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "rc", rc_response);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "rm", rm_response);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "dt", dt_response);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "de", de_response);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "by", by_response);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "sby", sby_request);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "sc", sc_count);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "ec", ec_count);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "ng", ng_count);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "na", na_count);
        eltHttpSample = Har2TestResultsXml.addAttributeToElement(document, eltHttpSample, "hn", hn);
        return eltHttpSample;
    }

    public static Element addAttributeToElement(Document document, Element element, String attributeName, String attributeValue) {
        Attr attr = document.createAttribute(attributeName);
        attr.setValue(attributeValue);
        element.setAttributeNode(attr);
        return element;
    }

    protected Attr createAttribute(Document document, String attributeName, String attributeValue) {
        Attr attr = document.createAttribute(attributeName);
        attr.setValue(attributeValue);
        return attr;
    }

    public static Element createRequestHeaders(Document document, HarRequest harRequest) {
        Element eltRequestHeader = document.createElement("requestHeader");
        eltRequestHeader = Har2TestResultsXml.addAttributeToElement(document, eltRequestHeader, "class", "java.lang.String");
        List<HarHeader> lRequestHeaders = harRequest.getHeaders();
        StringBuffer sb = new StringBuffer(2048);
        for (int i = 0; i < lRequestHeaders.size(); ++i) {
            HarHeader harHeader = lRequestHeaders.get(i);
            sb.append(harHeader.getName());
            sb.append(": ");
            sb.append(harHeader.getValue());
            sb.append("\n");
        }
        eltRequestHeader.setTextContent(sb.toString());
        return eltRequestHeader;
    }

    public static Element createResponseHeaders(Document document, HarResponse harResponse) {
        Element eltResponseHeader = document.createElement("responseHeader");
        eltResponseHeader = Har2TestResultsXml.addAttributeToElement(document, eltResponseHeader, "class", "java.lang.String");
        List<HarHeader> lResponseHeaders = harResponse.getHeaders();
        StringBuffer sb = new StringBuffer(2048);
        for (int i = 0; i < lResponseHeaders.size(); ++i) {
            HarHeader harHeader = lResponseHeaders.get(i);
            sb.append(harHeader.getName());
            sb.append(": ");
            sb.append(harHeader.getValue());
            sb.append("\n");
        }
        eltResponseHeader.setTextContent(sb.toString());
        return eltResponseHeader;
    }

    public static Element createCookies(Document document, HarRequest harRequest) {
        Element eltcookies = document.createElement("cookies");
        eltcookies = Har2TestResultsXml.addAttributeToElement(document, eltcookies, "class", "java.lang.String");
        List<HarCookie> lCookies = harRequest.getCookies();
        StringBuffer sb = new StringBuffer(2048);
        for (int i = 0; i < lCookies.size(); ++i) {
            if (i > 0) {
                sb.append("; ");
            }
            HarCookie cookie = lCookies.get(i);
            sb.append(cookie.getName());
            sb.append("=");
            sb.append(cookie.getValue());
        }
        eltcookies.setTextContent(sb.toString());
        return eltcookies;
    }

    public static Element createEltReponseData(Document document, HarResponse harResponse, boolean isText) {
        Element eltresponseData = document.createElement("responseData");
        eltresponseData = Har2TestResultsXml.addAttributeToElement(document, eltresponseData, "class", "java.lang.String");
        HarContent harContent = harResponse.getContent();
        if (harContent != null) {
            String contentText = harContent.getText();
            String contentEncoding = harContent.getEncoding();
            if (contentText != null && "base64".equalsIgnoreCase(contentEncoding) && isText) {
                byte[] contentDecodeByte = Base64.getDecoder().decode(contentText.getBytes());
                String contentDecodeString = new String(contentDecodeByte);
                eltresponseData.setTextContent(contentDecodeString);
            }
            if (contentText != null && contentEncoding == null && isText) {
                eltresponseData.setTextContent(contentText);
            }
        }
        return eltresponseData;
    }

    protected String createQueryStringForPostOrPutOrPatch(HarRequest harRequest) {
        StringBuffer sb = new StringBuffer(2048);
        HarPostData postData = harRequest.getPostData();
        String mimeType = postData.getMimeType();
        String mimeTypeExtract = Utils.extractMimeType(mimeType);
        boolean isParamAdd = false;
        if ("application/x-www-form-urlencoded".equalsIgnoreCase(mimeTypeExtract)) {
            List<HarPostDataParam> lDataParams = postData.getParams();
            for (int i = 0; i < lDataParams.size(); ++i) {
                if (i > 0) {
                    sb.append("&");
                }
                HarPostDataParam dataParamInter = lDataParams.get(i);
                String name = dataParamInter.getName();
                String value = dataParamInter.getValue();
                sb.append(name);
                sb.append("=");
                sb.append(value);
            }
            isParamAdd = true;
        }
        if (!isParamAdd && mimeTypeExtract != null && mimeTypeExtract.contains("multipart/form-data")) {
            HarPostData postDataFormData = HarForJMeter.extractParamsFromMultiPart(harRequest);
            String boundary = StringUtils.substringAfter(mimeType, "boundary=");
            LOGGER.fine("boundary=<" + boundary + ">");
            List<HarPostDataParam> listParams = postDataFormData.getParams();
            StringBuffer sbFormData = new StringBuffer(1024);
            for (int j = 0; j < listParams.size(); ++j) {
                HarPostDataParam harPostDataParamInter = listParams.get(j);
                String fileName = harPostDataParamInter.getFileName();
                String contentType = harPostDataParamInter.getContentType();
                String nameParam = harPostDataParamInter.getName();
                String valueParam = harPostDataParamInter.getValue();
                sbFormData.append(boundary + "\n");
                sbFormData.append("Content-Disposition: form-data; name=\"");
                sbFormData.append(nameParam + "\"");
                if (fileName != null) {
                    sbFormData.append("; filename=\"" + fileName + "\"\n");
                    sbFormData.append("Content-Type: " + contentType + "\n");
                    sbFormData.append("\n\n");
                    sbFormData.append("<actual file content, not shown here>");
                    sbFormData.append("\n");
                    continue;
                }
                sbFormData.append("\n\n");
                sbFormData.append(valueParam);
                sbFormData.append("\n");
            }
            sb.append(sbFormData);
            isParamAdd = true;
        }
        if (!isParamAdd) {
            sb.append(postData.getText());
            isParamAdd = true;
        }
        return sb.toString();
    }

    public static boolean isTextFromMimeType(String mimeType) {
        boolean isText = false;
        String mimeTypeInter = mimeType;
        String partBeforeSemiColum = StringUtils.substringBefore(mimeType, ";");
        if (partBeforeSemiColum != null) {
            mimeTypeInter = partBeforeSemiColum;
        }
        String type = StringUtils.substringBefore(mimeTypeInter, "/");
        String subType = StringUtils.substringAfter(mimeTypeInter, "/");
        if (subType == null || type.isEmpty()) {
            return false;
        }
        if ("text".equalsIgnoreCase(type)) {
            isText = true;
        }
        if (subType.contains("-xml") || subType.contains("+xml") || subType.contains("-json") || subType.contains("+json")) {
            isText = true;
        }
        if (subType.contains("gzip") || subType.contains("zip") || subType.contains("compressed") || subType.equalsIgnoreCase("octet-stream")) {
            isText = false;
        }
        switch (subType) {
            case "css": 
            case "html": 
            case "csv": 
            case "richtext": 
            case "x-www-form-urlencoded": 
            case "javascript": 
            case "x-javascript": 
            case "json": 
            case "xml": 
            case "xhtml": 
            case "xhtml+xml": 
            case "atom+xml": 
            case "postscript": 
            case "base64": 
            case "problem+json": {
                isText = true;
            }
        }
        return isText;
    }

    public static String textFromMimeType(String mimeType, String urlPath) {
        String extension;
        String sText = "text";
        if (!Har2TestResultsXml.isTextFromMimeType(mimeType)) {
            sText = "bin";
        }
        if ("text".equals(sText) && urlPath != null && urlPath.contains(".") && (extension = urlPath.substring(urlPath.lastIndexOf(".") + 1)) != null && !extension.isEmpty()) {
            switch (extension = extension.toLowerCase()) {
                case "bmp": 
                case "gif": 
                case "ico": 
                case "jpg": 
                case "jpeg": 
                case "png": 
                case "swf": 
                case "eot": 
                case "otf": 
                case "ttf": 
                case "mp3": 
                case "mp4": 
                case "avi": 
                case "mkv": 
                case "wav": 
                case "woff": 
                case "woff2": 
                case "docx": 
                case "doc": 
                case "odt": 
                case "pptx": 
                case "xlsx": 
                case "xls": 
                case "vsdx": {
                    sText = "bin";
                }
            }
        }
        return sText;
    }

    public static String responseEncoding(HarResponse harResponse) {
        List<HarHeader> lResponseHeaders = harResponse.getHeaders();
        String encoding = "UTF-8";
        for (int i = 0; i < lResponseHeaders.size(); ++i) {
            HarHeader harHeader = lResponseHeaders.get(i);
            String name = harHeader.getName();
            String value = harHeader.getValue();
            if (!"Content-Type".equalsIgnoreCase(name) || value == null) continue;
            String charset = StringUtils.substringAfter(value, "charset=");
            if (charset == null) break;
            encoding = charset;
            break;
        }
        return encoding;
    }
}

