/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.sstoehr.harreader.AbstractHarIO;
import de.sstoehr.harreader.HarWriterException;
import de.sstoehr.harreader.jackson.MapperFactory;
import de.sstoehr.harreader.model.Har;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class HarWriter
extends AbstractHarIO {
    public HarWriter() {
    }

    public HarWriter(MapperFactory mapperFactory) {
        super(mapperFactory);
    }

    public byte[] writeAsBytes(Har har) throws HarWriterException {
        return this.wrap(m -> m.writeValueAsBytes(har));
    }

    public void writeTo(Writer writer, Har har) throws HarWriterException {
        this.wrap(m -> {
            m.writeValue(writer, (Object)har);
            return null;
        });
    }

    public void writeTo(OutputStream os, Har har) throws HarWriterException {
        this.wrap(m -> {
            m.writeValue(os, (Object)har);
            return null;
        });
    }

    public void writeTo(File file, Har har) throws HarWriterException {
        this.wrap(m -> {
            m.writeValue(file, (Object)har);
            return null;
        });
    }

    private <T> T wrap(IOFunction<ObjectMapper, T> consumer) throws HarWriterException {
        ObjectMapper mapper = this.getMapperFactory().instance();
        try {
            return consumer.apply(mapper);
        }
        catch (IOException thrown) {
            throw new HarWriterException(thrown);
        }
    }

    @FunctionalInterface
    private static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

