/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.text;

public class Characters {
    public static int find(char c, CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        for (int i = n; i < n2; ++i) {
            if (charSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int findLineBreak(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        for (int i = n; i < n2; ++i) {
            switch (charSequence.charAt(i)) {
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    public static boolean isBlank(CharSequence charSequence) {
        return Characters.skipSpaceTab(charSequence, 0, charSequence.length()) == charSequence.length();
    }

    public static boolean hasNonSpace(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = Characters.skip(' ', charSequence, 0, n);
        return n2 != n;
    }

    public static boolean isLetter(CharSequence charSequence, int n) {
        int n2 = Character.codePointAt(charSequence, n);
        return Character.isLetter(n2);
    }

    public static boolean isSpaceOrTab(CharSequence charSequence, int n) {
        if (n < charSequence.length()) {
            switch (charSequence.charAt(n)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPunctuationCodePoint(int n) {
        switch (Character.getType(n)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        switch (n) {
            case 36: 
            case 43: 
            case 60: 
            case 61: 
            case 62: 
            case 94: 
            case 96: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespaceCodePoint(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return Character.getType(n) == 12;
    }

    public static int skip(char c, CharSequence charSequence, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (charSequence.charAt(i) == c) continue;
            return i;
        }
        return n2;
    }

    public static int skipBackwards(char c, CharSequence charSequence, int n, int n2) {
        for (int i = n; i >= n2; --i) {
            if (charSequence.charAt(i) == c) continue;
            return i;
        }
        return n2 - 1;
    }

    public static int skipSpaceTab(CharSequence charSequence, int n, int n2) {
        block3: for (int i = n; i < n2; ++i) {
            switch (charSequence.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return n2;
    }

    public static int skipSpaceTabBackwards(CharSequence charSequence, int n, int n2) {
        block3: for (int i = n; i >= n2; --i) {
            switch (charSequence.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return n2 - 1;
    }
}

