/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.text;

import java.util.BitSet;
import java.util.Set;
import org.commonmark.text.CharMatcher;

public class AsciiMatcher
implements CharMatcher {
    private final BitSet set;

    private AsciiMatcher(Builder builder) {
        this.set = builder.set;
    }

    @Override
    public boolean matches(char c) {
        return this.set.get(c);
    }

    public Builder newBuilder() {
        return new Builder((BitSet)this.set.clone());
    }

    public static Builder builder() {
        return new Builder(new BitSet());
    }

    public static Builder builder(AsciiMatcher asciiMatcher) {
        return new Builder((BitSet)asciiMatcher.set.clone());
    }

    public static class Builder {
        private final BitSet set;

        private Builder(BitSet bitSet) {
            this.set = bitSet;
        }

        public Builder c(char c) {
            if (c > '\u007f') {
                throw new IllegalArgumentException("Can only match ASCII characters");
            }
            this.set.set(c);
            return this;
        }

        public Builder anyOf(String string) {
            for (int i = 0; i < string.length(); ++i) {
                this.c(string.charAt(i));
            }
            return this;
        }

        public Builder anyOf(Set<Character> set) {
            for (Character c : set) {
                this.c(c.charValue());
            }
            return this;
        }

        public Builder range(char c, char c2) {
            for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
                this.c(c3);
            }
            return this;
        }

        public AsciiMatcher build() {
            return new AsciiMatcher(this);
        }
    }
}

