/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.text;

import java.util.Set;
import org.commonmark.internal.renderer.text.BulletListHolder;
import org.commonmark.internal.renderer.text.ListHolder;
import org.commonmark.internal.renderer.text.OrderedListHolder;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.text.LineBreakRendering;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentWriter;

public class CoreTextContentNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    protected final TextContentNodeRendererContext context;
    private final TextContentWriter textContent;
    private ListHolder listHolder;

    public CoreTextContentNodeRenderer(TextContentNodeRendererContext textContentNodeRendererContext) {
        this.context = textContentNodeRendererContext;
        this.textContent = textContentNodeRendererContext.getWriter();
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return Set.of(Document.class, Heading.class, Paragraph.class, BlockQuote.class, BulletList.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, IndentedCodeBlock.class, Link.class, ListItem.class, OrderedList.class, Image.class, Emphasis.class, StrongEmphasis.class, Text.class, Code.class, HtmlInline.class, SoftLineBreak.class, HardLineBreak.class);
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Document document) {
        this.visitChildren(document);
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.textContent.write('\u00ab');
        this.visitChildren(blockQuote);
        this.textContent.resetBlock();
        this.textContent.write('\u00bb');
        this.textContent.block();
    }

    @Override
    public void visit(BulletList bulletList) {
        this.textContent.pushTight(bulletList.isTight());
        this.listHolder = new BulletListHolder(this.listHolder, bulletList);
        this.visitChildren(bulletList);
        this.textContent.popTight();
        this.textContent.block();
        this.listHolder = this.listHolder.getParent();
    }

    @Override
    public void visit(Code code) {
        this.textContent.write('\"');
        this.textContent.write(code.getLiteral());
        this.textContent.write('\"');
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        String string = CoreTextContentNodeRenderer.stripTrailingNewline(fencedCodeBlock.getLiteral());
        if (this.stripNewlines()) {
            this.textContent.writeStripped(string);
        } else {
            this.textContent.write(string);
        }
        this.textContent.block();
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        if (this.stripNewlines()) {
            this.textContent.whitespace();
        } else {
            this.textContent.line();
        }
    }

    @Override
    public void visit(Heading heading) {
        this.visitChildren(heading);
        if (this.stripNewlines()) {
            this.textContent.write(": ");
        } else {
            this.textContent.block();
        }
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        if (!this.stripNewlines()) {
            this.textContent.write("***");
        }
        this.textContent.block();
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        this.writeText(htmlInline.getLiteral());
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        this.writeText(htmlBlock.getLiteral());
    }

    @Override
    public void visit(Image image) {
        this.writeLink(image, image.getTitle(), image.getDestination());
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        String string = CoreTextContentNodeRenderer.stripTrailingNewline(indentedCodeBlock.getLiteral());
        if (this.stripNewlines()) {
            this.textContent.writeStripped(string);
        } else {
            this.textContent.write(string);
        }
        this.textContent.block();
    }

    @Override
    public void visit(Link link) {
        this.writeLink(link, link.getTitle(), link.getDestination());
    }

    @Override
    public void visit(ListItem listItem) {
        if (this.listHolder != null && this.listHolder instanceof OrderedListHolder) {
            OrderedListHolder orderedListHolder = (OrderedListHolder)this.listHolder;
            String string = this.stripNewlines() ? "" : orderedListHolder.getIndent();
            this.textContent.write(string + orderedListHolder.getCounter() + orderedListHolder.getDelimiter() + " ");
            this.visitChildren(listItem);
            this.textContent.block();
            orderedListHolder.increaseCounter();
        } else if (this.listHolder != null && this.listHolder instanceof BulletListHolder) {
            BulletListHolder bulletListHolder = (BulletListHolder)this.listHolder;
            if (!this.stripNewlines()) {
                this.textContent.write(bulletListHolder.getIndent() + bulletListHolder.getMarker() + " ");
            }
            this.visitChildren(listItem);
            this.textContent.block();
        }
    }

    @Override
    public void visit(OrderedList orderedList) {
        this.textContent.pushTight(orderedList.isTight());
        this.listHolder = new OrderedListHolder(this.listHolder, orderedList);
        this.visitChildren(orderedList);
        this.textContent.popTight();
        this.textContent.block();
        this.listHolder = this.listHolder.getParent();
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.visitChildren(paragraph);
        this.textContent.block();
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        if (this.stripNewlines()) {
            this.textContent.whitespace();
        } else {
            this.textContent.line();
        }
    }

    @Override
    public void visit(Text text) {
        this.writeText(text.getLiteral());
    }

    @Override
    protected void visitChildren(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            this.context.render(node2);
            node2 = node3;
        }
    }

    private void writeText(String string) {
        if (this.stripNewlines()) {
            this.textContent.writeStripped(string);
        } else {
            this.textContent.write(string);
        }
    }

    private void writeLink(Node node, String string, String string2) {
        boolean bl;
        boolean bl2 = node.getFirstChild() != null;
        boolean bl3 = string != null && !string.equals(string2);
        boolean bl4 = bl = string2 != null && !string2.equals("");
        if (bl2) {
            this.textContent.write('\"');
            this.visitChildren(node);
            this.textContent.write('\"');
            if (bl3 || bl) {
                this.textContent.whitespace();
                this.textContent.write('(');
            }
        }
        if (bl3) {
            this.textContent.write(string);
            if (bl) {
                this.textContent.colon();
                this.textContent.whitespace();
            }
        }
        if (bl) {
            this.textContent.write(string2);
        }
        if (bl2 && (bl3 || bl)) {
            this.textContent.write(')');
        }
    }

    private boolean stripNewlines() {
        return this.context.lineBreakRendering() == LineBreakRendering.STRIP;
    }

    private static String stripTrailingNewline(String string) {
        if (string.endsWith("\n")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

