/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.markdown;

import java.io.IOException;
import java.util.LinkedList;
import org.commonmark.text.CharMatcher;

public class MarkdownWriter {
    private final Appendable buffer;
    private int blockSeparator = 0;
    private char lastChar;
    private boolean atLineStart = true;
    private final LinkedList<String> prefixes = new LinkedList();
    private final LinkedList<Boolean> tight = new LinkedList();
    private final LinkedList<CharMatcher> rawEscapes = new LinkedList();

    public MarkdownWriter(Appendable appendable) {
        this.buffer = appendable;
    }

    public void raw(String string) {
        this.flushBlockSeparator();
        this.write(string, null);
    }

    public void raw(char c) {
        this.flushBlockSeparator();
        this.write(c);
    }

    public void text(String string, CharMatcher charMatcher) {
        if (string.isEmpty()) {
            return;
        }
        this.flushBlockSeparator();
        this.write(string, charMatcher);
        this.lastChar = string.charAt(string.length() - 1);
        this.atLineStart = false;
    }

    public void line() {
        this.write('\n');
        this.writePrefixes();
        this.atLineStart = true;
    }

    public void block() {
        this.blockSeparator = this.isTight() ? 1 : 2;
        this.atLineStart = true;
    }

    public void pushPrefix(String string) {
        this.prefixes.addLast(string);
    }

    public void writePrefix(String string) {
        boolean bl = this.atLineStart;
        this.raw(string);
        this.atLineStart = bl;
    }

    public void popPrefix() {
        this.prefixes.removeLast();
    }

    public void pushTight(boolean bl) {
        this.tight.addLast(bl);
    }

    public void popTight() {
        this.tight.removeLast();
    }

    public void pushRawEscape(CharMatcher charMatcher) {
        this.rawEscapes.add(charMatcher);
    }

    public void popRawEscape() {
        this.rawEscapes.removeLast();
    }

    public char getLastChar() {
        return this.lastChar;
    }

    public boolean isAtLineStart() {
        return this.atLineStart;
    }

    private void write(String string, CharMatcher charMatcher) {
        int n;
        try {
            if (this.rawEscapes.isEmpty() && charMatcher == null) {
                this.buffer.append(string);
            } else {
                for (n = 0; n < string.length(); ++n) {
                    this.append(string.charAt(n), charMatcher);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if ((n = string.length()) != 0) {
            this.lastChar = string.charAt(n - 1);
        }
        this.atLineStart = false;
    }

    private void write(char c) {
        try {
            this.append(c, null);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.lastChar = c;
        this.atLineStart = false;
    }

    private void writePrefixes() {
        if (!this.prefixes.isEmpty()) {
            for (String string : this.prefixes) {
                this.write(string, null);
            }
        }
    }

    private void flushBlockSeparator() {
        if (this.blockSeparator != 0) {
            this.write('\n');
            this.writePrefixes();
            if (this.blockSeparator > 1) {
                this.write('\n');
                this.writePrefixes();
            }
            this.blockSeparator = 0;
        }
    }

    private void append(char c, CharMatcher charMatcher) {
        if (this.needsEscaping(c, charMatcher)) {
            if (c == '\n') {
                this.buffer.append("&#10;");
            } else {
                this.buffer.append('\\');
                this.buffer.append(c);
            }
        } else {
            this.buffer.append(c);
        }
    }

    private boolean isTight() {
        return !this.tight.isEmpty() && this.tight.getLast() != false;
    }

    private boolean needsEscaping(char c, CharMatcher charMatcher) {
        return charMatcher != null && charMatcher.matches(c) || this.rawNeedsEscaping(c);
    }

    private boolean rawNeedsEscaping(char c) {
        for (CharMatcher charMatcher : this.rawEscapes) {
            if (!charMatcher.matches(c)) continue;
            return true;
        }
        return false;
    }
}

