/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.markdown;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.internal.renderer.NodeRendererMap;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.Renderer;
import org.commonmark.renderer.markdown.CoreMarkdownNodeRenderer;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownNodeRendererFactory;
import org.commonmark.renderer.markdown.MarkdownWriter;

public class MarkdownRenderer
implements Renderer {
    private final List<MarkdownNodeRendererFactory> nodeRendererFactories;

    private MarkdownRenderer(Builder builder) {
        this.nodeRendererFactories = new ArrayList<MarkdownNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(new MarkdownNodeRendererFactory(){

            @Override
            public NodeRenderer create(MarkdownNodeRendererContext markdownNodeRendererContext) {
                return new CoreMarkdownNodeRenderer(markdownNodeRendererContext);
            }

            @Override
            public Set<Character> getSpecialCharacters() {
                return Set.of();
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(Node node, Appendable appendable) {
        RendererContext rendererContext = new RendererContext(new MarkdownWriter(appendable));
        rendererContext.render(node);
    }

    @Override
    public String render(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        this.render(node, stringBuilder);
        return stringBuilder.toString();
    }

    public static class Builder {
        private final List<MarkdownNodeRendererFactory> nodeRendererFactories = new ArrayList<MarkdownNodeRendererFactory>();

        public MarkdownRenderer build() {
            return new MarkdownRenderer(this);
        }

        public Builder nodeRendererFactory(MarkdownNodeRendererFactory markdownNodeRendererFactory) {
            this.nodeRendererFactories.add(markdownNodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> iterable) {
            for (Extension extension : iterable) {
                if (!(extension instanceof MarkdownRendererExtension)) continue;
                MarkdownRendererExtension markdownRendererExtension = (MarkdownRendererExtension)extension;
                markdownRendererExtension.extend(this);
            }
            return this;
        }
    }

    private class RendererContext
    implements MarkdownNodeRendererContext {
        private final MarkdownWriter writer;
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();
        private final Set<Character> additionalTextEscapes;

        private RendererContext(MarkdownWriter markdownWriter) {
            this.writer = markdownWriter;
            HashSet<Character> hashSet = new HashSet<Character>();
            for (MarkdownNodeRendererFactory markdownNodeRendererFactory : MarkdownRenderer.this.nodeRendererFactories) {
                hashSet.addAll(markdownNodeRendererFactory.getSpecialCharacters());
            }
            this.additionalTextEscapes = Collections.unmodifiableSet(hashSet);
            for (MarkdownNodeRendererFactory markdownNodeRendererFactory : MarkdownRenderer.this.nodeRendererFactories) {
                NodeRenderer nodeRenderer = markdownNodeRendererFactory.create(this);
                this.nodeRendererMap.add(nodeRenderer);
            }
        }

        @Override
        public MarkdownWriter getWriter() {
            return this.writer;
        }

        @Override
        public void render(Node node) {
            this.nodeRendererMap.render(node);
        }

        @Override
        public Set<Character> getSpecialCharacters() {
            return this.additionalTextEscapes;
        }
    }

    public static interface MarkdownRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }
}

