/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.markdown;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownWriter;
import org.commonmark.text.AsciiMatcher;
import org.commonmark.text.CharMatcher;
import org.commonmark.text.Characters;

public class CoreMarkdownNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    private final AsciiMatcher textEscape;
    private final CharMatcher textEscapeInHeading;
    private final CharMatcher linkDestinationNeedsAngleBrackets = AsciiMatcher.builder().c(' ').c('(').c(')').c('<').c('>').c('\n').c('\\').build();
    private final CharMatcher linkDestinationEscapeInAngleBrackets = AsciiMatcher.builder().c('<').c('>').c('\n').c('\\').build();
    private final CharMatcher linkTitleEscapeInQuotes = AsciiMatcher.builder().c('\"').c('\n').c('\\').build();
    private final Pattern orderedListMarkerPattern = Pattern.compile("^([0-9]{1,9})([.)])");
    protected final MarkdownNodeRendererContext context;
    private final MarkdownWriter writer;
    private ListHolder listHolder;

    public CoreMarkdownNodeRenderer(MarkdownNodeRendererContext markdownNodeRendererContext) {
        this.context = markdownNodeRendererContext;
        this.writer = markdownNodeRendererContext.getWriter();
        this.textEscape = AsciiMatcher.builder().anyOf("[]<>`*_&\n\\").anyOf(markdownNodeRendererContext.getSpecialCharacters()).build();
        this.textEscapeInHeading = AsciiMatcher.builder(this.textEscape).anyOf("#").build();
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return Set.of(BlockQuote.class, BulletList.class, Code.class, Document.class, Emphasis.class, FencedCodeBlock.class, HardLineBreak.class, Heading.class, HtmlBlock.class, HtmlInline.class, Image.class, IndentedCodeBlock.class, Link.class, ListItem.class, OrderedList.class, Paragraph.class, SoftLineBreak.class, StrongEmphasis.class, Text.class, ThematicBreak.class);
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Document document) {
        this.visitChildren(document);
        this.writer.line();
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        String string = thematicBreak.getLiteral();
        if (string == null) {
            string = "___";
        }
        this.writer.raw(string);
        this.writer.block();
    }

    @Override
    public void visit(Heading heading) {
        if (heading.getLevel() <= 2) {
            LineBreakVisitor lineBreakVisitor = new LineBreakVisitor();
            heading.accept(lineBreakVisitor);
            boolean bl = lineBreakVisitor.hasLineBreak();
            if (bl) {
                this.visitChildren(heading);
                this.writer.line();
                if (heading.getLevel() == 1) {
                    this.writer.raw("===");
                } else {
                    this.writer.raw("---");
                }
                this.writer.block();
                return;
            }
        }
        for (int i = 0; i < heading.getLevel(); ++i) {
            this.writer.raw('#');
        }
        this.writer.raw(' ');
        this.visitChildren(heading);
        this.writer.block();
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        String string = indentedCodeBlock.getLiteral();
        this.writer.writePrefix("    ");
        this.writer.pushPrefix("    ");
        List<String> list = CoreMarkdownNodeRenderer.getLines(string);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            this.writer.raw(string2);
            if (i == list.size() - 1) continue;
            this.writer.line();
        }
        this.writer.popPrefix();
        this.writer.block();
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        Object object;
        int n;
        int n2;
        String string;
        String string2 = fencedCodeBlock.getLiteral();
        String string3 = string = fencedCodeBlock.getFenceCharacter() != null ? fencedCodeBlock.getFenceCharacter() : "`";
        if (fencedCodeBlock.getOpeningFenceLength() != null) {
            n2 = fencedCodeBlock.getOpeningFenceLength();
        } else {
            n = CoreMarkdownNodeRenderer.findMaxRunLength(string, string2);
            n2 = Math.max(n + 1, 3);
        }
        n = fencedCodeBlock.getClosingFenceLength() != null ? fencedCodeBlock.getClosingFenceLength() : n2;
        String string4 = CoreMarkdownNodeRenderer.repeat(string, n2);
        String string5 = CoreMarkdownNodeRenderer.repeat(string, n);
        int n3 = fencedCodeBlock.getFenceIndent();
        if (n3 > 0) {
            object = CoreMarkdownNodeRenderer.repeat(" ", n3);
            this.writer.writePrefix((String)object);
            this.writer.pushPrefix((String)object);
        }
        this.writer.raw(string4);
        if (fencedCodeBlock.getInfo() != null) {
            this.writer.raw(fencedCodeBlock.getInfo());
        }
        this.writer.line();
        if (!string2.isEmpty()) {
            object = CoreMarkdownNodeRenderer.getLines(string2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string6 = (String)iterator.next();
                this.writer.raw(string6);
                this.writer.line();
            }
        }
        this.writer.raw(string5);
        if (n3 > 0) {
            this.writer.popPrefix();
        }
        this.writer.block();
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        List<String> list = CoreMarkdownNodeRenderer.getLines(htmlBlock.getLiteral());
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            this.writer.raw(string);
            if (i == list.size() - 1) continue;
            this.writer.line();
        }
        this.writer.block();
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.visitChildren(paragraph);
        this.writer.block();
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.writer.writePrefix("> ");
        this.writer.pushPrefix("> ");
        this.visitChildren(blockQuote);
        this.writer.popPrefix();
        this.writer.block();
    }

    @Override
    public void visit(BulletList bulletList) {
        this.writer.pushTight(bulletList.isTight());
        this.listHolder = new BulletListHolder(this.listHolder, bulletList);
        this.visitChildren(bulletList);
        this.listHolder = this.listHolder.parent;
        this.writer.popTight();
        this.writer.block();
    }

    @Override
    public void visit(OrderedList orderedList) {
        this.writer.pushTight(orderedList.isTight());
        this.listHolder = new OrderedListHolder(this.listHolder, orderedList);
        this.visitChildren(orderedList);
        this.listHolder = this.listHolder.parent;
        this.writer.popTight();
        this.writer.block();
    }

    @Override
    public void visit(ListItem listItem) {
        String string;
        Object object;
        int n;
        int n2 = n = listItem.getMarkerIndent() != null ? listItem.getMarkerIndent() : 0;
        if (this.listHolder instanceof BulletListHolder) {
            object = (BulletListHolder)this.listHolder;
            string = CoreMarkdownNodeRenderer.repeat(" ", n) + ((BulletListHolder)object).marker;
        } else if (this.listHolder instanceof OrderedListHolder) {
            object = (OrderedListHolder)this.listHolder;
            string = CoreMarkdownNodeRenderer.repeat(" ", n) + ((OrderedListHolder)object).number + ((OrderedListHolder)object).delimiter;
            ++((OrderedListHolder)object).number;
        } else {
            throw new IllegalStateException("Unknown list holder type: " + this.listHolder);
        }
        object = listItem.getContentIndent();
        String string2 = object != null ? CoreMarkdownNodeRenderer.repeat(" ", Math.max((Integer)object - string.length(), 1)) : " ";
        this.writer.writePrefix(string);
        this.writer.writePrefix(string2);
        this.writer.pushPrefix(CoreMarkdownNodeRenderer.repeat(" ", string.length() + string2.length()));
        if (listItem.getFirstChild() == null) {
            this.writer.block();
        } else {
            this.visitChildren(listItem);
        }
        this.writer.popPrefix();
    }

    @Override
    public void visit(Code code) {
        int n;
        String string = code.getLiteral();
        int n2 = CoreMarkdownNodeRenderer.findMaxRunLength("`", string);
        for (n = 0; n < n2 + 1; ++n) {
            this.writer.raw('`');
        }
        int n3 = n = string.startsWith("`") || string.endsWith("`") || string.startsWith(" ") && string.endsWith(" ") && Characters.hasNonSpace(string) ? 1 : 0;
        if (n != 0) {
            this.writer.raw(' ');
        }
        this.writer.raw(string);
        if (n != 0) {
            this.writer.raw(' ');
        }
        for (int i = 0; i < n2 + 1; ++i) {
            this.writer.raw('`');
        }
    }

    @Override
    public void visit(Emphasis emphasis) {
        String string = emphasis.getOpeningDelimiter();
        if (string == null) {
            string = this.writer.getLastChar() == '*' ? "_" : "*";
        }
        this.writer.raw(string);
        super.visit(emphasis);
        this.writer.raw(string);
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.writer.raw("**");
        super.visit(strongEmphasis);
        this.writer.raw("**");
    }

    @Override
    public void visit(Link link) {
        this.writeLinkLike(link.getTitle(), link.getDestination(), link, "[");
    }

    @Override
    public void visit(Image image) {
        this.writeLinkLike(image.getTitle(), image.getDestination(), image, "![");
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        this.writer.raw(htmlInline.getLiteral());
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.writer.raw("  ");
        this.writer.line();
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.writer.line();
    }

    @Override
    public void visit(Text text) {
        CharMatcher charMatcher;
        String string = text.getLiteral();
        if (this.writer.isAtLineStart() && !string.isEmpty()) {
            char c = string.charAt(0);
            switch (c) {
                case '-': {
                    this.writer.raw("\\-");
                    string = string.substring(1);
                    break;
                }
                case '#': {
                    this.writer.raw("\\#");
                    string = string.substring(1);
                    break;
                }
                case '=': {
                    if (text.getPrevious() == null) break;
                    this.writer.raw("\\=");
                    string = string.substring(1);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Matcher matcher = this.orderedListMarkerPattern.matcher(string);
                    if (!matcher.find()) break;
                    this.writer.raw(matcher.group(1));
                    this.writer.raw("\\" + matcher.group(2));
                    string = string.substring(matcher.end());
                    break;
                }
                case '\t': {
                    this.writer.raw("&#9;");
                    string = string.substring(1);
                    break;
                }
                case ' ': {
                    this.writer.raw("&#32;");
                    string = string.substring(1);
                }
            }
        }
        CharMatcher charMatcher2 = charMatcher = text.getParent() instanceof Heading ? this.textEscapeInHeading : this.textEscape;
        if (string.endsWith("!") && text.getNext() instanceof Link) {
            this.writer.text(string.substring(0, string.length() - 1), charMatcher);
            this.writer.raw("\\!");
        } else {
            this.writer.text(string, charMatcher);
        }
    }

    @Override
    protected void visitChildren(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            this.context.render(node2);
            node2 = node3;
        }
    }

    private static int findMaxRunLength(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while (n2 < string2.length()) {
            if ((n2 = string2.indexOf(string, n2)) == -1) {
                return n;
            }
            int n3 = 0;
            do {
                ++n3;
            } while (string2.startsWith(string, n2 += string.length()));
            n = Math.max(n3, n);
        }
        return n;
    }

    private static boolean contains(String string, CharMatcher charMatcher) {
        for (int i = 0; i < string.length(); ++i) {
            if (!charMatcher.matches(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static List<String> getLines(String string) {
        String[] stringArray = string.split("\n", -1);
        if (stringArray[stringArray.length - 1].isEmpty()) {
            return List.of(stringArray).subList(0, stringArray.length - 1);
        }
        return List.of(stringArray);
    }

    private void writeLinkLike(String string, String string2, Node node, String string3) {
        this.writer.raw(string3);
        this.visitChildren(node);
        this.writer.raw(']');
        this.writer.raw('(');
        if (CoreMarkdownNodeRenderer.contains(string2, this.linkDestinationNeedsAngleBrackets)) {
            this.writer.raw('<');
            this.writer.text(string2, this.linkDestinationEscapeInAngleBrackets);
            this.writer.raw('>');
        } else {
            this.writer.raw(string2);
        }
        if (string != null) {
            this.writer.raw(' ');
            this.writer.raw('\"');
            this.writer.text(string, this.linkTitleEscapeInQuotes);
            this.writer.raw('\"');
        }
        this.writer.raw(')');
    }

    private static class LineBreakVisitor
    extends AbstractVisitor {
        private boolean lineBreak = false;

        private LineBreakVisitor() {
        }

        public boolean hasLineBreak() {
            return this.lineBreak;
        }

        @Override
        public void visit(SoftLineBreak softLineBreak) {
            super.visit(softLineBreak);
            this.lineBreak = true;
        }

        @Override
        public void visit(HardLineBreak hardLineBreak) {
            super.visit(hardLineBreak);
            this.lineBreak = true;
        }
    }

    private static class BulletListHolder
    extends ListHolder {
        final String marker;

        public BulletListHolder(ListHolder listHolder, BulletList bulletList) {
            super(listHolder);
            this.marker = bulletList.getMarker() != null ? bulletList.getMarker() : "-";
        }
    }

    private static class ListHolder {
        final ListHolder parent;

        protected ListHolder(ListHolder listHolder) {
            this.parent = listHolder;
        }
    }

    private static class OrderedListHolder
    extends ListHolder {
        final String delimiter;
        private int number;

        protected OrderedListHolder(ListHolder listHolder, OrderedList orderedList) {
            super(listHolder);
            this.delimiter = orderedList.getMarkerDelimiter() != null ? orderedList.getMarkerDelimiter() : ".";
            this.number = orderedList.getMarkerStartNumber() != null ? orderedList.getMarkerStartNumber() : 1;
        }
    }
}

