/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.html;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.commonmark.internal.util.Escaping;

public class HtmlWriter {
    private static final Map<String, String> NO_ATTRIBUTES = Map.of();
    private final Appendable buffer;
    private char lastChar = '\u0000';

    public HtmlWriter(Appendable appendable) {
        Objects.requireNonNull(appendable, "out must not be null");
        this.buffer = appendable;
    }

    public void raw(String string) {
        this.append(string);
    }

    public void text(String string) {
        this.append(Escaping.escapeHtml(string));
    }

    public void tag(String string) {
        this.tag(string, NO_ATTRIBUTES);
    }

    public void tag(String string, Map<String, String> map) {
        this.tag(string, map, false);
    }

    public void tag(String string, Map<String, String> map, boolean bl) {
        this.append("<");
        this.append(string);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.append(" ");
                this.append(Escaping.escapeHtml(entry.getKey()));
                if (entry.getValue() == null) continue;
                this.append("=\"");
                this.append(Escaping.escapeHtml(entry.getValue()));
                this.append("\"");
            }
        }
        if (bl) {
            this.append(" /");
        }
        this.append(">");
    }

    public void line() {
        if (this.lastChar != '\u0000' && this.lastChar != '\n') {
            this.append("\n");
        }
    }

    protected void append(String string) {
        try {
            this.buffer.append(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int n = string.length();
        if (n != 0) {
            this.lastChar = string.charAt(n - 1);
        }
    }
}

