/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.html;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.commonmark.Extension;
import org.commonmark.internal.renderer.NodeRendererMap;
import org.commonmark.internal.util.Escaping;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.Renderer;
import org.commonmark.renderer.html.AttributeProvider;
import org.commonmark.renderer.html.AttributeProviderContext;
import org.commonmark.renderer.html.AttributeProviderFactory;
import org.commonmark.renderer.html.CoreHtmlNodeRenderer;
import org.commonmark.renderer.html.DefaultUrlSanitizer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlWriter;
import org.commonmark.renderer.html.UrlSanitizer;

public class HtmlRenderer
implements Renderer {
    private final String softbreak;
    private final boolean escapeHtml;
    private final boolean percentEncodeUrls;
    private final boolean omitSingleParagraphP;
    private final boolean sanitizeUrls;
    private final UrlSanitizer urlSanitizer;
    private final List<AttributeProviderFactory> attributeProviderFactories;
    private final List<HtmlNodeRendererFactory> nodeRendererFactories;

    private HtmlRenderer(Builder builder) {
        this.softbreak = builder.softbreak;
        this.escapeHtml = builder.escapeHtml;
        this.percentEncodeUrls = builder.percentEncodeUrls;
        this.omitSingleParagraphP = builder.omitSingleParagraphP;
        this.sanitizeUrls = builder.sanitizeUrls;
        this.urlSanitizer = builder.urlSanitizer;
        this.attributeProviderFactories = new ArrayList<AttributeProviderFactory>(builder.attributeProviderFactories);
        this.nodeRendererFactories = new ArrayList<HtmlNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(new HtmlNodeRendererFactory(){

            @Override
            public NodeRenderer create(HtmlNodeRendererContext htmlNodeRendererContext) {
                return new CoreHtmlNodeRenderer(htmlNodeRendererContext);
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(Node node, Appendable appendable) {
        Objects.requireNonNull(node, "node must not be null");
        RendererContext rendererContext = new RendererContext(new HtmlWriter(appendable));
        rendererContext.beforeRoot(node);
        rendererContext.render(node);
        rendererContext.afterRoot(node);
    }

    @Override
    public String render(Node node) {
        Objects.requireNonNull(node, "node must not be null");
        StringBuilder stringBuilder = new StringBuilder();
        this.render(node, stringBuilder);
        return stringBuilder.toString();
    }

    public static class Builder {
        private String softbreak = "\n";
        private boolean escapeHtml = false;
        private boolean sanitizeUrls = false;
        private UrlSanitizer urlSanitizer = new DefaultUrlSanitizer();
        private boolean percentEncodeUrls = false;
        private boolean omitSingleParagraphP = false;
        private List<AttributeProviderFactory> attributeProviderFactories = new ArrayList<AttributeProviderFactory>();
        private List<HtmlNodeRendererFactory> nodeRendererFactories = new ArrayList<HtmlNodeRendererFactory>();

        public HtmlRenderer build() {
            return new HtmlRenderer(this);
        }

        public Builder softbreak(String string) {
            this.softbreak = string;
            return this;
        }

        public Builder escapeHtml(boolean bl) {
            this.escapeHtml = bl;
            return this;
        }

        public Builder sanitizeUrls(boolean bl) {
            this.sanitizeUrls = bl;
            return this;
        }

        public Builder urlSanitizer(UrlSanitizer urlSanitizer) {
            this.urlSanitizer = urlSanitizer;
            return this;
        }

        public Builder percentEncodeUrls(boolean bl) {
            this.percentEncodeUrls = bl;
            return this;
        }

        public Builder omitSingleParagraphP(boolean bl) {
            this.omitSingleParagraphP = bl;
            return this;
        }

        public Builder attributeProviderFactory(AttributeProviderFactory attributeProviderFactory) {
            Objects.requireNonNull(attributeProviderFactory, "attributeProviderFactory must not be null");
            this.attributeProviderFactories.add(attributeProviderFactory);
            return this;
        }

        public Builder nodeRendererFactory(HtmlNodeRendererFactory htmlNodeRendererFactory) {
            Objects.requireNonNull(htmlNodeRendererFactory, "nodeRendererFactory must not be null");
            this.nodeRendererFactories.add(htmlNodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> iterable) {
            Objects.requireNonNull(iterable, "extensions must not be null");
            for (Extension extension : iterable) {
                if (!(extension instanceof HtmlRendererExtension)) continue;
                HtmlRendererExtension htmlRendererExtension = (HtmlRendererExtension)extension;
                htmlRendererExtension.extend(this);
            }
            return this;
        }
    }

    private class RendererContext
    implements AttributeProviderContext,
    HtmlNodeRendererContext {
        private final HtmlWriter htmlWriter;
        private final List<AttributeProvider> attributeProviders;
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();

        private RendererContext(HtmlWriter htmlWriter) {
            this.htmlWriter = htmlWriter;
            this.attributeProviders = new ArrayList<AttributeProvider>(HtmlRenderer.this.attributeProviderFactories.size());
            for (AttributeProviderFactory object : HtmlRenderer.this.attributeProviderFactories) {
                this.attributeProviders.add(object.create(this));
            }
            for (HtmlNodeRendererFactory htmlNodeRendererFactory : HtmlRenderer.this.nodeRendererFactories) {
                NodeRenderer nodeRenderer = htmlNodeRendererFactory.create(this);
                this.nodeRendererMap.add(nodeRenderer);
            }
        }

        @Override
        public boolean shouldEscapeHtml() {
            return HtmlRenderer.this.escapeHtml;
        }

        @Override
        public boolean shouldOmitSingleParagraphP() {
            return HtmlRenderer.this.omitSingleParagraphP;
        }

        @Override
        public boolean shouldSanitizeUrls() {
            return HtmlRenderer.this.sanitizeUrls;
        }

        @Override
        public UrlSanitizer urlSanitizer() {
            return HtmlRenderer.this.urlSanitizer;
        }

        @Override
        public String encodeUrl(String string) {
            if (HtmlRenderer.this.percentEncodeUrls) {
                return Escaping.percentEncodeUrl(string);
            }
            return string;
        }

        @Override
        public Map<String, String> extendAttributes(Node node, String string, Map<String, String> map) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(map);
            this.setCustomAttributes(node, string, linkedHashMap);
            return linkedHashMap;
        }

        @Override
        public HtmlWriter getWriter() {
            return this.htmlWriter;
        }

        @Override
        public String getSoftbreak() {
            return HtmlRenderer.this.softbreak;
        }

        @Override
        public void render(Node node) {
            this.nodeRendererMap.render(node);
        }

        public void beforeRoot(Node node) {
            this.nodeRendererMap.beforeRoot(node);
        }

        public void afterRoot(Node node) {
            this.nodeRendererMap.afterRoot(node);
        }

        private void setCustomAttributes(Node node, String string, Map<String, String> map) {
            for (AttributeProvider attributeProvider : this.attributeProviders) {
                attributeProvider.setAttributes(node, string, map);
            }
        }
    }

    public static interface HtmlRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }
}

