/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.html;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.commonmark.renderer.html.UrlSanitizer;

public class DefaultUrlSanitizer
implements UrlSanitizer {
    private Set<String> protocols;

    public DefaultUrlSanitizer() {
        this(List.of("http", "https", "mailto", "data"));
    }

    public DefaultUrlSanitizer(Collection<String> collection) {
        this.protocols = new HashSet<String>(collection);
    }

    @Override
    public String sanitizeLinkUrl(String string) {
        string = this.stripHtmlSpaces(string);
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    break block4;
                }
                case ':': {
                    String string2 = string.substring(0, i).toLowerCase();
                    if (this.protocols.contains(string2)) break block4;
                    return "";
                }
                default: {
                    continue block4;
                }
            }
        }
        return string;
    }

    @Override
    public String sanitizeImageUrl(String string) {
        return this.sanitizeLinkUrl(string);
    }

    private String stripHtmlSpaces(String string) {
        int n;
        int n2 = 0;
        for (n = string.length(); n > n2 && this.isHtmlSpace(string.charAt(n - 1)); --n) {
        }
        while (n2 < n && this.isHtmlSpace(string.charAt(n2))) {
            ++n2;
        }
        if (n2 == 0 && n == string.length()) {
            return string;
        }
        return string.substring(n2, n);
    }

    private boolean isHtmlSpace(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

