/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.html;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;

public class CoreHtmlNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    protected final HtmlNodeRendererContext context;
    private final HtmlWriter html;

    public CoreHtmlNodeRenderer(HtmlNodeRendererContext htmlNodeRendererContext) {
        this.context = htmlNodeRendererContext;
        this.html = htmlNodeRendererContext.getWriter();
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return Set.of(Document.class, Heading.class, Paragraph.class, BlockQuote.class, BulletList.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, IndentedCodeBlock.class, Link.class, ListItem.class, OrderedList.class, Image.class, Emphasis.class, StrongEmphasis.class, Text.class, Code.class, HtmlInline.class, SoftLineBreak.class, HardLineBreak.class);
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Document document) {
        this.visitChildren(document);
    }

    @Override
    public void visit(Heading heading) {
        String string = "h" + heading.getLevel();
        this.html.line();
        this.html.tag(string, this.getAttrs(heading, string));
        this.visitChildren(heading);
        this.html.tag("/" + string);
        this.html.line();
    }

    @Override
    public void visit(Paragraph paragraph) {
        boolean bl;
        boolean bl2 = bl = this.isInTightList(paragraph) || this.context.shouldOmitSingleParagraphP() && paragraph.getParent() instanceof Document && paragraph.getPrevious() == null && paragraph.getNext() == null;
        if (!bl) {
            this.html.line();
            this.html.tag("p", this.getAttrs(paragraph, "p"));
        }
        this.visitChildren(paragraph);
        if (!bl) {
            this.html.tag("/p");
            this.html.line();
        }
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.html.line();
        this.html.tag("blockquote", this.getAttrs(blockQuote, "blockquote"));
        this.html.line();
        this.visitChildren(blockQuote);
        this.html.line();
        this.html.tag("/blockquote");
        this.html.line();
    }

    @Override
    public void visit(BulletList bulletList) {
        this.renderListBlock(bulletList, "ul", this.getAttrs(bulletList, "ul"));
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        String string = fencedCodeBlock.getLiteral();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String string2 = fencedCodeBlock.getInfo();
        if (string2 != null && !string2.isEmpty()) {
            int n = string2.indexOf(" ");
            String string3 = n == -1 ? string2 : string2.substring(0, n);
            linkedHashMap.put("class", "language-" + string3);
        }
        this.renderCodeBlock(string, fencedCodeBlock, linkedHashMap);
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        this.html.line();
        if (this.context.shouldEscapeHtml()) {
            this.html.tag("p", this.getAttrs(htmlBlock, "p"));
            this.html.text(htmlBlock.getLiteral());
            this.html.tag("/p");
        } else {
            this.html.raw(htmlBlock.getLiteral());
        }
        this.html.line();
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        this.html.line();
        this.html.tag("hr", this.getAttrs(thematicBreak, "hr"), true);
        this.html.line();
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.renderCodeBlock(indentedCodeBlock.getLiteral(), indentedCodeBlock, Map.of());
    }

    @Override
    public void visit(Link link) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String string = link.getDestination();
        if (this.context.shouldSanitizeUrls()) {
            string = this.context.urlSanitizer().sanitizeLinkUrl(string);
            linkedHashMap.put("rel", "nofollow");
        }
        string = this.context.encodeUrl(string);
        linkedHashMap.put("href", string);
        if (link.getTitle() != null) {
            linkedHashMap.put("title", link.getTitle());
        }
        this.html.tag("a", this.getAttrs(link, "a", linkedHashMap));
        this.visitChildren(link);
        this.html.tag("/a");
    }

    @Override
    public void visit(ListItem listItem) {
        this.html.tag("li", this.getAttrs(listItem, "li"));
        this.visitChildren(listItem);
        this.html.tag("/li");
        this.html.line();
    }

    @Override
    public void visit(OrderedList orderedList) {
        int n = orderedList.getMarkerStartNumber() != null ? orderedList.getMarkerStartNumber() : 1;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (n != 1) {
            linkedHashMap.put("start", String.valueOf(n));
        }
        this.renderListBlock(orderedList, "ol", this.getAttrs(orderedList, "ol", linkedHashMap));
    }

    @Override
    public void visit(Image image) {
        String string = image.getDestination();
        AltTextVisitor altTextVisitor = new AltTextVisitor();
        image.accept(altTextVisitor);
        String string2 = altTextVisitor.getAltText();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.context.shouldSanitizeUrls()) {
            string = this.context.urlSanitizer().sanitizeImageUrl(string);
        }
        linkedHashMap.put("src", this.context.encodeUrl(string));
        linkedHashMap.put("alt", string2);
        if (image.getTitle() != null) {
            linkedHashMap.put("title", image.getTitle());
        }
        this.html.tag("img", this.getAttrs(image, "img", linkedHashMap), true);
    }

    @Override
    public void visit(Emphasis emphasis) {
        this.html.tag("em", this.getAttrs(emphasis, "em"));
        this.visitChildren(emphasis);
        this.html.tag("/em");
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.html.tag("strong", this.getAttrs(strongEmphasis, "strong"));
        this.visitChildren(strongEmphasis);
        this.html.tag("/strong");
    }

    @Override
    public void visit(Text text) {
        this.html.text(text.getLiteral());
    }

    @Override
    public void visit(Code code) {
        this.html.tag("code", this.getAttrs(code, "code"));
        this.html.text(code.getLiteral());
        this.html.tag("/code");
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        if (this.context.shouldEscapeHtml()) {
            this.html.text(htmlInline.getLiteral());
        } else {
            this.html.raw(htmlInline.getLiteral());
        }
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.html.raw(this.context.getSoftbreak());
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.html.tag("br", this.getAttrs(hardLineBreak, "br"), true);
        this.html.line();
    }

    @Override
    protected void visitChildren(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            this.context.render(node2);
            node2 = node3;
        }
    }

    private void renderCodeBlock(String string, Node node, Map<String, String> map) {
        this.html.line();
        this.html.tag("pre", this.getAttrs(node, "pre"));
        this.html.tag("code", this.getAttrs(node, "code", map));
        this.html.text(string);
        this.html.tag("/code");
        this.html.tag("/pre");
        this.html.line();
    }

    private void renderListBlock(ListBlock listBlock, String string, Map<String, String> map) {
        this.html.line();
        this.html.tag(string, map);
        this.html.line();
        this.visitChildren(listBlock);
        this.html.line();
        this.html.tag("/" + string);
        this.html.line();
    }

    private boolean isInTightList(Paragraph paragraph) {
        Node node;
        Block block = paragraph.getParent();
        if (block != null && (node = ((Node)block).getParent()) instanceof ListBlock) {
            ListBlock listBlock = (ListBlock)node;
            return listBlock.isTight();
        }
        return false;
    }

    private Map<String, String> getAttrs(Node node, String string) {
        return this.getAttrs(node, string, Map.of());
    }

    private Map<String, String> getAttrs(Node node, String string, Map<String, String> map) {
        return this.context.extendAttributes(node, string, map);
    }

    private static class AltTextVisitor
    extends AbstractVisitor {
        private final StringBuilder sb = new StringBuilder();

        private AltTextVisitor() {
        }

        String getAltText() {
            return this.sb.toString();
        }

        @Override
        public void visit(Text text) {
            this.sb.append(text.getLiteral());
        }

        @Override
        public void visit(SoftLineBreak softLineBreak) {
            this.sb.append('\n');
        }

        @Override
        public void visit(HardLineBreak hardLineBreak) {
            this.sb.append('\n');
        }
    }
}

