/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.parser.beta;

import java.util.List;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.beta.Position;
import org.commonmark.text.CharMatcher;

public class Scanner {
    public static final char END = '\u0000';
    private final List<SourceLine> lines;
    private int lineIndex;
    private int index;
    private SourceLine line = SourceLine.of("", null);
    private int lineLength = 0;

    Scanner(List<SourceLine> list, int n, int n2) {
        this.lines = list;
        this.lineIndex = n;
        this.index = n2;
        if (!list.isEmpty()) {
            this.checkPosition(n, n2);
            this.setLine(list.get(n));
        }
    }

    public static Scanner of(SourceLines sourceLines) {
        return new Scanner(sourceLines.getLines(), 0, 0);
    }

    public char peek() {
        if (this.index < this.lineLength) {
            return this.line.getContent().charAt(this.index);
        }
        if (this.lineIndex < this.lines.size() - 1) {
            return '\n';
        }
        return '\u0000';
    }

    public int peekCodePoint() {
        if (this.index < this.lineLength) {
            char c;
            char c2 = this.line.getContent().charAt(this.index);
            if (Character.isHighSurrogate(c2) && this.index + 1 < this.lineLength && Character.isLowSurrogate(c = this.line.getContent().charAt(this.index + 1))) {
                return Character.toCodePoint(c2, c);
            }
            return c2;
        }
        if (this.lineIndex < this.lines.size() - 1) {
            return 10;
        }
        return 0;
    }

    public int peekPreviousCodePoint() {
        if (this.index > 0) {
            char c;
            int n = this.index - 1;
            char c2 = this.line.getContent().charAt(n);
            if (Character.isLowSurrogate(c2) && n > 0 && Character.isHighSurrogate(c = this.line.getContent().charAt(n - 1))) {
                return Character.toCodePoint(c, c2);
            }
            return c2;
        }
        if (this.lineIndex > 0) {
            return 10;
        }
        return 0;
    }

    public boolean hasNext() {
        if (this.index < this.lineLength) {
            return true;
        }
        return this.lineIndex < this.lines.size() - 1;
    }

    public void next() {
        ++this.index;
        if (this.index > this.lineLength) {
            ++this.lineIndex;
            if (this.lineIndex < this.lines.size()) {
                this.setLine(this.lines.get(this.lineIndex));
            } else {
                this.setLine(SourceLine.of("", null));
            }
            this.index = 0;
        }
    }

    public boolean next(char c) {
        if (this.peek() == c) {
            this.next();
            return true;
        }
        return false;
    }

    public boolean next(String string) {
        if (this.index < this.lineLength && this.index + string.length() <= this.lineLength) {
            for (int i = 0; i < string.length(); ++i) {
                if (this.line.getContent().charAt(this.index + i) == string.charAt(i)) continue;
                return false;
            }
            this.index += string.length();
            return true;
        }
        return false;
    }

    public int matchMultiple(char c) {
        int n = 0;
        while (this.peek() == c) {
            ++n;
            this.next();
        }
        return n;
    }

    public int match(CharMatcher charMatcher) {
        int n = 0;
        while (charMatcher.matches(this.peek())) {
            ++n;
            this.next();
        }
        return n;
    }

    public int whitespace() {
        int n = 0;
        block3: while (true) {
            switch (this.peek()) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++n;
                    this.next();
                    continue block3;
                }
            }
            break;
        }
        return n;
    }

    public int find(char c) {
        int n = 0;
        char c2;
        while ((c2 = this.peek()) != '\u0000') {
            if (c2 == c) {
                return n;
            }
            ++n;
            this.next();
        }
        return -1;
    }

    public int find(CharMatcher charMatcher) {
        int n = 0;
        char c;
        while ((c = this.peek()) != '\u0000') {
            if (charMatcher.matches(c)) {
                return n;
            }
            ++n;
            this.next();
        }
        return -1;
    }

    public Position position() {
        return new Position(this.lineIndex, this.index);
    }

    public void setPosition(Position position) {
        this.checkPosition(position.lineIndex, position.index);
        this.lineIndex = position.lineIndex;
        this.index = position.index;
        this.setLine(this.lines.get(this.lineIndex));
    }

    public SourceLines getSource(Position position, Position position2) {
        if (position.lineIndex == position2.lineIndex) {
            SourceLine sourceLine = this.lines.get(position.lineIndex);
            CharSequence charSequence = sourceLine.getContent().subSequence(position.index, position2.index);
            SourceSpan sourceSpan = null;
            SourceSpan sourceSpan2 = sourceLine.getSourceSpan();
            if (sourceSpan2 != null) {
                sourceSpan = sourceSpan2.subSpan(position.index, position2.index);
            }
            return SourceLines.of(SourceLine.of(charSequence, sourceSpan));
        }
        SourceLines sourceLines = SourceLines.empty();
        SourceLine sourceLine = this.lines.get(position.lineIndex);
        sourceLines.addLine(sourceLine.substring(position.index, sourceLine.getContent().length()));
        for (int i = position.lineIndex + 1; i < position2.lineIndex; ++i) {
            sourceLines.addLine(this.lines.get(i));
        }
        SourceLine sourceLine2 = this.lines.get(position2.lineIndex);
        sourceLines.addLine(sourceLine2.substring(0, position2.index));
        return sourceLines;
    }

    private void setLine(SourceLine sourceLine) {
        this.line = sourceLine;
        this.lineLength = sourceLine.getContent().length();
    }

    private void checkPosition(int n, int n2) {
        if (n < 0 || n >= this.lines.size()) {
            throw new IllegalArgumentException("Line index " + n + " out of range, number of lines: " + this.lines.size());
        }
        SourceLine sourceLine = this.lines.get(n);
        if (n2 < 0 || n2 > sourceLine.getContent().length()) {
            throw new IllegalArgumentException("Index " + n2 + " out of range, line length: " + sourceLine.getContent().length());
        }
    }
}

