/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.parser;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.SourceLine;

public class SourceLines {
    private final List<SourceLine> lines = new ArrayList<SourceLine>();

    public static SourceLines empty() {
        return new SourceLines();
    }

    public static SourceLines of(SourceLine sourceLine) {
        SourceLines sourceLines = new SourceLines();
        sourceLines.addLine(sourceLine);
        return sourceLines;
    }

    public static SourceLines of(List<SourceLine> list) {
        SourceLines sourceLines = new SourceLines();
        sourceLines.lines.addAll(list);
        return sourceLines;
    }

    public void addLine(SourceLine sourceLine) {
        this.lines.add(sourceLine);
    }

    public List<SourceLine> getLines() {
        return this.lines;
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public String getContent() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            if (i != 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(this.lines.get(i).getContent());
        }
        return stringBuilder.toString();
    }

    public List<SourceSpan> getSourceSpans() {
        ArrayList<SourceSpan> arrayList = new ArrayList<SourceSpan>();
        for (SourceLine sourceLine : this.lines) {
            SourceSpan sourceSpan = sourceLine.getSourceSpan();
            if (sourceSpan == null) continue;
            arrayList.add(sourceSpan);
        }
        return arrayList;
    }
}

