/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.parser;

import java.util.Objects;
import org.commonmark.node.SourceSpan;

public class SourceLine {
    private final CharSequence content;
    private final SourceSpan sourceSpan;

    public static SourceLine of(CharSequence charSequence, SourceSpan sourceSpan) {
        return new SourceLine(charSequence, sourceSpan);
    }

    private SourceLine(CharSequence charSequence, SourceSpan sourceSpan) {
        this.content = Objects.requireNonNull(charSequence, "content must not be null");
        this.sourceSpan = sourceSpan;
    }

    public CharSequence getContent() {
        return this.content;
    }

    public SourceSpan getSourceSpan() {
        return this.sourceSpan;
    }

    public SourceLine substring(int n, int n2) {
        int n3;
        CharSequence charSequence = this.content.subSequence(n, n2);
        SourceSpan sourceSpan = null;
        if (this.sourceSpan != null && (n3 = n2 - n) != 0) {
            int n4 = this.sourceSpan.getColumnIndex() + n;
            int n5 = this.sourceSpan.getInputIndex() + n;
            sourceSpan = SourceSpan.of(this.sourceSpan.getLineIndex(), n4, n5, n3);
        }
        return SourceLine.of(charSequence, sourceSpan);
    }
}

