/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.internal.Definitions;
import org.commonmark.internal.DocumentParser;
import org.commonmark.internal.InlineParserContextImpl;
import org.commonmark.internal.InlineParserImpl;
import org.commonmark.node.Block;
import org.commonmark.node.Document;
import org.commonmark.node.Node;
import org.commonmark.parser.IncludeSourceSpans;
import org.commonmark.parser.InlineParserFactory;
import org.commonmark.parser.PostProcessor;
import org.commonmark.parser.beta.InlineContentParserFactory;
import org.commonmark.parser.beta.LinkProcessor;
import org.commonmark.parser.block.BlockParserFactory;
import org.commonmark.parser.delimiter.DelimiterProcessor;

public class Parser {
    private final List<BlockParserFactory> blockParserFactories;
    private final List<InlineContentParserFactory> inlineContentParserFactories;
    private final List<DelimiterProcessor> delimiterProcessors;
    private final List<LinkProcessor> linkProcessors;
    private final Set<Character> linkMarkers;
    private final InlineParserFactory inlineParserFactory;
    private final List<PostProcessor> postProcessors;
    private final IncludeSourceSpans includeSourceSpans;

    private Parser(Builder builder) {
        this.blockParserFactories = DocumentParser.calculateBlockParserFactories(builder.blockParserFactories, builder.enabledBlockTypes);
        this.inlineParserFactory = builder.getInlineParserFactory();
        this.postProcessors = builder.postProcessors;
        this.inlineContentParserFactories = builder.inlineContentParserFactories;
        this.delimiterProcessors = builder.delimiterProcessors;
        this.linkProcessors = builder.linkProcessors;
        this.linkMarkers = builder.linkMarkers;
        this.includeSourceSpans = builder.includeSourceSpans;
        InlineParserContextImpl inlineParserContextImpl = new InlineParserContextImpl(this.inlineContentParserFactories, this.delimiterProcessors, this.linkProcessors, this.linkMarkers, new Definitions());
        this.inlineParserFactory.create(inlineParserContextImpl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Node parse(String string) {
        Objects.requireNonNull(string, "input must not be null");
        DocumentParser documentParser = this.createDocumentParser();
        Document document = documentParser.parse(string);
        return this.postProcess(document);
    }

    public Node parseReader(Reader reader) {
        Objects.requireNonNull(reader, "input must not be null");
        DocumentParser documentParser = this.createDocumentParser();
        Document document = documentParser.parse(reader);
        return this.postProcess(document);
    }

    private DocumentParser createDocumentParser() {
        return new DocumentParser(this.blockParserFactories, this.inlineParserFactory, this.inlineContentParserFactories, this.delimiterProcessors, this.linkProcessors, this.linkMarkers, this.includeSourceSpans);
    }

    private Node postProcess(Node node) {
        for (PostProcessor postProcessor : this.postProcessors) {
            node = postProcessor.process(node);
        }
        return node;
    }

    public static class Builder {
        private final List<BlockParserFactory> blockParserFactories = new ArrayList<BlockParserFactory>();
        private final List<InlineContentParserFactory> inlineContentParserFactories = new ArrayList<InlineContentParserFactory>();
        private final List<DelimiterProcessor> delimiterProcessors = new ArrayList<DelimiterProcessor>();
        private final List<LinkProcessor> linkProcessors = new ArrayList<LinkProcessor>();
        private final List<PostProcessor> postProcessors = new ArrayList<PostProcessor>();
        private final Set<Character> linkMarkers = new HashSet<Character>();
        private Set<Class<? extends Block>> enabledBlockTypes = DocumentParser.getDefaultBlockParserTypes();
        private InlineParserFactory inlineParserFactory;
        private IncludeSourceSpans includeSourceSpans = IncludeSourceSpans.NONE;

        public Parser build() {
            return new Parser(this);
        }

        public Builder extensions(Iterable<? extends Extension> iterable) {
            Objects.requireNonNull(iterable, "extensions must not be null");
            for (Extension extension : iterable) {
                if (!(extension instanceof ParserExtension)) continue;
                ParserExtension parserExtension = (ParserExtension)extension;
                parserExtension.extend(this);
            }
            return this;
        }

        public Builder enabledBlockTypes(Set<Class<? extends Block>> set) {
            Objects.requireNonNull(set, "enabledBlockTypes must not be null");
            DocumentParser.checkEnabledBlockTypes(set);
            this.enabledBlockTypes = set;
            return this;
        }

        public Builder includeSourceSpans(IncludeSourceSpans includeSourceSpans) {
            this.includeSourceSpans = includeSourceSpans;
            return this;
        }

        public Builder customBlockParserFactory(BlockParserFactory blockParserFactory) {
            Objects.requireNonNull(blockParserFactory, "blockParserFactory must not be null");
            this.blockParserFactories.add(blockParserFactory);
            return this;
        }

        public Builder customInlineContentParserFactory(InlineContentParserFactory inlineContentParserFactory) {
            Objects.requireNonNull(inlineContentParserFactory, "inlineContentParser must not be null");
            this.inlineContentParserFactories.add(inlineContentParserFactory);
            return this;
        }

        public Builder customDelimiterProcessor(DelimiterProcessor delimiterProcessor) {
            Objects.requireNonNull(delimiterProcessor, "delimiterProcessor must not be null");
            this.delimiterProcessors.add(delimiterProcessor);
            return this;
        }

        public Builder linkProcessor(LinkProcessor linkProcessor) {
            Objects.requireNonNull(linkProcessor, "linkProcessor must not be null");
            this.linkProcessors.add(linkProcessor);
            return this;
        }

        public Builder linkMarker(Character c) {
            Objects.requireNonNull(c, "linkMarker must not be null");
            this.linkMarkers.add(c);
            return this;
        }

        public Builder postProcessor(PostProcessor postProcessor) {
            Objects.requireNonNull(postProcessor, "postProcessor must not be null");
            this.postProcessors.add(postProcessor);
            return this;
        }

        public Builder inlineParserFactory(InlineParserFactory inlineParserFactory) {
            this.inlineParserFactory = inlineParserFactory;
            return this;
        }

        private InlineParserFactory getInlineParserFactory() {
            if (this.inlineParserFactory != null) {
                return this.inlineParserFactory;
            }
            return InlineParserImpl::new;
        }
    }

    public static interface ParserExtension
    extends Extension {
        public void extend(Builder var1);
    }
}

