/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.node;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.node.Node;
import org.commonmark.node.SourceSpan;

public class SourceSpans {
    private List<SourceSpan> sourceSpans;

    public static SourceSpans empty() {
        return new SourceSpans();
    }

    public List<SourceSpan> getSourceSpans() {
        return this.sourceSpans != null ? this.sourceSpans : List.of();
    }

    public void addAllFrom(Iterable<? extends Node> iterable) {
        for (Node node : iterable) {
            this.addAll(node.getSourceSpans());
        }
    }

    public void addAll(List<SourceSpan> list) {
        if (list.isEmpty()) {
            return;
        }
        if (this.sourceSpans == null) {
            this.sourceSpans = new ArrayList<SourceSpan>();
        }
        if (this.sourceSpans.isEmpty()) {
            this.sourceSpans.addAll(list);
        } else {
            int n = this.sourceSpans.size() - 1;
            SourceSpan sourceSpan = this.sourceSpans.get(n);
            SourceSpan sourceSpan2 = list.get(0);
            if (sourceSpan.getInputIndex() + sourceSpan.getLength() == sourceSpan2.getInputIndex()) {
                this.sourceSpans.set(n, SourceSpan.of(sourceSpan.getLineIndex(), sourceSpan.getColumnIndex(), sourceSpan.getInputIndex(), sourceSpan.getLength() + sourceSpan2.getLength()));
                this.sourceSpans.addAll(list.subList(1, list.size()));
            } else {
                this.sourceSpans.addAll(list);
            }
        }
    }
}

