/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.node;

import java.util.Objects;

public class SourceSpan {
    private final int lineIndex;
    private final int columnIndex;
    private final int inputIndex;
    private final int length;

    public static SourceSpan of(int n, int n2, int n3, int n4) {
        return new SourceSpan(n, n2, n3, n4);
    }

    @Deprecated
    public static SourceSpan of(int n, int n2, int n3) {
        return SourceSpan.of(n, n2, 0, n3);
    }

    private SourceSpan(int n, int n2, int n3, int n4) {
        if (n < 0) {
            throw new IllegalArgumentException("lineIndex " + n + " must be >= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("columnIndex " + n2 + " must be >= 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("inputIndex " + n3 + " must be >= 0");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("length " + n4 + " must be >= 0");
        }
        this.lineIndex = n;
        this.columnIndex = n2;
        this.inputIndex = n3;
        this.length = n4;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public int getLength() {
        return this.length;
    }

    public SourceSpan subSpan(int n) {
        return this.subSpan(n, this.length);
    }

    public SourceSpan subSpan(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginIndex " + n + " + must be >= 0");
        }
        if (n > this.length) {
            throw new IndexOutOfBoundsException("beginIndex " + n + " must be <= length " + this.length);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("endIndex " + n2 + " + must be >= 0");
        }
        if (n2 > this.length) {
            throw new IndexOutOfBoundsException("endIndex " + n2 + " must be <= length " + this.length);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("beginIndex " + n + " must be <= endIndex " + n2);
        }
        if (n == 0 && n2 == this.length) {
            return this;
        }
        return new SourceSpan(this.lineIndex, this.columnIndex + n, this.inputIndex + n, n2 - n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SourceSpan sourceSpan = (SourceSpan)object;
        return this.lineIndex == sourceSpan.lineIndex && this.columnIndex == sourceSpan.columnIndex && this.inputIndex == sourceSpan.inputIndex && this.length == sourceSpan.length;
    }

    public int hashCode() {
        return Objects.hash(this.lineIndex, this.columnIndex, this.inputIndex, this.length);
    }

    public String toString() {
        return "SourceSpan{line=" + this.lineIndex + ", column=" + this.columnIndex + ", input=" + this.inputIndex + ", length=" + this.length + "}";
    }
}

