/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.Visitor;

public abstract class Node {
    private Node parent = null;
    private Node firstChild = null;
    private Node lastChild = null;
    private Node prev = null;
    private Node next = null;
    private List<SourceSpan> sourceSpans = null;

    public abstract void accept(Visitor var1);

    public Node getNext() {
        return this.next;
    }

    public Node getPrevious() {
        return this.prev;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node node) {
        this.parent = node;
    }

    public void appendChild(Node node) {
        node.unlink();
        node.setParent(this);
        if (this.lastChild != null) {
            this.lastChild.next = node;
            node.prev = this.lastChild;
            this.lastChild = node;
        } else {
            this.firstChild = node;
            this.lastChild = node;
        }
    }

    public void prependChild(Node node) {
        node.unlink();
        node.setParent(this);
        if (this.firstChild != null) {
            this.firstChild.prev = node;
            node.next = this.firstChild;
            this.firstChild = node;
        } else {
            this.firstChild = node;
            this.lastChild = node;
        }
    }

    public void unlink() {
        if (this.prev != null) {
            this.prev.next = this.next;
        } else if (this.parent != null) {
            this.parent.firstChild = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        } else if (this.parent != null) {
            this.parent.lastChild = this.prev;
        }
        this.parent = null;
        this.next = null;
        this.prev = null;
    }

    public void insertAfter(Node node) {
        node.unlink();
        node.next = this.next;
        if (node.next != null) {
            node.next.prev = node;
        }
        node.prev = this;
        this.next = node;
        node.parent = this.parent;
        if (node.next == null) {
            node.parent.lastChild = node;
        }
    }

    public void insertBefore(Node node) {
        node.unlink();
        node.prev = this.prev;
        if (node.prev != null) {
            node.prev.next = node;
        }
        node.next = this;
        this.prev = node;
        node.parent = this.parent;
        if (node.prev == null) {
            node.parent.firstChild = node;
        }
    }

    public List<SourceSpan> getSourceSpans() {
        return this.sourceSpans != null ? Collections.unmodifiableList(this.sourceSpans) : List.of();
    }

    public void setSourceSpans(List<SourceSpan> list) {
        this.sourceSpans = list.isEmpty() ? null : new ArrayList<SourceSpan>(list);
    }

    public void addSourceSpan(SourceSpan sourceSpan) {
        if (this.sourceSpans == null) {
            this.sourceSpans = new ArrayList<SourceSpan>();
        }
        this.sourceSpans.add(sourceSpan);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringAttributes() + "}";
    }

    protected String toStringAttributes() {
        return "";
    }
}

