/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.node;

import org.commonmark.node.Block;
import org.commonmark.node.Visitor;

public class FencedCodeBlock
extends Block {
    private String fenceCharacter;
    private Integer openingFenceLength;
    private Integer closingFenceLength;
    private int fenceIndent;
    private String info;
    private String literal;

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String getFenceCharacter() {
        return this.fenceCharacter;
    }

    public void setFenceCharacter(String string) {
        this.fenceCharacter = string;
    }

    public Integer getOpeningFenceLength() {
        return this.openingFenceLength;
    }

    public void setOpeningFenceLength(Integer n) {
        if (n != null && n < 3) {
            throw new IllegalArgumentException("openingFenceLength needs to be >= 3");
        }
        FencedCodeBlock.checkFenceLengths(n, this.closingFenceLength);
        this.openingFenceLength = n;
    }

    public Integer getClosingFenceLength() {
        return this.closingFenceLength;
    }

    public void setClosingFenceLength(Integer n) {
        if (n != null && n < 3) {
            throw new IllegalArgumentException("closingFenceLength needs to be >= 3");
        }
        FencedCodeBlock.checkFenceLengths(this.openingFenceLength, n);
        this.closingFenceLength = n;
    }

    public int getFenceIndent() {
        return this.fenceIndent;
    }

    public void setFenceIndent(int n) {
        this.fenceIndent = n;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public String getLiteral() {
        return this.literal;
    }

    public void setLiteral(String string) {
        this.literal = string;
    }

    @Deprecated
    public char getFenceChar() {
        return this.fenceCharacter != null && !this.fenceCharacter.isEmpty() ? this.fenceCharacter.charAt(0) : (char)'\u0000';
    }

    @Deprecated
    public void setFenceChar(char c) {
        this.fenceCharacter = c != '\u0000' ? String.valueOf(c) : null;
    }

    @Deprecated
    public int getFenceLength() {
        return this.openingFenceLength != null ? this.openingFenceLength : 0;
    }

    @Deprecated
    public void setFenceLength(int n) {
        this.openingFenceLength = n != 0 ? Integer.valueOf(n) : null;
    }

    private static void checkFenceLengths(Integer n, Integer n2) {
        if (n != null && n2 != null && n2 < n) {
            throw new IllegalArgumentException("fence lengths required to be: closingFenceLength >= openingFenceLength");
        }
    }
}

