/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.util;

import org.commonmark.parser.beta.Scanner;

public class LinkScanner {
    public static boolean scanLinkLabelContent(Scanner scanner) {
        block5: while (scanner.hasNext()) {
            switch (scanner.peek()) {
                case '\\': {
                    scanner.next();
                    if (!LinkScanner.isEscapable(scanner.peek())) continue block5;
                    scanner.next();
                    continue block5;
                }
                case ']': {
                    return true;
                }
                case '[': {
                    return false;
                }
            }
            scanner.next();
        }
        return true;
    }

    public static boolean scanLinkDestination(Scanner scanner) {
        if (!scanner.hasNext()) {
            return false;
        }
        if (scanner.next('<')) {
            block5: while (scanner.hasNext()) {
                switch (scanner.peek()) {
                    case '\\': {
                        scanner.next();
                        if (!LinkScanner.isEscapable(scanner.peek())) continue block5;
                        scanner.next();
                        continue block5;
                    }
                    case '\n': 
                    case '<': {
                        return false;
                    }
                    case '>': {
                        scanner.next();
                        return true;
                    }
                }
                scanner.next();
            }
            return false;
        }
        return LinkScanner.scanLinkDestinationWithBalancedParens(scanner);
    }

    public static boolean scanLinkTitle(Scanner scanner) {
        char c;
        if (!scanner.hasNext()) {
            return false;
        }
        switch (scanner.peek()) {
            case '\"': {
                c = '\"';
                break;
            }
            case '\'': {
                c = '\'';
                break;
            }
            case '(': {
                c = ')';
                break;
            }
            default: {
                return false;
            }
        }
        scanner.next();
        if (!LinkScanner.scanLinkTitleContent(scanner, c)) {
            return false;
        }
        if (!scanner.hasNext()) {
            return false;
        }
        scanner.next();
        return true;
    }

    public static boolean scanLinkTitleContent(Scanner scanner, char c) {
        while (scanner.hasNext()) {
            char c2 = scanner.peek();
            if (c2 == '\\') {
                scanner.next();
                if (!LinkScanner.isEscapable(scanner.peek())) continue;
                scanner.next();
                continue;
            }
            if (c2 == c) {
                return true;
            }
            if (c == ')' && c2 == '(') {
                return false;
            }
            scanner.next();
        }
        return true;
    }

    private static boolean scanLinkDestinationWithBalancedParens(Scanner scanner) {
        int n = 0;
        boolean bl = true;
        while (scanner.hasNext()) {
            char c = scanner.peek();
            switch (c) {
                case ' ': {
                    return !bl;
                }
                case '\\': {
                    scanner.next();
                    if (!LinkScanner.isEscapable(scanner.peek())) break;
                    scanner.next();
                    break;
                }
                case '(': {
                    if (++n > 32) {
                        return false;
                    }
                    scanner.next();
                    break;
                }
                case ')': {
                    if (n == 0) {
                        return true;
                    }
                    --n;
                    scanner.next();
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        return !bl;
                    }
                    scanner.next();
                }
            }
            bl = false;
        }
        return true;
    }

    private static boolean isEscapable(char c) {
        switch (c) {
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }
}

