/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.util;

import java.io.Closeable;
import java.io.Reader;

public class LineReader
implements Closeable {
    static final int CHAR_BUFFER_SIZE = 8192;
    static final int EXPECTED_LINE_LENGTH = 80;
    private Reader reader;
    private char[] cbuf;
    private int position = 0;
    private int limit = 0;
    private String lineTerminator = null;

    public LineReader(Reader reader) {
        this.reader = reader;
        this.cbuf = new char[8192];
    }

    public String readLine() {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        while (true) {
            int n;
            if (this.position >= this.limit) {
                this.fill();
            }
            if (bl) {
                if (this.position < this.limit && this.cbuf[this.position] == '\n') {
                    ++this.position;
                    return this.line(stringBuilder.toString(), "\r\n");
                }
                return this.line(stringBuilder.toString(), "\r");
            }
            if (this.position >= this.limit) {
                return this.line(stringBuilder != null ? stringBuilder.toString() : null, null);
            }
            int n2 = this.position;
            for (n = this.position; n < this.limit; ++n) {
                char c = this.cbuf[n];
                if (c == '\n') {
                    this.position = n + 1;
                    return this.line(this.finish(stringBuilder, n2, n), "\n");
                }
                if (c != '\r') continue;
                if (n + 1 < this.limit) {
                    if (this.cbuf[n + 1] == '\n') {
                        this.position = n + 2;
                        return this.line(this.finish(stringBuilder, n2, n), "\r\n");
                    }
                    this.position = n + 1;
                    return this.line(this.finish(stringBuilder, n2, n), "\r");
                }
                bl = true;
                this.position = n + 1;
                break;
            }
            if (this.position < n) {
                this.position = n;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(80);
            }
            stringBuilder.append(this.cbuf, n2, n - n2);
        }
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    @Override
    public void close() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        finally {
            this.reader = null;
            this.cbuf = null;
        }
    }

    private void fill() {
        int n;
        while ((n = this.reader.read(this.cbuf, 0, this.cbuf.length)) == 0) {
        }
        if (n > 0) {
            this.limit = n;
            this.position = 0;
        }
    }

    private String line(String string, String string2) {
        this.lineTerminator = string2;
        return string;
    }

    private String finish(StringBuilder stringBuilder, int n, int n2) {
        int n3 = n2 - n;
        if (stringBuilder == null) {
            return new String(this.cbuf, n, n3);
        }
        return stringBuilder.append(this.cbuf, n, n3).toString();
    }
}

