/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class Html5Entities {
    private static final Map<String, String> NAMED_CHARACTER_REFERENCES = Html5Entities.readEntities();
    private static final String ENTITY_PATH = "/org/commonmark/internal/util/entities.txt";

    public static String entityToString(String string) {
        if (!string.startsWith("&") || !string.endsWith(";")) {
            return string;
        }
        String string2 = string.substring(1, string.length() - 1);
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
            int n = 10;
            if (string2.startsWith("x") || string2.startsWith("X")) {
                string2 = string2.substring(1);
                n = 16;
            }
            try {
                int n2 = Integer.parseInt(string2, n);
                if (n2 == 0) {
                    return "\ufffd";
                }
                return new String(Character.toChars(n2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return "\ufffd";
            }
        }
        String string3 = NAMED_CHARACTER_REFERENCES.get(string2);
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    private static Map<String, String> readEntities() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        InputStream inputStream = Html5Entities.class.getResourceAsStream(ENTITY_PATH);
        Charset charset = StandardCharsets.UTF_8;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                int n = string.indexOf("=");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                hashMap.put(string2, string3);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed reading data for HTML named character references", iOException);
        }
        hashMap.put("NewLine", "\n");
        return hashMap;
    }
}

