/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.util;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.internal.util.Html5Entities;

public class Escaping {
    public static final String ESCAPABLE = "[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
    public static final String ENTITY = "&(?:#x[a-f0-9]{1,6}|#[0-9]{1,7}|[a-z][a-z0-9]{1,31});";
    private static final Pattern BACKSLASH_OR_AMP = Pattern.compile("[\\\\&]");
    private static final Pattern ENTITY_OR_ESCAPED_CHAR = Pattern.compile("\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|&(?:#x[a-f0-9]{1,6}|#[0-9]{1,7}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern ESCAPE_IN_URI = Pattern.compile("(%[a-fA-F0-9]{0,2}|[^:/?#@!$&'()*+,;=a-zA-Z0-9\\-._~])");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private static final Replacer UNESCAPE_REPLACER = new Replacer(){

        @Override
        public void replace(String string, StringBuilder stringBuilder) {
            if (string.charAt(0) == '\\') {
                stringBuilder.append(string, 1, string.length());
            } else {
                stringBuilder.append(Html5Entities.entityToString(string));
            }
        }
    };
    private static final Replacer URI_REPLACER = new Replacer(){

        @Override
        public void replace(String string, StringBuilder stringBuilder) {
            if (string.startsWith("%")) {
                if (string.length() == 3) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append("%25");
                    stringBuilder.append(string, 1, string.length());
                }
            } else {
                byte[] byArray;
                for (byte by : byArray = string.getBytes(StandardCharsets.UTF_8)) {
                    stringBuilder.append('%');
                    stringBuilder.append(HEX_DIGITS[by >> 4 & 0xF]);
                    stringBuilder.append(HEX_DIGITS[by & 0xF]);
                }
            }
        }
    };

    public static String escapeHtml(String string) {
        StringBuilder stringBuilder = null;
        block6: for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                default: {
                    if (stringBuilder == null) continue block6;
                    stringBuilder.append(c);
                    continue block6;
                }
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
                stringBuilder.append(string, 0, i);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    public static String unescapeString(String string) {
        if (BACKSLASH_OR_AMP.matcher(string).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, string, UNESCAPE_REPLACER);
        }
        return string;
    }

    public static String percentEncodeUrl(String string) {
        return Escaping.replaceAll(ESCAPE_IN_URI, string, URI_REPLACER);
    }

    public static String normalizeLabelContent(String string) {
        String string2 = string.trim();
        String string3 = string2.toLowerCase(Locale.ROOT).toUpperCase(Locale.ROOT);
        return WHITESPACE.matcher(string3).replaceAll(" ");
    }

    private static String replaceAll(Pattern pattern, String string, Replacer replacer) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        int n = 0;
        do {
            stringBuilder.append(string, n, matcher.start());
            replacer.replace(matcher.group(), stringBuilder);
            n = matcher.end();
        } while (matcher.find());
        if (n != string.length()) {
            stringBuilder.append(string, n, string.length());
        }
        return stringBuilder.toString();
    }

    private static interface Replacer {
        public void replace(String var1, StringBuilder var2);
    }
}

