/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;

public class NodeRendererMap {
    private final List<NodeRenderer> nodeRenderers = new ArrayList<NodeRenderer>();
    private final Map<Class<? extends Node>, NodeRenderer> renderers = new HashMap<Class<? extends Node>, NodeRenderer>(32);

    public void add(NodeRenderer nodeRenderer) {
        this.nodeRenderers.add(nodeRenderer);
        for (Class<? extends Node> clazz : nodeRenderer.getNodeTypes()) {
            this.renderers.putIfAbsent(clazz, nodeRenderer);
        }
    }

    public void render(Node node) {
        NodeRenderer nodeRenderer = this.renderers.get(node.getClass());
        if (nodeRenderer != null) {
            nodeRenderer.render(node);
        }
    }

    public void beforeRoot(Node node) {
        this.nodeRenderers.forEach(nodeRenderer -> nodeRenderer.beforeRoot(node));
    }

    public void afterRoot(Node node) {
        this.nodeRenderers.forEach(nodeRenderer -> nodeRenderer.afterRoot(node));
    }
}

