/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.inline;

import org.commonmark.node.Emphasis;
import org.commonmark.node.Node;
import org.commonmark.node.Nodes;
import org.commonmark.node.SourceSpans;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

public abstract class EmphasisDelimiterProcessor
implements DelimiterProcessor {
    private final char delimiterChar;

    protected EmphasisDelimiterProcessor(char c) {
        this.delimiterChar = c;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delimiterChar;
    }

    @Override
    public char getClosingCharacter() {
        return this.delimiterChar;
    }

    @Override
    public int getMinLength() {
        return 1;
    }

    @Override
    public int process(DelimiterRun delimiterRun, DelimiterRun delimiterRun2) {
        Node node;
        int n;
        if ((delimiterRun.canClose() || delimiterRun2.canOpen()) && delimiterRun2.originalLength() % 3 != 0 && (delimiterRun.originalLength() + delimiterRun2.originalLength()) % 3 == 0) {
            return 0;
        }
        if (delimiterRun.length() >= 2 && delimiterRun2.length() >= 2) {
            n = 2;
            node = new StrongEmphasis(String.valueOf(this.delimiterChar) + this.delimiterChar);
        } else {
            n = 1;
            node = new Emphasis(String.valueOf(this.delimiterChar));
        }
        SourceSpans sourceSpans = SourceSpans.empty();
        sourceSpans.addAllFrom(delimiterRun.getOpeners(n));
        Text text = delimiterRun.getOpener();
        for (Node node2 : Nodes.between(text, delimiterRun2.getCloser())) {
            node.appendChild(node2);
            sourceSpans.addAll(node2.getSourceSpans());
        }
        sourceSpans.addAllFrom(delimiterRun2.getClosers(n));
        node.setSourceSpans(sourceSpans.getSourceSpans());
        text.insertAfter(node);
        return n;
    }
}

