/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.inline;

import java.util.Set;
import java.util.regex.Pattern;
import org.commonmark.node.Link;
import org.commonmark.node.Text;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.beta.InlineContentParser;
import org.commonmark.parser.beta.InlineContentParserFactory;
import org.commonmark.parser.beta.InlineParserState;
import org.commonmark.parser.beta.ParsedInline;
import org.commonmark.parser.beta.Position;
import org.commonmark.parser.beta.Scanner;

public class AutolinkInlineParser
implements InlineContentParser {
    private static final Pattern URI = Pattern.compile("^[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*$");
    private static final Pattern EMAIL = Pattern.compile("^([a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)$");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        Position position = scanner.position();
        if (scanner.find('>') > 0) {
            SourceLines sourceLines = scanner.getSource(position, scanner.position());
            String string = sourceLines.getContent();
            scanner.next();
            Object object = null;
            if (URI.matcher(string).matches()) {
                object = string;
            } else if (EMAIL.matcher(string).matches()) {
                object = "mailto:" + string;
            }
            if (object != null) {
                Link link = new Link((String)object, null);
                Text text = new Text(string);
                text.setSourceSpans(sourceLines.getSourceSpans());
                link.appendChild(text);
                return ParsedInline.of(link, scanner.position());
            }
        }
        return ParsedInline.none();
    }

    public static class Factory
    implements InlineContentParserFactory {
        @Override
        public Set<Character> getTriggerCharacters() {
            return Set.of(Character.valueOf('<'));
        }

        @Override
        public InlineContentParser create() {
            return new AutolinkInlineParser();
        }
    }
}

