/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import org.commonmark.node.Block;
import org.commonmark.node.ThematicBreak;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

public class ThematicBreakParser
extends AbstractBlockParser {
    private final ThematicBreak block = new ThematicBreak();

    public ThematicBreakParser(String string) {
        this.block.setLiteral(string);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        return BlockContinue.none();
    }

    private static boolean isThematicBreak(CharSequence charSequence, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = charSequence.length();
        block6: for (int i = n; i < n5; ++i) {
            switch (charSequence.charAt(i)) {
                case '-': {
                    ++n2;
                    continue block6;
                }
                case '_': {
                    ++n3;
                    continue block6;
                }
                case '*': {
                    ++n4;
                    continue block6;
                }
                case '\t': 
                case ' ': {
                    continue block6;
                }
                default: {
                    return false;
                }
            }
        }
        return n2 >= 3 && n3 == 0 && n4 == 0 || n3 >= 3 && n2 == 0 && n4 == 0 || n4 >= 3 && n2 == 0 && n3 == 0;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState parserState, MatchedBlockParser matchedBlockParser) {
            if (parserState.getIndent() >= 4) {
                return BlockStart.none();
            }
            int n = parserState.getNextNonSpaceIndex();
            CharSequence charSequence = parserState.getLine().getContent();
            if (ThematicBreakParser.isThematicBreak(charSequence, n)) {
                String string = String.valueOf(charSequence.subSequence(parserState.getIndex(), charSequence.length()));
                return BlockStart.of(new ThematicBreakParser(string)).atIndex(charSequence.length());
            }
            return BlockStart.none();
        }
    }
}

