/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.LinkedList;
import java.util.ListIterator;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

class StaggeredDelimiterProcessor
implements DelimiterProcessor {
    private final char delim;
    private int minLength = 0;
    private LinkedList<DelimiterProcessor> processors = new LinkedList();

    StaggeredDelimiterProcessor(char c) {
        this.delim = c;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delim;
    }

    @Override
    public char getClosingCharacter() {
        return this.delim;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    void add(DelimiterProcessor delimiterProcessor) {
        int n = delimiterProcessor.getMinLength();
        ListIterator<DelimiterProcessor> listIterator = this.processors.listIterator();
        boolean bl = false;
        while (listIterator.hasNext()) {
            DelimiterProcessor delimiterProcessor2 = (DelimiterProcessor)listIterator.next();
            int n2 = delimiterProcessor2.getMinLength();
            if (n > n2) {
                listIterator.previous();
                listIterator.add(delimiterProcessor);
                bl = true;
                break;
            }
            if (n != n2) continue;
            throw new IllegalArgumentException("Cannot add two delimiter processors for char '" + this.delim + "' and minimum length " + n + "; conflicting processors: " + delimiterProcessor2 + ", " + delimiterProcessor);
        }
        if (!bl) {
            this.processors.add(delimiterProcessor);
            this.minLength = n;
        }
    }

    private DelimiterProcessor findProcessor(int n) {
        for (DelimiterProcessor delimiterProcessor : this.processors) {
            if (delimiterProcessor.getMinLength() > n) continue;
            return delimiterProcessor;
        }
        return this.processors.getFirst();
    }

    @Override
    public int process(DelimiterRun delimiterRun, DelimiterRun delimiterRun2) {
        return this.findProcessor(delimiterRun.length()).process(delimiterRun, delimiterRun2);
    }
}

