/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import org.commonmark.node.Block;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Paragraph;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.ParserState;

public class ListItemParser
extends AbstractBlockParser {
    private final ListItem block = new ListItem();
    private int contentIndent;
    private boolean hadBlankLine;

    public ListItemParser(int n, int n2) {
        this.contentIndent = n2;
        this.block.setMarkerIndent(n);
        this.block.setContentIndent(n2);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block block) {
        Block block2;
        if (this.hadBlankLine && (block2 = this.block.getParent()) instanceof ListBlock) {
            ((ListBlock)block2).setTight(false);
        }
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        if (parserState.isBlank()) {
            if (this.block.getFirstChild() == null) {
                return BlockContinue.none();
            }
            Block block = parserState.getActiveBlockParser().getBlock();
            this.hadBlankLine = block instanceof Paragraph || block instanceof ListItem;
            return BlockContinue.atIndex(parserState.getNextNonSpaceIndex());
        }
        if (parserState.getIndent() >= this.contentIndent) {
            return BlockContinue.atColumn(parserState.getColumn() + this.contentIndent);
        }
        return BlockContinue.none();
    }
}

