/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.Objects;
import org.commonmark.internal.ListItemParser;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.BulletList;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.OrderedList;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

public class ListBlockParser
extends AbstractBlockParser {
    private final ListBlock block;
    private boolean hadBlankLine;
    private int linesAfterBlank;

    public ListBlockParser(ListBlock listBlock) {
        this.block = listBlock;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block block) {
        if (block instanceof ListItem) {
            if (this.hadBlankLine && this.linesAfterBlank == 1) {
                this.block.setTight(false);
                this.hadBlankLine = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        if (parserState.isBlank()) {
            this.hadBlankLine = true;
            this.linesAfterBlank = 0;
        } else if (this.hadBlankLine) {
            ++this.linesAfterBlank;
        }
        return BlockContinue.atIndex(parserState.getIndex());
    }

    private static ListData parseList(CharSequence charSequence, int n, int n2, boolean bl) {
        int n3;
        ListMarkerData listMarkerData = ListBlockParser.parseListMarker(charSequence, n);
        if (listMarkerData == null) {
            return null;
        }
        ListBlock listBlock = listMarkerData.listBlock;
        int n4 = listMarkerData.indexAfterMarker;
        int n5 = n4 - n;
        int n6 = n3 = n2 + n5;
        boolean bl2 = false;
        int n7 = charSequence.length();
        for (int i = n4; i < n7; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\t') {
                n6 += Parsing.columnsToNextTabStop(n6);
                continue;
            }
            if (c == ' ') {
                ++n6;
                continue;
            }
            bl2 = true;
            break;
        }
        if (bl) {
            if (listBlock instanceof OrderedList && ((OrderedList)listBlock).getMarkerStartNumber() != 1) {
                return null;
            }
            if (!bl2) {
                return null;
            }
        }
        if (!bl2 || n6 - n3 > Parsing.CODE_BLOCK_INDENT) {
            n6 = n3 + 1;
        }
        return new ListData(listBlock, n6);
    }

    private static ListMarkerData parseListMarker(CharSequence charSequence, int n) {
        char c = charSequence.charAt(n);
        switch (c) {
            case '*': 
            case '+': 
            case '-': {
                if (ListBlockParser.isSpaceTabOrEnd(charSequence, n + 1)) {
                    BulletList bulletList = new BulletList();
                    bulletList.setMarker(String.valueOf(c));
                    return new ListMarkerData(bulletList, n + 1);
                }
                return null;
            }
        }
        return ListBlockParser.parseOrderedList(charSequence, n);
    }

    private static ListMarkerData parseOrderedList(CharSequence charSequence, int n) {
        int n2 = 0;
        int n3 = charSequence.length();
        block4: for (int i = n; i < n3; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (++n2 <= 9) continue block4;
                    return null;
                }
                case ')': 
                case '.': {
                    if (n2 >= 1 && ListBlockParser.isSpaceTabOrEnd(charSequence, i + 1)) {
                        String string = charSequence.subSequence(n, i).toString();
                        OrderedList orderedList = new OrderedList();
                        orderedList.setMarkerStartNumber(Integer.parseInt(string));
                        orderedList.setMarkerDelimiter(String.valueOf(c));
                        return new ListMarkerData(orderedList, i + 1);
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static boolean isSpaceTabOrEnd(CharSequence charSequence, int n) {
        if (n < charSequence.length()) {
            switch (charSequence.charAt(n)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean listsMatch(ListBlock listBlock, ListBlock listBlock2) {
        if (listBlock instanceof BulletList && listBlock2 instanceof BulletList) {
            return Objects.equals(((BulletList)listBlock).getMarker(), ((BulletList)listBlock2).getMarker());
        }
        if (listBlock instanceof OrderedList && listBlock2 instanceof OrderedList) {
            return Objects.equals(((OrderedList)listBlock).getMarkerDelimiter(), ((OrderedList)listBlock2).getMarkerDelimiter());
        }
        return false;
    }

    private static class ListMarkerData {
        final ListBlock listBlock;
        final int indexAfterMarker;

        ListMarkerData(ListBlock listBlock, int n) {
            this.listBlock = listBlock;
            this.indexAfterMarker = n;
        }
    }

    private static class ListData {
        final ListBlock listBlock;
        final int contentColumn;

        ListData(ListBlock listBlock, int n) {
            this.listBlock = listBlock;
            this.contentColumn = n;
        }
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState parserState, MatchedBlockParser matchedBlockParser) {
            BlockParser blockParser = matchedBlockParser.getMatchedBlockParser();
            if (parserState.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int n = parserState.getNextNonSpaceIndex();
            int n2 = parserState.getColumn() + parserState.getIndent();
            boolean bl = !matchedBlockParser.getParagraphLines().isEmpty();
            ListData listData = ListBlockParser.parseList(parserState.getLine().getContent(), n, n2, bl);
            if (listData == null) {
                return BlockStart.none();
            }
            int n3 = listData.contentColumn;
            ListItemParser listItemParser = new ListItemParser(parserState.getIndent(), n3 - parserState.getColumn());
            if (!(blockParser instanceof ListBlockParser) || !ListBlockParser.listsMatch((ListBlock)blockParser.getBlock(), listData.listBlock)) {
                ListBlockParser listBlockParser = new ListBlockParser(listData.listBlock);
                listData.listBlock.setTight(true);
                return BlockStart.of(listBlockParser, listItemParser).atColumn(n3);
            }
            return BlockStart.of(listItemParser).atColumn(n3);
        }
    }
}

