/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.commonmark.internal.util.Escaping;
import org.commonmark.internal.util.LinkScanner;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.beta.Position;
import org.commonmark.parser.beta.Scanner;

public class LinkReferenceDefinitionParser {
    private State state = State.START_DEFINITION;
    private final List<SourceLine> paragraphLines = new ArrayList<SourceLine>();
    private final List<LinkReferenceDefinition> definitions = new ArrayList<LinkReferenceDefinition>();
    private final List<SourceSpan> sourceSpans = new ArrayList<SourceSpan>();
    private StringBuilder label;
    private String destination;
    private char titleDelimiter;
    private StringBuilder title;
    private boolean referenceValid = false;

    public void parse(SourceLine sourceLine) {
        this.paragraphLines.add(sourceLine);
        if (this.state == State.PARAGRAPH) {
            return;
        }
        Scanner scanner = Scanner.of(SourceLines.of(sourceLine));
        while (scanner.hasNext()) {
            boolean bl;
            switch (this.state) {
                case START_DEFINITION: {
                    bl = this.startDefinition(scanner);
                    break;
                }
                case LABEL: {
                    bl = this.label(scanner);
                    break;
                }
                case DESTINATION: {
                    bl = this.destination(scanner);
                    break;
                }
                case START_TITLE: {
                    bl = this.startTitle(scanner);
                    break;
                }
                case TITLE: {
                    bl = this.title(scanner);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown parsing state: " + this.state);
                }
            }
            if (bl) continue;
            this.state = State.PARAGRAPH;
            this.finishReference();
            return;
        }
    }

    public void addSourceSpan(SourceSpan sourceSpan) {
        this.sourceSpans.add(sourceSpan);
    }

    SourceLines getParagraphLines() {
        return SourceLines.of(this.paragraphLines);
    }

    List<SourceSpan> getParagraphSourceSpans() {
        return this.sourceSpans;
    }

    List<LinkReferenceDefinition> getDefinitions() {
        this.finishReference();
        return this.definitions;
    }

    State getState() {
        return this.state;
    }

    List<SourceSpan> removeLines(int n) {
        List<SourceSpan> list = Collections.unmodifiableList(new ArrayList<SourceSpan>(this.sourceSpans.subList(Math.max(this.sourceSpans.size() - n, 0), this.sourceSpans.size())));
        LinkReferenceDefinitionParser.removeLast(n, this.paragraphLines);
        LinkReferenceDefinitionParser.removeLast(n, this.sourceSpans);
        return list;
    }

    private boolean startDefinition(Scanner scanner) {
        this.finishReference();
        scanner.whitespace();
        if (!scanner.next('[')) {
            return false;
        }
        this.state = State.LABEL;
        this.label = new StringBuilder();
        if (!scanner.hasNext()) {
            this.label.append('\n');
        }
        return true;
    }

    private boolean label(Scanner scanner) {
        Position position = scanner.position();
        if (!LinkScanner.scanLinkLabelContent(scanner)) {
            return false;
        }
        this.label.append(scanner.getSource(position, scanner.position()).getContent());
        if (!scanner.hasNext()) {
            this.label.append('\n');
            return true;
        }
        if (scanner.next(']')) {
            if (!scanner.next(':')) {
                return false;
            }
            if (this.label.length() > 999) {
                return false;
            }
            String string = Escaping.normalizeLabelContent(this.label.toString());
            if (string.isEmpty()) {
                return false;
            }
            this.state = State.DESTINATION;
            scanner.whitespace();
            return true;
        }
        return false;
    }

    private boolean destination(Scanner scanner) {
        scanner.whitespace();
        Position position = scanner.position();
        if (!LinkScanner.scanLinkDestination(scanner)) {
            return false;
        }
        String string = scanner.getSource(position, scanner.position()).getContent();
        this.destination = string.startsWith("<") ? string.substring(1, string.length() - 1) : string;
        int n = scanner.whitespace();
        if (!scanner.hasNext()) {
            this.referenceValid = true;
            this.paragraphLines.clear();
        } else if (n == 0) {
            return false;
        }
        this.state = State.START_TITLE;
        return true;
    }

    private boolean startTitle(Scanner scanner) {
        scanner.whitespace();
        if (!scanner.hasNext()) {
            this.state = State.START_DEFINITION;
            return true;
        }
        this.titleDelimiter = '\u0000';
        char c = scanner.peek();
        switch (c) {
            case '\"': 
            case '\'': {
                this.titleDelimiter = c;
                break;
            }
            case '(': {
                this.titleDelimiter = (char)41;
            }
        }
        if (this.titleDelimiter != '\u0000') {
            this.state = State.TITLE;
            this.title = new StringBuilder();
            scanner.next();
            if (!scanner.hasNext()) {
                this.title.append('\n');
            }
        } else {
            this.state = State.START_DEFINITION;
        }
        return true;
    }

    private boolean title(Scanner scanner) {
        Position position = scanner.position();
        if (!LinkScanner.scanLinkTitleContent(scanner, this.titleDelimiter)) {
            this.title = null;
            return false;
        }
        this.title.append(scanner.getSource(position, scanner.position()).getContent());
        if (!scanner.hasNext()) {
            this.title.append('\n');
            return true;
        }
        scanner.next();
        scanner.whitespace();
        if (scanner.hasNext()) {
            this.title = null;
            return false;
        }
        this.referenceValid = true;
        this.paragraphLines.clear();
        this.state = State.START_DEFINITION;
        return true;
    }

    private void finishReference() {
        if (!this.referenceValid) {
            return;
        }
        String string = Escaping.unescapeString(this.destination);
        String string2 = this.title != null ? Escaping.unescapeString(this.title.toString()) : null;
        LinkReferenceDefinition linkReferenceDefinition = new LinkReferenceDefinition(this.label.toString(), string, string2);
        linkReferenceDefinition.setSourceSpans(this.sourceSpans);
        this.sourceSpans.clear();
        this.definitions.add(linkReferenceDefinition);
        this.label = null;
        this.referenceValid = false;
        this.destination = null;
        this.title = null;
    }

    private static <T> void removeLast(int n, List<T> list) {
        if (n >= list.size()) {
            list.clear();
        } else {
            for (int i = 0; i < n; ++i) {
                list.remove(list.size() - 1);
            }
        }
    }

    static enum State {
        START_DEFINITION,
        LABEL,
        DESTINATION,
        START_TITLE,
        TITLE,
        PARAGRAPH;

    }
}

