/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.commonmark.internal.Bracket;
import org.commonmark.internal.Delimiter;
import org.commonmark.internal.StaggeredDelimiterProcessor;
import org.commonmark.internal.inline.AsteriskDelimiterProcessor;
import org.commonmark.internal.inline.AutolinkInlineParser;
import org.commonmark.internal.inline.BackslashInlineParser;
import org.commonmark.internal.inline.BackticksInlineParser;
import org.commonmark.internal.inline.CoreLinkProcessor;
import org.commonmark.internal.inline.EntityInlineParser;
import org.commonmark.internal.inline.HtmlInlineParser;
import org.commonmark.internal.inline.LinkResultImpl;
import org.commonmark.internal.inline.ParsedInlineImpl;
import org.commonmark.internal.inline.UnderscoreDelimiterProcessor;
import org.commonmark.internal.util.Escaping;
import org.commonmark.internal.util.LinkScanner;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.SourceSpans;
import org.commonmark.node.Text;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.InlineParserContext;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.beta.InlineContentParser;
import org.commonmark.parser.beta.InlineContentParserFactory;
import org.commonmark.parser.beta.InlineParserState;
import org.commonmark.parser.beta.LinkInfo;
import org.commonmark.parser.beta.LinkProcessor;
import org.commonmark.parser.beta.LinkResult;
import org.commonmark.parser.beta.ParsedInline;
import org.commonmark.parser.beta.Position;
import org.commonmark.parser.beta.Scanner;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.text.Characters;

public class InlineParserImpl
implements InlineParser,
InlineParserState {
    private final InlineParserContext context;
    private final List<InlineContentParserFactory> inlineContentParserFactories;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private final List<LinkProcessor> linkProcessors;
    private final BitSet specialCharacters;
    private final BitSet linkMarkers;
    private Map<Character, List<InlineContentParser>> inlineParsers;
    private Scanner scanner;
    private boolean includeSourceSpans;
    private int trailingSpaces;
    private Delimiter lastDelimiter;
    private Bracket lastBracket;

    public InlineParserImpl(InlineParserContext inlineParserContext) {
        this.context = inlineParserContext;
        this.inlineContentParserFactories = this.calculateInlineContentParserFactories(inlineParserContext.getCustomInlineContentParserFactories());
        this.delimiterProcessors = InlineParserImpl.calculateDelimiterProcessors(inlineParserContext.getCustomDelimiterProcessors());
        this.linkProcessors = this.calculateLinkProcessors(inlineParserContext.getCustomLinkProcessors());
        this.linkMarkers = InlineParserImpl.calculateLinkMarkers(inlineParserContext.getCustomLinkMarkers());
        this.specialCharacters = InlineParserImpl.calculateSpecialCharacters(this.linkMarkers, this.delimiterProcessors.keySet(), this.inlineContentParserFactories);
    }

    private List<InlineContentParserFactory> calculateInlineContentParserFactories(List<InlineContentParserFactory> list) {
        ArrayList<InlineContentParserFactory> arrayList = new ArrayList<InlineContentParserFactory>(list);
        arrayList.add(new BackslashInlineParser.Factory());
        arrayList.add(new BackticksInlineParser.Factory());
        arrayList.add(new EntityInlineParser.Factory());
        arrayList.add(new AutolinkInlineParser.Factory());
        arrayList.add(new HtmlInlineParser.Factory());
        return arrayList;
    }

    private List<LinkProcessor> calculateLinkProcessors(List<LinkProcessor> list) {
        ArrayList<LinkProcessor> arrayList = new ArrayList<LinkProcessor>(list);
        arrayList.add(new CoreLinkProcessor());
        return arrayList;
    }

    private static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(List<DelimiterProcessor> list) {
        HashMap<Character, DelimiterProcessor> hashMap = new HashMap<Character, DelimiterProcessor>();
        InlineParserImpl.addDelimiterProcessors(List.of(new AsteriskDelimiterProcessor(), new UnderscoreDelimiterProcessor()), hashMap);
        InlineParserImpl.addDelimiterProcessors(list, hashMap);
        return hashMap;
    }

    private static void addDelimiterProcessors(Iterable<DelimiterProcessor> iterable, Map<Character, DelimiterProcessor> map) {
        for (DelimiterProcessor delimiterProcessor : iterable) {
            char c;
            char c2 = delimiterProcessor.getOpeningCharacter();
            if (c2 == (c = delimiterProcessor.getClosingCharacter())) {
                DelimiterProcessor delimiterProcessor2 = map.get(Character.valueOf(c2));
                if (delimiterProcessor2 != null && delimiterProcessor2.getOpeningCharacter() == delimiterProcessor2.getClosingCharacter()) {
                    StaggeredDelimiterProcessor staggeredDelimiterProcessor;
                    if (delimiterProcessor2 instanceof StaggeredDelimiterProcessor) {
                        staggeredDelimiterProcessor = (StaggeredDelimiterProcessor)delimiterProcessor2;
                    } else {
                        staggeredDelimiterProcessor = new StaggeredDelimiterProcessor(c2);
                        staggeredDelimiterProcessor.add(delimiterProcessor2);
                    }
                    staggeredDelimiterProcessor.add(delimiterProcessor);
                    map.put(Character.valueOf(c2), staggeredDelimiterProcessor);
                    continue;
                }
                InlineParserImpl.addDelimiterProcessorForChar(c2, delimiterProcessor, map);
                continue;
            }
            InlineParserImpl.addDelimiterProcessorForChar(c2, delimiterProcessor, map);
            InlineParserImpl.addDelimiterProcessorForChar(c, delimiterProcessor, map);
        }
    }

    private static void addDelimiterProcessorForChar(char c, DelimiterProcessor delimiterProcessor, Map<Character, DelimiterProcessor> map) {
        DelimiterProcessor delimiterProcessor2 = map.put(Character.valueOf(c), delimiterProcessor);
        if (delimiterProcessor2 != null) {
            throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + c + "'");
        }
    }

    private static BitSet calculateLinkMarkers(Set<Character> set) {
        BitSet bitSet = new BitSet();
        for (Character c : set) {
            bitSet.set(c.charValue());
        }
        bitSet.set(33);
        return bitSet;
    }

    private static BitSet calculateSpecialCharacters(BitSet bitSet, Set<Character> set, List<InlineContentParserFactory> list) {
        BitSet bitSet2 = (BitSet)bitSet.clone();
        for (Character object : set) {
            bitSet2.set(object.charValue());
        }
        for (InlineContentParserFactory inlineContentParserFactory : list) {
            for (Character c : inlineContentParserFactory.getTriggerCharacters()) {
                bitSet2.set(c.charValue());
            }
        }
        bitSet2.set(91);
        bitSet2.set(93);
        bitSet2.set(33);
        bitSet2.set(10);
        return bitSet2;
    }

    private Map<Character, List<InlineContentParser>> createInlineContentParsers() {
        HashMap<Character, List<InlineContentParser>> hashMap = new HashMap<Character, List<InlineContentParser>>();
        for (InlineContentParserFactory inlineContentParserFactory : this.inlineContentParserFactories) {
            InlineContentParser inlineContentParser = inlineContentParserFactory.create();
            for (Character c2 : inlineContentParserFactory.getTriggerCharacters()) {
                hashMap.computeIfAbsent(c2, c -> new ArrayList()).add(inlineContentParser);
            }
        }
        return hashMap;
    }

    @Override
    public Scanner scanner() {
        return this.scanner;
    }

    @Override
    public void parse(SourceLines sourceLines, Node node) {
        List<? extends Node> list;
        this.reset(sourceLines);
        while ((list = this.parseInline()) != null) {
            for (Node node2 : list) {
                node.appendChild(node2);
            }
        }
        this.processDelimiters(null);
        this.mergeChildTextNodes(node);
    }

    void reset(SourceLines sourceLines) {
        this.scanner = Scanner.of(sourceLines);
        this.includeSourceSpans = !sourceLines.getSourceSpans().isEmpty();
        this.trailingSpaces = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
        this.inlineParsers = this.createInlineContentParsers();
    }

    private Text text(SourceLines sourceLines) {
        Text text = new Text(sourceLines.getContent());
        text.setSourceSpans(sourceLines.getSourceSpans());
        return text;
    }

    private List<? extends Node> parseInline() {
        Object object;
        List<? extends Node> list;
        List<InlineContentParser> list2;
        char c = this.scanner.peek();
        switch (c) {
            case '[': {
                return List.of(this.parseOpenBracket());
            }
            case ']': {
                return List.of(this.parseCloseBracket());
            }
            case '\n': {
                return List.of(this.parseLineBreak());
            }
            case '\u0000': {
                return null;
            }
        }
        if (this.linkMarkers.get(c)) {
            list2 = this.scanner.position();
            list = this.parseLinkMarker();
            if (list != null) {
                return list;
            }
            this.scanner.setPosition((Position)((Object)list2));
        }
        if (!this.specialCharacters.get(c)) {
            return List.of(this.parseText());
        }
        list2 = this.inlineParsers.get(Character.valueOf(c));
        if (list2 != null) {
            list = this.scanner.position();
            object = list2.iterator();
            while (object.hasNext()) {
                InlineContentParser inlineContentParser = (InlineContentParser)object.next();
                ParsedInline parsedInline = inlineContentParser.tryParse(this);
                if (parsedInline instanceof ParsedInlineImpl) {
                    ParsedInlineImpl parsedInlineImpl = (ParsedInlineImpl)parsedInline;
                    Node node = parsedInlineImpl.getNode();
                    this.scanner.setPosition(parsedInlineImpl.getPosition());
                    if (this.includeSourceSpans && node.getSourceSpans().isEmpty()) {
                        node.setSourceSpans(this.scanner.getSource((Position)((Object)list), this.scanner.position()).getSourceSpans());
                    }
                    return List.of(node);
                }
                this.scanner.setPosition((Position)((Object)list));
            }
        }
        if ((list = this.delimiterProcessors.get(Character.valueOf(c))) != null && (object = this.parseDelimiters((DelimiterProcessor)((Object)list), c)) != null) {
            return object;
        }
        return List.of(this.parseText());
    }

    private List<? extends Node> parseDelimiters(DelimiterProcessor delimiterProcessor, char c) {
        DelimiterData delimiterData = this.scanDelimiters(delimiterProcessor, c);
        if (delimiterData == null) {
            return null;
        }
        List<Text> list = delimiterData.characters;
        this.lastDelimiter = new Delimiter(list, c, delimiterData.canOpen, delimiterData.canClose, this.lastDelimiter);
        if (this.lastDelimiter.previous != null) {
            this.lastDelimiter.previous.next = this.lastDelimiter;
        }
        return list;
    }

    private Node parseOpenBracket() {
        Position position = this.scanner.position();
        this.scanner.next();
        Position position2 = this.scanner.position();
        Text text = this.text(this.scanner.getSource(position, position2));
        this.addBracket(Bracket.link(text, position, position2, this.lastBracket, this.lastDelimiter));
        return text;
    }

    private List<? extends Node> parseLinkMarker() {
        Position position = this.scanner.position();
        this.scanner.next();
        Position position2 = this.scanner.position();
        if (this.scanner.next('[')) {
            Position position3 = this.scanner.position();
            Text text = this.text(this.scanner.getSource(position, position2));
            Text text2 = this.text(this.scanner.getSource(position2, position3));
            this.addBracket(Bracket.withMarker(text, position, text2, position2, position3, this.lastBracket, this.lastDelimiter));
            return List.of(text, text2);
        }
        return null;
    }

    private Node parseCloseBracket() {
        Position position = this.scanner.position();
        this.scanner.next();
        Position position2 = this.scanner.position();
        Bracket bracket = this.lastBracket;
        if (bracket == null) {
            return this.text(this.scanner.getSource(position, position2));
        }
        if (!bracket.allowed) {
            this.removeLastBracket();
            return this.text(this.scanner.getSource(position, position2));
        }
        Node node = this.parseLinkOrImage(bracket, position);
        if (node != null) {
            return node;
        }
        this.scanner.setPosition(position2);
        this.removeLastBracket();
        return this.text(this.scanner.getSource(position, position2));
    }

    private Node parseLinkOrImage(Bracket bracket, Position position) {
        LinkInfo linkInfo = this.parseLinkInfo(bracket, position);
        if (linkInfo == null) {
            return null;
        }
        Position position2 = this.scanner.position();
        for (LinkProcessor linkProcessor : this.linkProcessors) {
            LinkResult linkResult = linkProcessor.process(linkInfo, this.scanner, this.context);
            if (!(linkResult instanceof LinkResultImpl)) {
                this.scanner.setPosition(position2);
                continue;
            }
            LinkResultImpl linkResultImpl = (LinkResultImpl)linkResult;
            Node node = linkResultImpl.getNode();
            Position position3 = linkResultImpl.getPosition();
            boolean bl = linkResultImpl.isIncludeMarker();
            switch (linkResultImpl.getType()) {
                case WRAP: {
                    this.scanner.setPosition(position3);
                    return this.wrapBracket(bracket, node, bl);
                }
                case REPLACE: {
                    this.scanner.setPosition(position3);
                    return this.replaceBracket(bracket, node, bl);
                }
            }
        }
        return null;
    }

    private LinkInfo parseLinkInfo(Bracket bracket, Position position) {
        boolean bl;
        String string = this.scanner.getSource(bracket.contentPosition, position).getContent();
        Position position2 = this.scanner.position();
        DestinationTitle destinationTitle = InlineParserImpl.parseInlineDestinationTitle(this.scanner);
        if (destinationTitle != null) {
            return new LinkInfoImpl(bracket.markerNode, bracket.bracketNode, string, null, destinationTitle.destination, destinationTitle.title, position2);
        }
        this.scanner.setPosition(position2);
        String string2 = InlineParserImpl.parseLinkLabel(this.scanner);
        if (string2 == null) {
            this.scanner.setPosition(position2);
        }
        boolean bl2 = bl = string2 == null || string2.isEmpty();
        if (bracket.bracketAfter && bl && bracket.markerNode == null) {
            return null;
        }
        return new LinkInfoImpl(bracket.markerNode, bracket.bracketNode, string, string2, null, null, position2);
    }

    private Node wrapBracket(Bracket bracket, Node node, boolean bl) {
        Object object;
        Node node2 = bracket.bracketNode.getNext();
        while (node2 != null) {
            object = node2.getNext();
            node.appendChild(node2);
            node2 = object;
        }
        if (this.includeSourceSpans) {
            object = bl && bracket.markerPosition != null ? bracket.markerPosition : bracket.bracketPosition;
            node.setSourceSpans(this.scanner.getSource((Position)object, this.scanner.position()).getSourceSpans());
        }
        this.processDelimiters(bracket.previousDelimiter);
        this.mergeChildTextNodes(node);
        if (bl && bracket.markerNode != null) {
            bracket.markerNode.unlink();
        }
        bracket.bracketNode.unlink();
        this.removeLastBracket();
        if (bracket.markerNode == null) {
            object = this.lastBracket;
            while (object != null) {
                if (((Bracket)object).markerNode == null) {
                    ((Bracket)object).allowed = false;
                }
                object = ((Bracket)object).previous;
            }
        }
        return node;
    }

    private Node replaceBracket(Bracket bracket, Node node, boolean bl) {
        Object object;
        while (this.lastDelimiter != null && this.lastDelimiter != bracket.previousDelimiter) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
        if (this.includeSourceSpans) {
            object = bl && bracket.markerPosition != null ? bracket.markerPosition : bracket.bracketPosition;
            node.setSourceSpans(this.scanner.getSource((Position)object, this.scanner.position()).getSourceSpans());
        }
        this.removeLastBracket();
        Object object2 = object = bl && bracket.markerNode != null ? bracket.markerNode : bracket.bracketNode;
        while (object != null) {
            Node node2 = ((Node)object).getNext();
            ((Node)object).unlink();
            object = node2;
        }
        return node;
    }

    private void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.bracketAfter = true;
        }
        this.lastBracket = bracket;
    }

    private void removeLastBracket() {
        this.lastBracket = this.lastBracket.previous;
    }

    private static DestinationTitle parseInlineDestinationTitle(Scanner scanner) {
        if (!scanner.next('(')) {
            return null;
        }
        scanner.whitespace();
        String string = InlineParserImpl.parseLinkDestination(scanner);
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = scanner.whitespace();
        if (n >= 1) {
            string2 = InlineParserImpl.parseLinkTitle(scanner);
            scanner.whitespace();
        }
        if (!scanner.next(')')) {
            return null;
        }
        return new DestinationTitle(string, string2);
    }

    private static String parseLinkDestination(Scanner scanner) {
        String string;
        char c = scanner.peek();
        Position position = scanner.position();
        if (!LinkScanner.scanLinkDestination(scanner)) {
            return null;
        }
        if (c == '<') {
            String string2 = scanner.getSource(position, scanner.position()).getContent();
            string = string2.substring(1, string2.length() - 1);
        } else {
            string = scanner.getSource(position, scanner.position()).getContent();
        }
        return Escaping.unescapeString(string);
    }

    private static String parseLinkTitle(Scanner scanner) {
        Position position = scanner.position();
        if (!LinkScanner.scanLinkTitle(scanner)) {
            return null;
        }
        String string = scanner.getSource(position, scanner.position()).getContent();
        String string2 = string.substring(1, string.length() - 1);
        return Escaping.unescapeString(string2);
    }

    static String parseLinkLabel(Scanner scanner) {
        if (!scanner.next('[')) {
            return null;
        }
        Position position = scanner.position();
        if (!LinkScanner.scanLinkLabelContent(scanner)) {
            return null;
        }
        Position position2 = scanner.position();
        if (!scanner.next(']')) {
            return null;
        }
        String string = scanner.getSource(position, position2).getContent();
        if (string.length() > 999) {
            return null;
        }
        return string;
    }

    private Node parseLineBreak() {
        this.scanner.next();
        if (this.trailingSpaces >= 2) {
            return new HardLineBreak();
        }
        return new SoftLineBreak();
    }

    private Node parseText() {
        int n;
        char c;
        Position position = this.scanner.position();
        this.scanner.next();
        while ((c = this.scanner.peek()) != '\u0000' && !this.specialCharacters.get(c)) {
            this.scanner.next();
        }
        SourceLines sourceLines = this.scanner.getSource(position, this.scanner.position());
        String string = sourceLines.getContent();
        if (c == '\n') {
            n = Characters.skipBackwards(' ', string, string.length() - 1, 0) + 1;
            this.trailingSpaces = string.length() - n;
            string = string.substring(0, n);
        } else if (c == '\u0000') {
            n = Characters.skipSpaceTabBackwards(string, string.length() - 1, 0) + 1;
            string = string.substring(0, n);
        }
        Text text = new Text(string);
        text.setSourceSpans(sourceLines.getSourceSpans());
        return text;
    }

    private DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char c) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n = this.scanner.peekPreviousCodePoint();
        Position position = this.scanner.position();
        int n2 = this.scanner.matchMultiple(c);
        if (n2 < delimiterProcessor.getMinLength()) {
            this.scanner.setPosition(position);
            return null;
        }
        ArrayList<Text> arrayList = new ArrayList<Text>();
        this.scanner.setPosition(position);
        Position position2 = position;
        while (this.scanner.next(c)) {
            arrayList.add(this.text(this.scanner.getSource(position2, this.scanner.position())));
            position2 = this.scanner.position();
        }
        int n3 = this.scanner.peekCodePoint();
        boolean bl4 = n == 0 || Characters.isPunctuationCodePoint(n);
        boolean bl5 = n == 0 || Characters.isWhitespaceCodePoint(n);
        boolean bl6 = n3 == 0 || Characters.isPunctuationCodePoint(n3);
        boolean bl7 = n3 == 0 || Characters.isWhitespaceCodePoint(n3);
        boolean bl8 = !bl7 && (!bl6 || bl5 || bl4);
        boolean bl9 = bl3 = !bl5 && (!bl4 || bl7 || bl6);
        if (c == '_') {
            bl2 = bl8 && (!bl3 || bl4);
            bl = bl3 && (!bl8 || bl6);
        } else {
            bl2 = bl8 && c == delimiterProcessor.getOpeningCharacter();
            bl = bl3 && c == delimiterProcessor.getClosingCharacter();
        }
        return new DelimiterData(arrayList, bl2, bl);
    }

    private void processDelimiters(Delimiter delimiter) {
        HashMap<Character, Delimiter> hashMap = new HashMap<Character, Delimiter>();
        Delimiter delimiter2 = this.lastDelimiter;
        while (delimiter2 != null && delimiter2.previous != delimiter) {
            delimiter2 = delimiter2.previous;
        }
        while (delimiter2 != null) {
            Text text;
            int n;
            char c = delimiter2.delimiterChar;
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
            if (!delimiter2.canClose() || delimiterProcessor == null) {
                delimiter2 = delimiter2.next;
                continue;
            }
            char c2 = delimiterProcessor.getOpeningCharacter();
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            Delimiter delimiter3 = delimiter2.previous;
            while (delimiter3 != null && delimiter3 != delimiter && delimiter3 != hashMap.get(Character.valueOf(c))) {
                if (delimiter3.canOpen() && delimiter3.delimiterChar == c2) {
                    bl2 = true;
                    n2 = delimiterProcessor.process(delimiter3, delimiter2);
                    if (n2 > 0) {
                        bl = true;
                        break;
                    }
                }
                delimiter3 = delimiter3.previous;
            }
            if (!bl) {
                if (!bl2) {
                    hashMap.put(Character.valueOf(c), delimiter2.previous);
                    if (!delimiter2.canOpen()) {
                        this.removeDelimiterKeepNode(delimiter2);
                    }
                }
                delimiter2 = delimiter2.next;
                continue;
            }
            for (n = 0; n < n2; ++n) {
                text = delimiter3.characters.remove(delimiter3.characters.size() - 1);
                text.unlink();
            }
            for (n = 0; n < n2; ++n) {
                text = delimiter2.characters.remove(0);
                text.unlink();
            }
            this.removeDelimitersBetween(delimiter3, delimiter2);
            if (delimiter3.length() == 0) {
                this.removeDelimiterAndNodes(delimiter3);
            }
            if (delimiter2.length() != 0) continue;
            Delimiter delimiter4 = delimiter2.next;
            this.removeDelimiterAndNodes(delimiter2);
            delimiter2 = delimiter4;
        }
        while (this.lastDelimiter != null && this.lastDelimiter != delimiter) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    private void removeDelimitersBetween(Delimiter delimiter, Delimiter delimiter2) {
        Delimiter delimiter3 = delimiter2.previous;
        while (delimiter3 != null && delimiter3 != delimiter) {
            Delimiter delimiter4 = delimiter3.previous;
            this.removeDelimiterKeepNode(delimiter3);
            delimiter3 = delimiter4;
        }
    }

    private void removeDelimiterAndNodes(Delimiter delimiter) {
        this.removeDelimiter(delimiter);
    }

    private void removeDelimiterKeepNode(Delimiter delimiter) {
        this.removeDelimiter(delimiter);
    }

    private void removeDelimiter(Delimiter delimiter) {
        if (delimiter.previous != null) {
            delimiter.previous.next = delimiter.next;
        }
        if (delimiter.next == null) {
            this.lastDelimiter = delimiter.previous;
        } else {
            delimiter.next.previous = delimiter.previous;
        }
    }

    private void mergeChildTextNodes(Node node) {
        if (node.getFirstChild() == null) {
            return;
        }
        this.mergeTextNodesInclusive(node.getFirstChild(), node.getLastChild());
    }

    private void mergeTextNodesInclusive(Node node, Node node2) {
        Text text = null;
        Text text2 = null;
        int n = 0;
        for (Node node3 = node; node3 != null; node3 = node3.getNext()) {
            if (node3 instanceof Text) {
                Text text3 = (Text)node3;
                if (text == null) {
                    text = text3;
                }
                n += text3.getLiteral().length();
                text2 = text3;
            } else {
                this.mergeIfNeeded(text, text2, n);
                text = null;
                text2 = null;
                n = 0;
                this.mergeChildTextNodes(node3);
            }
            if (node3 == node2) break;
        }
        this.mergeIfNeeded(text, text2, n);
    }

    private void mergeIfNeeded(Text text, Text text2, int n) {
        if (text != null && text2 != null && text != text2) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder(n);
            stringBuilder.append(text.getLiteral());
            SourceSpans sourceSpans = null;
            if (this.includeSourceSpans) {
                sourceSpans = new SourceSpans();
                sourceSpans.addAll(text.getSourceSpans());
            }
            Node node = text2.getNext();
            for (Node node2 = text.getNext(); node2 != node; node2 = node2.getNext()) {
                stringBuilder.append(((Text)node2).getLiteral());
                if (sourceSpans != null) {
                    sourceSpans.addAll(node2.getSourceSpans());
                }
                object = node2;
                ((Node)object).unlink();
            }
            object = stringBuilder.toString();
            text.setLiteral((String)object);
            if (sourceSpans != null) {
                text.setSourceSpans(sourceSpans.getSourceSpans());
            }
        }
    }

    private static class DelimiterData {
        final List<Text> characters;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(List<Text> list, boolean bl, boolean bl2) {
            this.characters = list;
            this.canOpen = bl;
            this.canClose = bl2;
        }
    }

    private static class DestinationTitle {
        final String destination;
        final String title;

        public DestinationTitle(String string, String string2) {
            this.destination = string;
            this.title = string2;
        }
    }

    private static class LinkInfoImpl
    implements LinkInfo {
        private final Text marker;
        private final Text openingBracket;
        private final String text;
        private final String label;
        private final String destination;
        private final String title;
        private final Position afterTextBracket;

        private LinkInfoImpl(Text text, Text text2, String string, String string2, String string3, String string4, Position position) {
            this.marker = text;
            this.openingBracket = text2;
            this.text = string;
            this.label = string2;
            this.destination = string3;
            this.title = string4;
            this.afterTextBracket = position;
        }

        @Override
        public Text marker() {
            return this.marker;
        }

        @Override
        public Text openingBracket() {
            return this.openingBracket;
        }

        @Override
        public String text() {
            return this.text;
        }

        @Override
        public String label() {
            return this.label;
        }

        @Override
        public String destination() {
            return this.destination;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public Position afterTextBracket() {
            return this.afterTextBracket;
        }
    }
}

