/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Paragraph;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.text.Characters;

public class IndentedCodeBlockParser
extends AbstractBlockParser {
    private final IndentedCodeBlock block = new IndentedCodeBlock();
    private final List<CharSequence> lines = new ArrayList<CharSequence>();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        if (parserState.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
            return BlockContinue.atColumn(parserState.getColumn() + Parsing.CODE_BLOCK_INDENT);
        }
        if (parserState.isBlank()) {
            return BlockContinue.atIndex(parserState.getNextNonSpaceIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine sourceLine) {
        this.lines.add(sourceLine.getContent());
    }

    @Override
    public void closeBlock() {
        int n;
        for (n = this.lines.size() - 1; n >= 0 && Characters.isBlank(this.lines.get(n)); --n) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n + 1; ++i) {
            stringBuilder.append(this.lines.get(i));
            stringBuilder.append('\n');
        }
        String string = stringBuilder.toString();
        this.block.setLiteral(string);
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState parserState, MatchedBlockParser matchedBlockParser) {
            if (parserState.getIndent() >= Parsing.CODE_BLOCK_INDENT && !parserState.isBlank() && !(parserState.getActiveBlockParser().getBlock() instanceof Paragraph)) {
                return BlockStart.of(new IndentedCodeBlockParser()).atColumn(parserState.getColumn() + Parsing.CODE_BLOCK_INDENT);
            }
            return BlockStart.none();
        }
    }
}

