/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.regex.Pattern;
import org.commonmark.internal.BlockContent;
import org.commonmark.node.Block;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.Paragraph;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

public class HtmlBlockParser
extends AbstractBlockParser {
    private static final String TAGNAME = "[A-Za-z][A-Za-z0-9-]*";
    private static final String ATTRIBUTENAME = "[a-zA-Z_:][a-zA-Z0-9:._-]*";
    private static final String UNQUOTEDVALUE = "[^\"'=<>`\\x00-\\x20]+";
    private static final String SINGLEQUOTEDVALUE = "'[^']*'";
    private static final String DOUBLEQUOTEDVALUE = "\"[^\"]*\"";
    private static final String ATTRIBUTEVALUE = "(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\")";
    private static final String ATTRIBUTEVALUESPEC = "(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))";
    private static final String ATTRIBUTE = "(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)";
    private static final String OPENTAG = "<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>";
    private static final String CLOSETAG = "</[A-Za-z][A-Za-z0-9-]*\\s*[>]";
    private static final Pattern[][] BLOCK_PATTERNS = new Pattern[][]{{null, null}, {Pattern.compile("^<(?:script|pre|style|textarea)(?:\\s|>|$)", 2), Pattern.compile("</(?:script|pre|style|textarea)>", 2)}, {Pattern.compile("^<!--"), Pattern.compile("-->")}, {Pattern.compile("^<[?]"), Pattern.compile("\\?>")}, {Pattern.compile("^<![A-Z]"), Pattern.compile(">")}, {Pattern.compile("^<!\\[CDATA\\["), Pattern.compile("\\]\\]>")}, {Pattern.compile("^</?(?:address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|nav|noframes|ol|optgroup|option|p|param|search|section|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul)(?:\\s|[/]?[>]|$)", 2), null}, {Pattern.compile("^(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>])\\s*$", 2), null}};
    private final HtmlBlock block = new HtmlBlock();
    private final Pattern closingPattern;
    private boolean finished = false;
    private BlockContent content = new BlockContent();

    private HtmlBlockParser(Pattern pattern) {
        this.closingPattern = pattern;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        if (this.finished) {
            return BlockContinue.none();
        }
        if (parserState.isBlank() && this.closingPattern == null) {
            return BlockContinue.none();
        }
        return BlockContinue.atIndex(parserState.getIndex());
    }

    @Override
    public void addLine(SourceLine sourceLine) {
        this.content.add(sourceLine.getContent());
        if (this.closingPattern != null && this.closingPattern.matcher(sourceLine.getContent()).find()) {
            this.finished = true;
        }
    }

    @Override
    public void closeBlock() {
        this.block.setLiteral(this.content.getString());
        this.content = null;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState parserState, MatchedBlockParser matchedBlockParser) {
            int n = parserState.getNextNonSpaceIndex();
            CharSequence charSequence = parserState.getLine().getContent();
            if (parserState.getIndent() < 4 && charSequence.charAt(n) == '<') {
                for (int i = 1; i <= 7; ++i) {
                    if (i == 7 && (matchedBlockParser.getMatchedBlockParser().getBlock() instanceof Paragraph || parserState.getActiveBlockParser().canHaveLazyContinuationLines())) continue;
                    Pattern pattern = BLOCK_PATTERNS[i][0];
                    Pattern pattern2 = BLOCK_PATTERNS[i][1];
                    boolean bl = pattern.matcher(charSequence.subSequence(n, charSequence.length())).find();
                    if (!bl) continue;
                    return BlockStart.of(new HtmlBlockParser(pattern2)).atIndex(parserState.getIndex());
                }
            }
            return BlockStart.none();
        }
    }
}

