/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.Heading;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.beta.Position;
import org.commonmark.parser.beta.Scanner;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.text.Characters;

public class HeadingParser
extends AbstractBlockParser {
    private final Heading block = new Heading();
    private final SourceLines content;

    public HeadingParser(int n, SourceLines sourceLines) {
        this.block.setLevel(n);
        this.content = sourceLines;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        return BlockContinue.none();
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        inlineParser.parse(this.content, this.block);
    }

    private static HeadingParser getAtxHeading(SourceLine sourceLine) {
        Position position;
        Scanner scanner = Scanner.of(SourceLines.of(sourceLine));
        int n = scanner.matchMultiple('#');
        if (n == 0 || n > 6) {
            return null;
        }
        if (!scanner.hasNext()) {
            return new HeadingParser(n, SourceLines.empty());
        }
        char c = scanner.peek();
        if (c != ' ' && c != '\t') {
            return null;
        }
        scanner.whitespace();
        Position position2 = position = scanner.position();
        boolean bl = true;
        block4: while (scanner.hasNext()) {
            char c2 = scanner.peek();
            switch (c2) {
                case '#': {
                    if (bl) {
                        scanner.matchMultiple('#');
                        int n2 = scanner.whitespace();
                        if (scanner.hasNext()) {
                            position2 = scanner.position();
                        }
                        bl = n2 > 0;
                        continue block4;
                    }
                    scanner.next();
                    position2 = scanner.position();
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    bl = true;
                    scanner.next();
                    continue block4;
                }
            }
            bl = false;
            scanner.next();
            position2 = scanner.position();
        }
        SourceLines sourceLines = scanner.getSource(position, position2);
        String string = sourceLines.getContent();
        if (string.isEmpty()) {
            return new HeadingParser(n, SourceLines.empty());
        }
        return new HeadingParser(n, sourceLines);
    }

    private static int getSetextHeadingLevel(CharSequence charSequence, int n) {
        switch (charSequence.charAt(n)) {
            case '=': {
                if (!HeadingParser.isSetextHeadingRest(charSequence, n + 1, '=')) break;
                return 1;
            }
            case '-': {
                if (!HeadingParser.isSetextHeadingRest(charSequence, n + 1, '-')) break;
                return 2;
            }
        }
        return 0;
    }

    private static boolean isSetextHeadingRest(CharSequence charSequence, int n, char c) {
        int n2 = Characters.skip(c, charSequence, n, charSequence.length());
        int n3 = Characters.skipSpaceTab(charSequence, n2, charSequence.length());
        return n3 >= charSequence.length();
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState parserState, MatchedBlockParser matchedBlockParser) {
            SourceLines sourceLines;
            HeadingParser headingParser;
            if (parserState.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            SourceLine sourceLine = parserState.getLine();
            int n = parserState.getNextNonSpaceIndex();
            if (sourceLine.getContent().charAt(n) == '#' && (headingParser = HeadingParser.getAtxHeading(sourceLine.substring(n, sourceLine.getContent().length()))) != null) {
                return BlockStart.of(headingParser).atIndex(sourceLine.getContent().length());
            }
            int n2 = HeadingParser.getSetextHeadingLevel(sourceLine.getContent(), n);
            if (n2 > 0 && !(sourceLines = matchedBlockParser.getParagraphLines()).isEmpty()) {
                return BlockStart.of(new HeadingParser(n2, sourceLines)).atIndex(sourceLine.getContent().length()).replaceParagraphLines(sourceLines.getLines().size());
            }
            return BlockStart.none();
        }
    }
}

