/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import org.commonmark.internal.util.Escaping;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.text.Characters;

public class FencedCodeBlockParser
extends AbstractBlockParser {
    private final FencedCodeBlock block = new FencedCodeBlock();
    private final char fenceChar;
    private final int openingFenceLength;
    private String firstLine;
    private StringBuilder otherLines = new StringBuilder();

    public FencedCodeBlockParser(char c, int n, int n2) {
        this.fenceChar = c;
        this.openingFenceLength = n;
        this.block.setFenceCharacter(String.valueOf(c));
        this.block.setOpeningFenceLength(n);
        this.block.setFenceIndent(n2);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        int n = parserState.getNextNonSpaceIndex();
        int n2 = parserState.getIndex();
        CharSequence charSequence = parserState.getLine().getContent();
        if (parserState.getIndent() < Parsing.CODE_BLOCK_INDENT && n < charSequence.length() && this.tryClosing(charSequence, n)) {
            return BlockContinue.finished();
        }
        int n3 = charSequence.length();
        for (int i = this.block.getFenceIndent(); i > 0 && n2 < n3 && charSequence.charAt(n2) == ' '; ++n2, --i) {
        }
        return BlockContinue.atIndex(n2);
    }

    @Override
    public void addLine(SourceLine sourceLine) {
        if (this.firstLine == null) {
            this.firstLine = sourceLine.getContent().toString();
        } else {
            this.otherLines.append(sourceLine.getContent());
            this.otherLines.append('\n');
        }
    }

    @Override
    public void closeBlock() {
        this.block.setInfo(Escaping.unescapeString(this.firstLine.trim()));
        this.block.setLiteral(this.otherLines.toString());
    }

    private static FencedCodeBlockParser checkOpener(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = charSequence.length();
        block4: for (int i = n; i < n5; ++i) {
            switch (charSequence.charAt(i)) {
                case '`': {
                    ++n3;
                    continue block4;
                }
                case '~': {
                    ++n4;
                    continue block4;
                }
            }
        }
        if (n3 >= 3 && n4 == 0) {
            if (Characters.find('`', charSequence, n + n3) != -1) {
                return null;
            }
            return new FencedCodeBlockParser('`', n3, n2);
        }
        if (n4 >= 3 && n3 == 0) {
            return new FencedCodeBlockParser('~', n4, n2);
        }
        return null;
    }

    private boolean tryClosing(CharSequence charSequence, int n) {
        int n2 = Characters.skip(this.fenceChar, charSequence, n, charSequence.length()) - n;
        if (n2 < this.openingFenceLength) {
            return false;
        }
        int n3 = Characters.skipSpaceTab(charSequence, n + n2, charSequence.length());
        if (n3 == charSequence.length()) {
            this.block.setClosingFenceLength(n2);
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState parserState, MatchedBlockParser matchedBlockParser) {
            int n = parserState.getIndent();
            if (n >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int n2 = parserState.getNextNonSpaceIndex();
            FencedCodeBlockParser fencedCodeBlockParser = FencedCodeBlockParser.checkOpener(parserState.getLine().getContent(), n2, n);
            if (fencedCodeBlockParser != null) {
                return BlockStart.of(fencedCodeBlockParser).atIndex(n2 + fencedCodeBlockParser.block.getOpeningFenceLength());
            }
            return BlockStart.none();
        }
    }
}

