/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.commonmark.internal.BlockContinueImpl;
import org.commonmark.internal.BlockQuoteParser;
import org.commonmark.internal.BlockStartImpl;
import org.commonmark.internal.Definitions;
import org.commonmark.internal.DocumentBlockParser;
import org.commonmark.internal.FencedCodeBlockParser;
import org.commonmark.internal.HeadingParser;
import org.commonmark.internal.HtmlBlockParser;
import org.commonmark.internal.IndentedCodeBlockParser;
import org.commonmark.internal.InlineParserContextImpl;
import org.commonmark.internal.ListBlockParser;
import org.commonmark.internal.ParagraphParser;
import org.commonmark.internal.ThematicBreakParser;
import org.commonmark.internal.util.LineReader;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.DefinitionMap;
import org.commonmark.node.Document;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.ListBlock;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.ThematicBreak;
import org.commonmark.parser.IncludeSourceSpans;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.InlineParserFactory;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.beta.InlineContentParserFactory;
import org.commonmark.parser.beta.LinkProcessor;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockParserFactory;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.text.Characters;

public class DocumentParser
implements ParserState {
    private static final Set<Class<? extends Block>> CORE_FACTORY_TYPES = new LinkedHashSet<Class<IndentedCodeBlock>>(List.of(BlockQuote.class, Heading.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, ListBlock.class, IndentedCodeBlock.class));
    private static final Map<Class<? extends Block>, BlockParserFactory> NODES_TO_CORE_FACTORIES;
    private SourceLine line;
    private int lineIndex = -1;
    private int index = 0;
    private int column = 0;
    private boolean columnIsInTab;
    private int nextNonSpace = 0;
    private int nextNonSpaceColumn = 0;
    private int indent = 0;
    private boolean blank;
    private final List<BlockParserFactory> blockParserFactories;
    private final InlineParserFactory inlineParserFactory;
    private final List<InlineContentParserFactory> inlineContentParserFactories;
    private final List<DelimiterProcessor> delimiterProcessors;
    private final List<LinkProcessor> linkProcessors;
    private final Set<Character> linkMarkers;
    private final IncludeSourceSpans includeSourceSpans;
    private final DocumentBlockParser documentBlockParser;
    private final Definitions definitions = new Definitions();
    private final List<OpenBlockParser> openBlockParsers = new ArrayList<OpenBlockParser>();
    private final List<BlockParser> allBlockParsers = new ArrayList<BlockParser>();

    public DocumentParser(List<BlockParserFactory> list, InlineParserFactory inlineParserFactory, List<InlineContentParserFactory> list2, List<DelimiterProcessor> list3, List<LinkProcessor> list4, Set<Character> set, IncludeSourceSpans includeSourceSpans) {
        this.blockParserFactories = list;
        this.inlineParserFactory = inlineParserFactory;
        this.inlineContentParserFactories = list2;
        this.delimiterProcessors = list3;
        this.linkProcessors = list4;
        this.linkMarkers = set;
        this.includeSourceSpans = includeSourceSpans;
        this.documentBlockParser = new DocumentBlockParser();
        this.activateBlockParser(new OpenBlockParser(this.documentBlockParser, 0));
    }

    public static Set<Class<? extends Block>> getDefaultBlockParserTypes() {
        return CORE_FACTORY_TYPES;
    }

    public static List<BlockParserFactory> calculateBlockParserFactories(List<BlockParserFactory> list, Set<Class<? extends Block>> set) {
        ArrayList<BlockParserFactory> arrayList = new ArrayList<BlockParserFactory>();
        arrayList.addAll(list);
        for (Class<? extends Block> clazz : set) {
            arrayList.add(NODES_TO_CORE_FACTORIES.get(clazz));
        }
        return arrayList;
    }

    public static void checkEnabledBlockTypes(Set<Class<? extends Block>> set) {
        for (Class<? extends Block> clazz : set) {
            if (NODES_TO_CORE_FACTORIES.containsKey(clazz)) continue;
            throw new IllegalArgumentException("Can't enable block type " + clazz + ", possible options are: " + NODES_TO_CORE_FACTORIES.keySet());
        }
    }

    public Document parse(String string) {
        String string2;
        int n;
        int n2 = 0;
        while ((n = Characters.findLineBreak(string, n2)) != -1) {
            string2 = string.substring(n2, n);
            this.parseLine(string2, n2);
            if (n + 1 < string.length() && string.charAt(n) == '\r' && string.charAt(n + 1) == '\n') {
                n2 = n + 2;
                continue;
            }
            n2 = n + 1;
        }
        if (!(string.isEmpty() || n2 != 0 && n2 >= string.length())) {
            string2 = string.substring(n2);
            this.parseLine(string2, n2);
        }
        return this.finalizeAndProcess();
    }

    public Document parse(Reader reader) {
        String string;
        LineReader lineReader = new LineReader(reader);
        int n = 0;
        while ((string = lineReader.readLine()) != null) {
            this.parseLine(string, n);
            n += string.length();
            String string2 = lineReader.getLineTerminator();
            if (string2 == null) continue;
            n += string2.length();
        }
        return this.finalizeAndProcess();
    }

    @Override
    public SourceLine getLine() {
        return this.line;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getNextNonSpaceIndex() {
        return this.nextNonSpace;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public boolean isBlank() {
        return this.blank;
    }

    @Override
    public BlockParser getActiveBlockParser() {
        return this.openBlockParsers.get((int)(this.openBlockParsers.size() - 1)).blockParser;
    }

    private void parseLine(String string, int n) {
        Object object;
        boolean bl;
        Object object2;
        int n2;
        this.setLine(string, n);
        int n3 = 1;
        for (n2 = 1; n2 < this.openBlockParsers.size(); ++n2) {
            object2 = this.openBlockParsers.get(n2);
            BlockParser blockParser = ((OpenBlockParser)object2).blockParser;
            this.findNextNonSpace();
            BlockContinue blockContinue = blockParser.tryContinue(this);
            if (!(blockContinue instanceof BlockContinueImpl)) break;
            BlockContinueImpl blockContinueImpl = (BlockContinueImpl)blockContinue;
            ((OpenBlockParser)object2).sourceIndex = this.getIndex();
            if (blockContinueImpl.isFinalize()) {
                this.addSourceSpans();
                this.closeBlockParsers(this.openBlockParsers.size() - n2);
                return;
            }
            if (blockContinueImpl.getNewIndex() != -1) {
                this.setNewIndex(blockContinueImpl.getNewIndex());
            } else if (blockContinueImpl.getNewColumn() != -1) {
                this.setNewColumn(blockContinueImpl.getNewColumn());
            }
            ++n3;
        }
        n2 = this.openBlockParsers.size() - n3;
        object2 = this.openBlockParsers.get((int)(n3 - 1)).blockParser;
        boolean bl2 = false;
        int n4 = this.index;
        boolean bl3 = bl = object2.getBlock() instanceof Paragraph || object2.isContainer();
        while (bl) {
            n4 = this.index;
            this.findNextNonSpace();
            if (this.isBlank() || this.indent < Parsing.CODE_BLOCK_INDENT && Characters.isLetter(this.line.getContent(), this.nextNonSpace)) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            object = this.findBlockStart((BlockParser)object2);
            if (object == null) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            bl2 = true;
            int n5 = this.getIndex();
            if (n2 > 0) {
                this.closeBlockParsers(n2);
                n2 = 0;
            }
            if (((BlockStartImpl)object).getNewIndex() != -1) {
                this.setNewIndex(((BlockStartImpl)object).getNewIndex());
            } else if (((BlockStartImpl)object).getNewColumn() != -1) {
                this.setNewColumn(((BlockStartImpl)object).getNewColumn());
            }
            List<SourceSpan> list = null;
            if (((BlockStartImpl)object).getReplaceParagraphLines() >= 1 || ((BlockStartImpl)object).isReplaceActiveBlockParser()) {
                BlockParser[] blockParserArray = this.getActiveBlockParser();
                if (blockParserArray instanceof ParagraphParser) {
                    ParagraphParser paragraphParser = (ParagraphParser)blockParserArray;
                    int n6 = ((BlockStartImpl)object).isReplaceActiveBlockParser() ? Integer.MAX_VALUE : ((BlockStartImpl)object).getReplaceParagraphLines();
                    list = this.replaceParagraphLines(n6, paragraphParser);
                } else if (((BlockStartImpl)object).isReplaceActiveBlockParser()) {
                    list = this.prepareActiveBlockParserForReplacement((BlockParser)blockParserArray);
                }
            }
            for (BlockParser blockParser : ((BlockStartImpl)object).getBlockParsers()) {
                this.addChild(new OpenBlockParser(blockParser, n5));
                if (list != null) {
                    blockParser.getBlock().setSourceSpans(list);
                }
                object2 = blockParser;
                bl = blockParser.isContainer();
            }
        }
        if (!bl2 && !this.isBlank() && this.getActiveBlockParser().canHaveLazyContinuationLines()) {
            this.openBlockParsers.get((int)(this.openBlockParsers.size() - 1)).sourceIndex = n4;
            this.addLine();
        } else {
            if (n2 > 0) {
                this.closeBlockParsers(n2);
            }
            if (!object2.isContainer()) {
                this.addLine();
            } else if (!this.isBlank()) {
                object = new ParagraphParser();
                this.addChild(new OpenBlockParser((BlockParser)object, n4));
                this.addLine();
            } else {
                this.addSourceSpans();
            }
        }
    }

    private void setLine(String string, int n) {
        ++this.lineIndex;
        this.index = 0;
        this.column = 0;
        this.columnIsInTab = false;
        String string2 = DocumentParser.prepareLine(string);
        SourceSpan sourceSpan = null;
        if (this.includeSourceSpans != IncludeSourceSpans.NONE) {
            sourceSpan = SourceSpan.of(this.lineIndex, 0, n, string2.length());
        }
        this.line = SourceLine.of(string2, sourceSpan);
    }

    private void findNextNonSpace() {
        int n = this.index;
        int n2 = this.column;
        this.blank = true;
        int n3 = this.line.getContent().length();
        block4: while (n < n3) {
            char c = this.line.getContent().charAt(n);
            switch (c) {
                case ' ': {
                    ++n;
                    ++n2;
                    continue block4;
                }
                case '\t': {
                    ++n;
                    n2 += 4 - n2 % 4;
                    continue block4;
                }
            }
            this.blank = false;
            break;
        }
        this.nextNonSpace = n;
        this.nextNonSpaceColumn = n2;
        this.indent = this.nextNonSpaceColumn - this.column;
    }

    private void setNewIndex(int n) {
        if (n >= this.nextNonSpace) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        int n2 = this.line.getContent().length();
        while (this.index < n && this.index != n2) {
            this.advance();
        }
        this.columnIsInTab = false;
    }

    private void setNewColumn(int n) {
        if (n >= this.nextNonSpaceColumn) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        int n2 = this.line.getContent().length();
        while (this.column < n && this.index != n2) {
            this.advance();
        }
        if (this.column > n) {
            --this.index;
            this.column = n;
            this.columnIsInTab = true;
        } else {
            this.columnIsInTab = false;
        }
    }

    private void advance() {
        char c = this.line.getContent().charAt(this.index);
        ++this.index;
        this.column = c == '\t' ? (this.column += Parsing.columnsToNextTabStop(this.column)) : ++this.column;
    }

    private void addLine() {
        CharSequence charSequence;
        if (this.columnIsInTab) {
            int n = this.index + 1;
            CharSequence charSequence2 = this.line.getContent().subSequence(n, this.line.getContent().length());
            int n2 = Parsing.columnsToNextTabStop(this.column);
            StringBuilder stringBuilder = new StringBuilder(n2 + charSequence2.length());
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(charSequence2);
            charSequence = stringBuilder.toString();
        } else {
            charSequence = this.index == 0 ? this.line.getContent() : this.line.getContent().subSequence(this.index, this.line.getContent().length());
        }
        SourceSpan sourceSpan = null;
        if (this.includeSourceSpans == IncludeSourceSpans.BLOCKS_AND_INLINES && this.index < this.line.getSourceSpan().getLength()) {
            sourceSpan = this.line.getSourceSpan().subSpan(this.index);
        }
        this.getActiveBlockParser().addLine(SourceLine.of(charSequence, sourceSpan));
        this.addSourceSpans();
    }

    private void addSourceSpans() {
        if (this.includeSourceSpans != IncludeSourceSpans.NONE) {
            for (int i = 1; i < this.openBlockParsers.size(); ++i) {
                OpenBlockParser openBlockParser = this.openBlockParsers.get(i);
                int n = Math.min(openBlockParser.sourceIndex, this.index);
                int n2 = this.line.getContent().length() - n;
                if (n2 == 0) continue;
                openBlockParser.blockParser.addSourceSpan(this.line.getSourceSpan().subSpan(n));
            }
        }
    }

    private BlockStartImpl findBlockStart(BlockParser blockParser) {
        MatchedBlockParserImpl matchedBlockParserImpl = new MatchedBlockParserImpl(blockParser);
        for (BlockParserFactory blockParserFactory : this.blockParserFactories) {
            BlockStart blockStart = blockParserFactory.tryStart(this, matchedBlockParserImpl);
            if (!(blockStart instanceof BlockStartImpl)) continue;
            return (BlockStartImpl)blockStart;
        }
        return null;
    }

    private void processInlines() {
        InlineParserContextImpl inlineParserContextImpl = new InlineParserContextImpl(this.inlineContentParserFactories, this.delimiterProcessors, this.linkProcessors, this.linkMarkers, this.definitions);
        InlineParser inlineParser = this.inlineParserFactory.create(inlineParserContextImpl);
        for (BlockParser blockParser : this.allBlockParsers) {
            blockParser.parseInlines(inlineParser);
        }
    }

    private void addChild(OpenBlockParser openBlockParser) {
        while (!this.getActiveBlockParser().canContain(openBlockParser.blockParser.getBlock())) {
            this.closeBlockParsers(1);
        }
        this.getActiveBlockParser().getBlock().appendChild(openBlockParser.blockParser.getBlock());
        this.activateBlockParser(openBlockParser);
    }

    private void activateBlockParser(OpenBlockParser openBlockParser) {
        this.openBlockParsers.add(openBlockParser);
    }

    private OpenBlockParser deactivateBlockParser() {
        return this.openBlockParsers.remove(this.openBlockParsers.size() - 1);
    }

    private List<SourceSpan> replaceParagraphLines(int n, ParagraphParser paragraphParser) {
        List<SourceSpan> list = paragraphParser.removeLines(n);
        this.closeBlockParsers(1);
        return list;
    }

    private List<SourceSpan> prepareActiveBlockParserForReplacement(BlockParser blockParser) {
        this.deactivateBlockParser();
        blockParser.closeBlock();
        blockParser.getBlock().unlink();
        return blockParser.getBlock().getSourceSpans();
    }

    private Document finalizeAndProcess() {
        this.closeBlockParsers(this.openBlockParsers.size());
        this.processInlines();
        return this.documentBlockParser.getBlock();
    }

    private void closeBlockParsers(int n) {
        for (int i = 0; i < n; ++i) {
            BlockParser blockParser = this.deactivateBlockParser().blockParser;
            this.finalize(blockParser);
            this.allBlockParsers.add(blockParser);
        }
    }

    private void finalize(BlockParser blockParser) {
        this.addDefinitionsFrom(blockParser);
        blockParser.closeBlock();
    }

    private void addDefinitionsFrom(BlockParser blockParser) {
        for (DefinitionMap<?> definitionMap : blockParser.getDefinitions()) {
            this.definitions.addDefinitions(definitionMap);
        }
    }

    private static String prepareLine(String string) {
        if (string.indexOf(0) == -1) {
            return string;
        }
        return string.replace('\u0000', '\ufffd');
    }

    static {
        HashMap<Class<IndentedCodeBlock>, AbstractBlockParserFactory> hashMap = new HashMap<Class<IndentedCodeBlock>, AbstractBlockParserFactory>();
        hashMap.put(BlockQuote.class, new BlockQuoteParser.Factory());
        hashMap.put(Heading.class, new HeadingParser.Factory());
        hashMap.put(FencedCodeBlock.class, new FencedCodeBlockParser.Factory());
        hashMap.put(HtmlBlock.class, new HtmlBlockParser.Factory());
        hashMap.put(ThematicBreak.class, new ThematicBreakParser.Factory());
        hashMap.put(ListBlock.class, new ListBlockParser.Factory());
        hashMap.put(IndentedCodeBlock.class, new IndentedCodeBlockParser.Factory());
        NODES_TO_CORE_FACTORIES = Collections.unmodifiableMap(hashMap);
    }

    private static class OpenBlockParser {
        private final BlockParser blockParser;
        private int sourceIndex;

        OpenBlockParser(BlockParser blockParser, int n) {
            this.blockParser = blockParser;
            this.sourceIndex = n;
        }
    }

    private static class MatchedBlockParserImpl
    implements MatchedBlockParser {
        private final BlockParser matchedBlockParser;

        public MatchedBlockParserImpl(BlockParser blockParser) {
            this.matchedBlockParser = blockParser;
        }

        @Override
        public BlockParser getMatchedBlockParser() {
            return this.matchedBlockParser;
        }

        @Override
        public SourceLines getParagraphLines() {
            if (this.matchedBlockParser instanceof ParagraphParser) {
                ParagraphParser paragraphParser = (ParagraphParser)this.matchedBlockParser;
                return paragraphParser.getParagraphLines();
            }
            return SourceLines.empty();
        }
    }
}

