/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.List;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterRun;

public class Delimiter
implements DelimiterRun {
    public final List<Text> characters;
    public final char delimiterChar;
    private final int originalLength;
    private final boolean canOpen;
    private final boolean canClose;
    public Delimiter previous;
    public Delimiter next;

    public Delimiter(List<Text> list, char c, boolean bl, boolean bl2, Delimiter delimiter) {
        this.characters = list;
        this.delimiterChar = c;
        this.canOpen = bl;
        this.canClose = bl2;
        this.previous = delimiter;
        this.originalLength = list.size();
    }

    @Override
    public boolean canOpen() {
        return this.canOpen;
    }

    @Override
    public boolean canClose() {
        return this.canClose;
    }

    @Override
    public int length() {
        return this.characters.size();
    }

    @Override
    public int originalLength() {
        return this.originalLength;
    }

    @Override
    public Text getOpener() {
        return this.characters.get(this.characters.size() - 1);
    }

    @Override
    public Text getCloser() {
        return this.characters.get(0);
    }

    @Override
    public Iterable<Text> getOpeners(int n) {
        if (n < 1 || n > this.length()) {
            throw new IllegalArgumentException("length must be between 1 and " + this.length() + ", was " + n);
        }
        return this.characters.subList(this.characters.size() - n, this.characters.size());
    }

    @Override
    public Iterable<Text> getClosers(int n) {
        if (n < 1 || n > this.length()) {
            throw new IllegalArgumentException("length must be between 1 and " + this.length() + ", was " + n);
        }
        return this.characters.subList(0, n);
    }
}

