/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.text.Characters;

public class BlockQuoteParser
extends AbstractBlockParser {
    private final BlockQuote block = new BlockQuote();

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block block) {
        return true;
    }

    @Override
    public BlockQuote getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        int n = parserState.getNextNonSpaceIndex();
        if (BlockQuoteParser.isMarker(parserState, n)) {
            int n2 = parserState.getColumn() + parserState.getIndent() + 1;
            if (Characters.isSpaceOrTab(parserState.getLine().getContent(), n + 1)) {
                ++n2;
            }
            return BlockContinue.atColumn(n2);
        }
        return BlockContinue.none();
    }

    private static boolean isMarker(ParserState parserState, int n) {
        CharSequence charSequence = parserState.getLine().getContent();
        return parserState.getIndent() < Parsing.CODE_BLOCK_INDENT && n < charSequence.length() && charSequence.charAt(n) == '>';
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState parserState, MatchedBlockParser matchedBlockParser) {
            int n = parserState.getNextNonSpaceIndex();
            if (BlockQuoteParser.isMarker(parserState, n)) {
                int n2 = parserState.getColumn() + parserState.getIndent() + 1;
                if (Characters.isSpaceOrTab(parserState.getLine().getContent(), n + 1)) {
                    ++n2;
                }
                return BlockStart.of(new BlockQuoteParser()).atColumn(n2);
            }
            return BlockStart.none();
        }
    }
}

